/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.SystemExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.execution.FlowProcessMediator;
import org.mule.runtime.core.internal.execution.FlowProcessTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.MessageProcessingManager;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.policy.PolicyManager;

public class MuleMessageProcessingManager
implements MessageProcessingManager,
Initialisable,
PhaseResultNotifier {
    private PolicyManager policyManager;
    private MuleContext muleContext;
    private FlowProcessMediator mediator;
    private SystemExceptionHandler exceptionListener;

    @Override
    public void initialise() throws InitialisationException {
        this.exceptionListener = this.muleContext.getExceptionListener();
        this.mediator = new FlowProcessMediator(this.policyManager, this);
        LifecycleUtils.initialiseIfNeeded(this.mediator, this.muleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessage(FlowProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalTCCL = currentThread.getContextClassLoader();
        ClassLoader executionClassLoader = messageProcessContext.getExecutionClassLoader();
        ClassUtils.setContextClassLoader(currentThread, originalTCCL, executionClassLoader);
        try {
            this.mediator.process(messageProcessTemplate, messageProcessContext);
        }
        finally {
            ClassUtils.setContextClassLoader(currentThread, executionClassLoader, originalTCCL);
        }
    }

    @Override
    public void phaseSuccessfully() {
    }

    @Override
    public void phaseFailure(Exception reason) {
        this.exceptionListener.handleException(reason);
    }

    @Inject
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Inject
    public void setPolicyManager(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }
}

