/*
 * Decompiled with CFR 0.152.
 */
package org.mule.sdk.api.metadata;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.sdk.api.metadata.MetadataKey;
import org.mule.sdk.api.metadata.MetadataProperty;

public final class DefaultMetadataKey
implements MetadataKey {
    private static final String LIST_SEPARATOR = ", ";
    private final String id;
    private final String displayName;
    private final String partName;
    private final Map<Class<? extends MetadataProperty>, MetadataProperty> properties;
    private final Set<MetadataKey> childs;

    protected DefaultMetadataKey(String id, String displayName, Set<MetadataProperty> properties, Set<MetadataKey> childs, String partName) {
        this.id = id;
        this.displayName = displayName;
        this.childs = childs;
        this.properties = Collections.unmodifiableMap(properties.stream().collect(Collectors.toMap(Object::getClass, p -> p)));
        this.partName = partName;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<MetadataKey> getChilds() {
        return Collections.unmodifiableSet(this.childs);
    }

    @Override
    public String getPartName() {
        return this.partName;
    }

    @Override
    public <T extends MetadataProperty> Optional<T> getMetadataProperty(Class<T> propertyType) {
        return Optional.ofNullable(this.properties.get(propertyType));
    }

    @Override
    public Set<MetadataProperty> getProperties() {
        return Collections.unmodifiableSet(new HashSet<MetadataProperty>(this.properties.values()));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.partName, this.properties, this.childs);
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(org.mule.runtime.api.metadata.DefaultMetadataKey.class)) {
            return false;
        }
        DefaultMetadataKey that = (DefaultMetadataKey)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.partName, that.partName) && Objects.equals(this.properties, that.properties) && Objects.equals(this.childs, that.childs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.append("{").append("id: ").append(this.id).append(LIST_SEPARATOR).append("displayName: ").append(this.displayName).append(LIST_SEPARATOR).append("partName: ").append(this.partName).append(LIST_SEPARATOR).append("childs: ").append(this.childs).append(LIST_SEPARATOR).append("properties: ").append(this.properties.values().stream().map(MetadataProperty::getName).collect(Collectors.joining(LIST_SEPARATOR))).append("}").toString();
    }
}

