/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PagingProviderWrapper<C, T>
implements PagingProvider<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagingProviderWrapper.class);
    private final PagingProvider<C, T> delegate;
    private final ClassLoader extensionClassLoader;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public PagingProviderWrapper(PagingProvider<C, T> delegate, ExtensionModel extensionModel) {
        this.delegate = delegate;
        this.extensionClassLoader = MuleExtensionUtils.getClassLoader(extensionModel);
    }

    @Override
    public void close(C connection) throws MuleException {
        if (this.closed.compareAndSet(false, true)) {
            this.delegate.close(connection);
        }
    }

    private void handleCloseException(Throwable t) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Exception was found trying to close paging delegate. Execution will continue", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> getPage(C connection) {
        if (this.closed.get()) {
            LOGGER.debug("paging delegate is closed. Returning null");
            return null;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        ClassUtils.setContextClassLoader(currentThread, currentClassLoader, this.extensionClassLoader);
        try {
            List page = this.delegate.getPage(connection);
            if (CollectionUtils.isEmpty(page)) {
                try {
                    LOGGER.debug("Empty page was obtained. Closing delegate since this means that the data source has been consumed");
                    this.close(connection);
                }
                catch (Exception e) {
                    this.handleCloseException(e);
                }
            }
            List list = page;
            return list;
        }
        finally {
            ClassUtils.setContextClassLoader(currentThread, this.extensionClassLoader, currentClassLoader);
        }
    }

    @Override
    public Optional<Integer> getTotalResults(C connection) {
        Optional<Integer> size = this.delegate.getTotalResults(connection);
        return size != null ? size : Optional.empty();
    }

    @Override
    public boolean useStickyConnections() {
        return this.delegate.useStickyConnections();
    }
}

