/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Map;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.config.internal.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

class BaseSpringMuleContextServiceConfigurator
extends AbstractSpringMuleContextServiceConfigurator {
    private Registry originalRegistry;

    public BaseSpringMuleContextServiceConfigurator(MuleContext muleContext, BeanDefinitionRegistry beanDefinitionRegistry, org.mule.runtime.api.artifact.Registry serviceLocator, Registry originalRegistry) {
        super((CustomServiceRegistry)muleContext.getCustomizationService(), beanDefinitionRegistry, serviceLocator);
        this.originalRegistry = originalRegistry;
    }

    void createArtifactServices() {
        this.registerConstantBeanDefinition("core.featureFlaggingService", this.originalRegistry.lookupObject("core.featureFlaggingService"));
        this.registerConstantBeanDefinition("_muleConfigurationComponentLocator", new BaseConfigurationComponentLocator());
        ContributedErrorTypeRepository contributedErrorTypeRepository = new ContributedErrorTypeRepository();
        this.registerConstantBeanDefinition(ErrorTypeRepository.class.getName(), contributedErrorTypeRepository);
        ContributedErrorTypeLocator contributedErrorTypeLocator = new ContributedErrorTypeLocator();
        contributedErrorTypeLocator.setDelegate(ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(contributedErrorTypeRepository));
        this.registerConstantBeanDefinition(ErrorTypeLocator.class.getName(), contributedErrorTypeLocator);
        this.createRuntimeServices();
        this.absorbOriginalRegistry();
    }

    private void createRuntimeServices() {
        Map<String, CustomService> customServices = this.getCustomServiceRegistry().getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = customServices.get(serviceName);
            if (!this.isServiceRuntimeProvided(customService)) continue;
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService, serviceName);
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void absorbOriginalRegistry() {
        if (this.originalRegistry == null) {
            return;
        }
        this.originalRegistry.lookupByType(Object.class).forEach((key, value) -> this.registerConstantBeanDefinition((String)key, value));
        this.originalRegistry = null;
    }
}

