/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.declaration;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ComponentElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.HasNestedComponentDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterGroupElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedBuilder;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SimpleValueType;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.TopLevelParameterDeclarer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.api.xml.AstXmlParserAttribute;
import org.mule.runtime.config.internal.dsl.XmlConstants;
import org.mule.runtime.config.internal.dsl.model.XmlArtifactDeclarationLoader;
import org.mule.runtime.config.internal.dsl.model.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.dsl.model.config.EnvironmentPropertiesConfigurationProvider;
import org.mule.runtime.config.internal.dsl.model.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.LayoutOrderComparator;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.internal.dsl.DslConstants;

public class AstXmlArtifactDeclarationLoader
implements XmlArtifactDeclarationLoader {
    private final DslResolvingContext context;
    private final AstXmlParser parser;

    public AstXmlArtifactDeclarationLoader(DslResolvingContext context) {
        this.context = context;
        DefaultConfigurationPropertiesResolver propertyResolver = new DefaultConfigurationPropertiesResolver(Optional.of(new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider())), new EnvironmentPropertiesConfigurationProvider());
        this.parser = AstXmlParser.builder().withSchemaValidationsDisabled().withPropertyResolver(propertyKey -> (String)propertyResolver.resolveValue(propertyKey)).withExtensionModels(context.getExtensions()).build();
    }

    @Override
    public ArtifactDeclaration load(InputStream configResource) {
        return this.load("app.xml", configResource);
    }

    @Override
    public ArtifactDeclaration load(String name, InputStream configResource) {
        return this.declareArtifact(this.loadArtifactAst(name, configResource));
    }

    private ArtifactAst loadArtifactAst(String name, InputStream resource) {
        Preconditions.checkArgument((resource != null ? 1 : 0) != 0, (Object)"The given application was not found as resource");
        return this.parser.parse(name, resource);
    }

    public static List<XmlNamespaceInfoProvider> createFromPluginClassloaders(Function<ClassLoader, List<XmlNamespaceInfoProvider>> xmlNamespaceInfoProvidersSupplier, List<ClassLoader> pluginsClassLoaders) {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(Thread.currentThread().getContextClassLoader()));
        for (ClassLoader pluginClassLoader : pluginsClassLoaders) {
            namespaceInfoProvidersBuilder.addAll((Iterable)xmlNamespaceInfoProvidersSupplier.apply(pluginClassLoader));
        }
        return namespaceInfoProvidersBuilder.build();
    }

    private ArtifactDeclaration declareArtifact(ArtifactAst artifact) {
        ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        StringBuilder schemaLocations = new StringBuilder();
        artifactDeclarer.withCustomParameter("xmlns", DslConstants.CORE_NAMESPACE);
        schemaLocations.append(DslConstants.CORE_NAMESPACE + " " + DslConstants.CORE_SCHEMA_LOCATION + " ");
        ArrayList namespacesOrdered = new ArrayList();
        artifact.recursiveStream().forEach(c -> {
            if (!namespacesOrdered.contains(c.getIdentifier().getNamespaceUri())) {
                namespacesOrdered.add(c.getIdentifier().getNamespaceUri());
            }
        });
        artifact.dependencies().stream().filter(em -> !em.getXmlDslModel().getNamespace().equals(DslConstants.CORE_NAMESPACE)).sorted((em1, em2) -> namespacesOrdered.indexOf(em1.getXmlDslModel().getNamespace()) - namespacesOrdered.indexOf(em2.getXmlDslModel().getNamespace())).map(ExtensionModel::getXmlDslModel).forEach(dslModel -> {
            artifactDeclarer.withCustomParameter("xmlns:" + dslModel.getPrefix(), dslModel.getNamespace());
            schemaLocations.append(dslModel.getNamespace() + " " + dslModel.getSchemaLocation() + " ");
        });
        if (artifact.recursiveStream().anyMatch(c -> !c.getMetadata().getDocAttributes().isEmpty())) {
            artifactDeclarer.withCustomParameter("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation");
        }
        artifactDeclarer.withCustomParameter("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        artifactDeclarer.withCustomParameter("xsi:schemaLocation", schemaLocations.toString().trim());
        artifact.topLevelComponentsStream().forEach(c -> this.declareElement((ComponentAst)c, artifactDeclarer));
        return (ArtifactDeclaration)artifactDeclarer.getDeclaration();
    }

    private void declareElement(ComponentAst component, ArtifactDeclarer artifactDeclarer) {
        ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(component.getExtensionModel().getName());
        component.getModel(ConstructModel.class).map(model -> {
            ConstructElementDeclarer declarer = extensionElementsDeclarer.newConstruct(model.getName());
            this.declareComponentModel(component, (ComponentModel)model, declarer);
            return declarer;
        }).ifPresent(declarer -> {
            component.getComponentId().filter(id -> !"_muleConfiguration".equals(id)).ifPresent(declarer::withRefName);
            artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.getDeclaration());
        });
        component.getModel(ConfigurationModel.class).ifPresent(model -> {
            ConfigurationElementDeclarer configurationDeclarer = extensionElementsDeclarer.newConfiguration(model.getName());
            component.getComponentId().ifPresent(configurationDeclarer::withRefName);
            Map<String, String> attributes = this.resolveAttributes(component, param -> !param.getModel().isComponentId());
            component.directChildrenStream().filter(config -> this.declareAsConnectionProvider(component.getExtensionModel(), (ConfigurationModel)model, configurationDeclarer, (ComponentAst)config, extensionElementsDeclarer)).collect(Collectors.toList());
            this.declareParameterizedComponent((ParameterizedModel)model, component.getGenerationInformation().getSyntax().get(), configurationDeclarer, attributes, component);
            artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationDeclarer.getDeclaration());
        });
        MetadataType type = component.getType();
        if (type != null) {
            TopLevelParameterDeclarer topLevelParameter = extensionElementsDeclarer.newGlobalParameter(component.getIdentifier().getName());
            component.getComponentId().ifPresent(topLevelParameter::withRefName);
            type.accept(this.getParameterDeclarerVisitor(component, component.getGenerationInformation().getSyntax().get(), value -> topLevelParameter.withValue((ParameterObjectValue)value)));
            artifactDeclarer.withGlobalElement((GlobalElementDeclaration)topLevelParameter.getDeclaration());
        }
    }

    private void declareComponent(Consumer<ComponentElementDeclaration> declarationConsumer, ComponentAst component, ElementDeclarer extensionElementsDeclarer) {
        component.getModel(OperationModel.class).map(model -> {
            OperationElementDeclarer declarer = extensionElementsDeclarer.newOperation(model.getName());
            this.declareComponentModel(component, (ComponentModel)model, declarer);
            return (OperationElementDeclaration)declarer.getDeclaration();
        }).ifPresent(declarationConsumer::accept);
        component.getModel(SourceModel.class).map(model -> {
            SourceElementDeclarer declarer = extensionElementsDeclarer.newSource(model.getName());
            this.declareComponentModel(component, (ComponentModel)model, declarer);
            return (SourceElementDeclaration)declarer.getDeclaration();
        }).ifPresent(declarationConsumer::accept);
        component.getModel(ConstructModel.class).map(model -> {
            ConstructElementDeclarer declarer = extensionElementsDeclarer.newConstruct(model.getName());
            this.declareComponentModel(component, (ComponentModel)model, declarer);
            return (ConstructElementDeclaration)declarer.getDeclaration();
        }).ifPresent(declarationConsumer::accept);
        component.getModel(NestedComponentModel.class).map(model -> {
            ConstructElementDeclarer declarer = extensionElementsDeclarer.newConstruct(model.getName());
            this.declareComponentModel(component, (ComponentModel)model, declarer);
            return (ConstructElementDeclaration)declarer.getDeclaration();
        }).ifPresent(declarationConsumer::accept);
    }

    private MetadataType getGroupParameterType(Optional<ParameterGroupModel> messageParameterGroup, String paramName) {
        MetadataType metadataType = null;
        if (messageParameterGroup.isPresent()) {
            metadataType = this.getGroupParameterType(messageParameterGroup.get(), paramName);
        }
        return metadataType;
    }

    private MetadataType getGroupParameterType(ParameterGroupModel model, String paramName) {
        MetadataType metadataType = null;
        Optional<ParameterModel> parameter = model.getParameter(paramName);
        if (parameter.isPresent()) {
            metadataType = model.getParameter(paramName).get().getType();
        }
        return metadataType;
    }

    private boolean declareAsConnectionProvider(ExtensionModel ownerExtension, ConfigurationModel model, ConfigurationElementDeclarer configurationDeclarer, ComponentAst component, ElementDeclarer extensionElementsDeclarer) {
        Optional connectionProvider = component.getModel(NamedObject.class).flatMap(namedModel -> model.getConnectionProviderModel(namedModel.getName()));
        if (!connectionProvider.isPresent()) {
            connectionProvider = component.getModel(NamedObject.class).flatMap(namedModel -> ownerExtension.getConnectionProviderModel(namedModel.getName()));
        }
        if (!connectionProvider.isPresent()) {
            return true;
        }
        ConnectionProviderModel providerModel = (ConnectionProviderModel)connectionProvider.get();
        ConnectionElementDeclarer connectionDeclarer = extensionElementsDeclarer.newConnection(providerModel.getName());
        this.declareParameterizedComponent(providerModel, component.getGenerationInformation().getSyntax().get(), connectionDeclarer, this.resolveAttributes(component, (Predicate<ComponentParameterAst>)Predicates.alwaysTrue()), component);
        configurationDeclarer.withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
        return false;
    }

    private void declareComponentModel(ComponentAst component, ComponentModel model, ComponentElementDeclarer declarer) {
        ComponentParameterAst parameter = component.getParameter("General", "config-ref");
        if (parameter != null) {
            declarer.withConfig(parameter.getResolvedRawValue());
        }
        DslElementSyntax elementDsl = component.getGenerationInformation().getSyntax().get();
        model.getParameterGroupModels().forEach(group -> this.declareParameterGroup(component, model, declarer, elementDsl, (ParameterGroupModel)group, model.getParameterGroupModels().get(0) == group, pm -> component.getParameter(group.getName(), pm.getName())));
        if (model instanceof SourceModel) {
            ((SourceModel)model).getSuccessCallback().ifPresent(callbackModel -> callbackModel.getParameterGroupModels().forEach(group -> this.declareParameterGroup(component, model, declarer, elementDsl, (ParameterGroupModel)group, false, pm -> component.getParameter(group.getName(), pm.getName()))));
            ((SourceModel)model).getErrorCallback().ifPresent(callbackModel -> callbackModel.getParameterGroupModels().forEach(group -> this.declareParameterGroup(component, model, declarer, elementDsl, (ParameterGroupModel)group, false, pm -> component.getParameter(group.getName(), pm.getName()))));
        }
        this.declareComposableModel(model, elementDsl, component, declarer);
    }

    private void declareParameterGroup(ComponentAst component, ComponentModel model, ComponentElementDeclarer declarer, DslElementSyntax elementDsl, ParameterGroupModel group, boolean processDocAttributes, Function<? super ParameterModel, ? extends ComponentParameterAst> mapper) {
        List<ComponentParameterAst> groupParams = group.getParameterModels().stream().map(mapper).filter(p -> p != null).collect(Collectors.toList());
        ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(group.getName());
        Map<String, ComponentParameterAst> groupAttributes = this.resolveParams(component, param -> groupParams.contains(param));
        if (group.isShowInDsl()) {
            if (groupParams.stream().anyMatch(p -> p.getValue().getValue().isPresent())) {
                this.declareInlineGroup(component, elementDsl, group, processDocAttributes, groupParams, groupDeclarer, groupAttributes);
            }
        } else {
            this.copyExplicitAttributeParams(groupAttributes, declarer, model);
            if (processDocAttributes) {
                this.copyExplicitAttributes(model, this.resolveDocAttributes(component), declarer);
            }
            this.declareNonInlineParameterGroup(declarer, component, elementDsl, group, groupDeclarer);
        }
        if (!((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration()).getParameters().isEmpty()) {
            declarer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
        }
    }

    private void declareNonInlineParameterGroup(ParameterizedElementDeclarer<?, ?> declarer, ComponentAst paramsOwner, DslElementSyntax elementDsl, ParameterGroupModel group, ParameterGroupElementDeclarer groupDeclarer) {
        group.getParameterModels().stream().forEach(param -> elementDsl.getChild(param.getName()).ifPresent(paramDsl -> {
            Object paramValue = paramsOwner.getParameter(group.getName(), param.getName()).getValue().getRight();
            if (paramValue == null) {
                return;
            }
            param.getType().accept(this.getParameterDeclarerVisitor(paramValue, (DslElementSyntax)paramDsl, value -> groupDeclarer.withParameter(param.getName(), (ParameterValue)value)));
        }));
    }

    private Map<String, String> resolveAttributes(ComponentAst component, Predicate<ComponentParameterAst> additionalFilter) {
        return this.resolveAttributes(component, additionalFilter, true);
    }

    private Map<String, String> resolveAttributes(ComponentAst component, Predicate<ComponentParameterAst> additionalFilter, boolean processDocAttributes) {
        Map<String, String> attributes = component.getParameters().stream().filter(param -> param.getRawValue() != null).filter(additionalFilter).collect(Collectors.toMap(param -> param.getModel().getName(), param -> param.getRawValue()));
        if (processDocAttributes) {
            attributes.putAll(this.resolveDocAttributes(component));
        }
        return attributes;
    }

    private Map<String, ComponentParameterAst> resolveParams(ComponentAst component, Predicate<ComponentParameterAst> additionalFilter) {
        return component.getParameters().stream().filter(param -> param.getRawValue() != null).filter(additionalFilter).collect(Collectors.toMap(param -> param.getModel().getName(), param -> param));
    }

    private Map<String, String> resolveDocAttributes(ComponentAst component) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        component.getMetadata().getDocAttributes().entrySet().stream().forEach(docAttr -> XmlConstants.buildRawParamKeyForDocAttribute(docAttr).ifPresent(key -> {
            String cfr_ignored_0 = (String)attributes.put((String)key, (String)docAttr.getValue());
        }));
        return attributes;
    }

    private void declareComposableModel(ComposableModel model, DslElementSyntax elementDsl, ComponentAst composableComponent, HasNestedComponentDeclarer declarer) {
        composableComponent.directChildrenStream().forEach(child -> {
            ElementDeclarer extensionElementsDeclarer = ElementDeclarer.forExtension(child.getExtensionModel().getName());
            Reference<Boolean> componentFound = new Reference<Boolean>(false);
            this.declareRoute(model, elementDsl, (ComponentAst)child, extensionElementsDeclarer).ifPresent(route -> {
                declarer.withComponent((ComponentElementDeclaration)route);
                componentFound.set(true);
            });
            if (!componentFound.get().booleanValue()) {
                this.declareComponent(declaration -> declarer.withComponent((ComponentElementDeclaration)declaration), (ComponentAst)child, extensionElementsDeclarer);
            }
        });
    }

    private Optional<RouteElementDeclaration> declareRoute(ComposableModel model, DslElementSyntax elementDsl, ComponentAst child, ElementDeclarer extensionElementsDeclarer) {
        return model.getNestedComponents().stream().filter(nestedModel -> child.getModel(NestedRouteModel.class).map(nem -> nem.equals(nestedModel)).orElse(false)).findFirst().map(nestedModel -> {
            RouteElementDeclarer routeDeclarer = extensionElementsDeclarer.newRoute(nestedModel.getName());
            DslElementSyntax routeDsl = elementDsl.getContainedElement(nestedModel.getName()).get();
            Map<String, String> attributes = this.resolveAttributes(child, (Predicate<ComponentParameterAst>)Predicates.alwaysTrue());
            this.declareParameterizedComponent((ParameterizedModel)nestedModel, routeDsl, routeDeclarer, attributes, child);
            this.declareComposableModel((ComposableModel)nestedModel, elementDsl, child, routeDeclarer);
            return (RouteElementDeclaration)routeDeclarer.getDeclaration();
        });
    }

    private void declareParameterizedComponent(ParameterizedModel model, DslElementSyntax elementDsl, ParameterizedElementDeclarer declarer, Map<String, String> rawParams, ComponentAst component) {
        this.copyExplicitAttributes(model, rawParams, declarer);
        this.declareChildParameters(model, elementDsl, component, declarer);
    }

    private void declareChildParameters(ParameterizedModel model, DslElementSyntax modelDsl, ComponentAst component, ParameterizedElementDeclarer declarer) {
        model.getParameterGroupModels().forEach(group -> {
            ParameterGroupElementDeclarer groupDeclarer = ElementDeclarer.newParameterGroup(group.getName());
            if (group.isShowInDsl()) {
                List<ComponentParameterAst> groupParams = group.getParameterModels().stream().map(pm -> component.getParameter(group.getName(), pm.getName())).filter(p -> p != null).collect(Collectors.toList());
                if (groupParams.stream().anyMatch(p -> p.getValue().getValue().isPresent())) {
                    this.declareInlineGroup(component, component.getGenerationInformation().getSyntax().get(), (ParameterGroupModel)group, true, groupParams, groupDeclarer, this.resolveParams(component, param -> groupParams.contains(param)));
                }
            } else {
                this.declareNonInlineParameterGroup(declarer, component, modelDsl, (ParameterGroupModel)group, groupDeclarer);
            }
            if (!((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration()).getParameters().isEmpty()) {
                declarer.withParameterGroup((ParameterGroupElementDeclaration)groupDeclarer.getDeclaration());
            }
        });
    }

    private void declareInlineGroup(ComponentAst component, DslElementSyntax elementDsl, ParameterGroupModel group, boolean processDocAttributes, List<ComponentParameterAst> groupParams, ParameterGroupElementDeclarer groupDeclarer, Map<String, ComponentParameterAst> groupAttributes) {
        this.copyExplicitAttributeParams(groupAttributes, groupDeclarer, group);
        if (processDocAttributes) {
            this.copyExplicitAttributes(this.resolveDocAttributes(component), groupDeclarer, group);
        }
        this.declareComplexParameterValue(group, elementDsl.getChild(group.getName()).get(), groupParams.stream().filter(p -> p.getValue() != null && p.getValue().isRight() && p.getValue().getRight() instanceof ComponentAst), groupDeclarer);
    }

    private void declareComplexParameterValue(ParameterGroupModel group, DslElementSyntax groupDsl, Stream<ComponentParameterAst> groupChildren, ParameterizedBuilder<String, ParameterValue, ?> groupBuilder) {
        groupChildren.forEach(child -> group.getParameterModels().stream().filter(paramModel -> paramModel.equals(child.getModel())).findFirst().ifPresent(param -> param.getType().accept(this.getParameterDeclarerVisitor(child.getValue().getRight(), groupDsl.getChild(param.getName()).get(), value -> groupBuilder.withParameter(param.getName(), (ParameterValue)value)))));
    }

    private MetadataTypeVisitor getParameterDeclarerVisitor(final Object paramValue, final DslElementSyntax paramDsl, final Consumer<ParameterValue> valueConsumer) {
        return new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                ParameterListValue.Builder listBuilder = ElementDeclarer.newListValue();
                ((Collection)paramValue).forEach(item -> arrayType.getType().accept(AstXmlArtifactDeclarationLoader.this.getParameterDeclarerVisitor(item, paramDsl.getGeneric(arrayType.getType()).get(), listBuilder::withValue)));
                valueConsumer.accept(listBuilder.build());
            }

            @Override
            public void visitObject(ObjectType objectType) {
                ParameterObjectValue.Builder objectValue = ElementDeclarer.newObjectValue();
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    AstXmlArtifactDeclarationLoader.this.createMapValue(objectValue, (Collection)paramValue, objectType.getOpenRestriction().orElse(null));
                } else if (paramDsl.isWrapped()) {
                    AstXmlArtifactDeclarationLoader.this.createWrappedObject(objectType, objectValue, (ComponentAst)paramValue);
                } else {
                    AstXmlArtifactDeclarationLoader.this.createObjectValueFromType(objectType, objectValue, (ComponentAst)paramValue, paramDsl);
                }
                valueConsumer.accept(objectValue.build());
            }

            @Override
            public void visitUnion(UnionType unionType) {
                MetadataType actualType = AstXmlArtifactDeclarationLoader.this.getChildMetadataTypeFromUnion(unionType, ((ComponentAst)paramValue).getIdentifier().getName());
                this.visitObject((ObjectType)actualType);
            }
        };
    }

    private void createMapValue(ParameterObjectValue.Builder objectValue, Collection<ComponentAst> items, MetadataType elementMetadataType) {
        items.forEach(comp -> {
            ComponentParameterAst keyParam = comp.getParameter("General", "key");
            ComponentParameterAst valueParam = comp.getParameter("General", "value");
            if (keyParam != null && keyParam.getRawValue() != null && valueParam != null && valueParam.getRawValue() != null) {
                objectValue.withParameter(keyParam.getRawValue(), this.createParameterSimpleValue(valueParam.getRawValue(), elementMetadataType));
            }
        });
    }

    private void createWrappedObject(ObjectType objectType, ParameterObjectValue.Builder objectValue, ComponentAst wrappedConfig) {
        Set<ObjectType> subTypes = this.context.getTypeCatalog().getSubTypes(objectType);
        if (!subTypes.isEmpty()) {
            subTypes.stream().filter(subType -> wrappedConfig.getModel(MetadataTypeAdapter.class).map(mtma -> mtma.isWrapperFor((MetadataType)subType)).orElse(false)).findFirst().ifPresent(subType -> this.createObjectValueFromType((ObjectType)subType, objectValue, wrappedConfig, wrappedConfig.getGenerationInformation().getSyntax().get()));
        } else {
            this.createObjectValueFromType(objectType, objectValue, wrappedConfig, wrappedConfig.getGenerationInformation().getSyntax().get());
        }
    }

    private void createObjectValueFromType(ObjectType objectType, ParameterObjectValue.Builder objectValue, ComponentAst component, DslElementSyntax paramDsl) {
        ExtensionMetadataTypeUtils.getId(objectType).filter(id -> !id.equals("SetPayload") && !id.equals("SetAttributes") && !id.equals("SetVariable")).ifPresent(objectValue::ofType);
        ComponentParameterAst configRefParam = component.getParameter(NameUtils.getAliasName(objectType), "config-ref");
        if (configRefParam != null && configRefParam.getRawValue() != null) {
            objectValue.withParameter("config-ref", ParameterSimpleValue.of(configRefParam.getRawValue(), SimpleValueType.STRING));
        }
        this.copyExplicitAttributes(this.resolveAttributes(component, param -> !param.getModel().isComponentId()), objectValue, objectType);
        ArrayList<ObjectFieldType> fields = new ArrayList<ObjectFieldType>(objectType.getFields());
        Collections.sort(fields, LayoutOrderComparator.OBJECTS_FIELDS_BY_LAYOUT_ORDER);
        fields.forEach(fieldType -> {
            ComponentParameterAst param = component.getParameter(this.resolveGroupName(objectType), MetadataTypeUtils.getLocalPart(fieldType));
            if (param != null && param.getValue().getRight() != null && param.getValue().getRight() instanceof ComponentAst) {
                fieldType.getValue().accept(this.getParameterDeclarerVisitor(param.getValue().getRight(), paramDsl.getContainedElement(MetadataTypeUtils.getLocalPart(fieldType)).get(), fieldValue -> objectValue.withParameter(MetadataTypeUtils.getLocalPart(fieldType), (ParameterValue)fieldValue)));
            }
        });
    }

    private String resolveGroupName(ObjectType objectType) {
        String aliasName;
        try {
            aliasName = NameUtils.getAliasName(objectType);
        }
        catch (IllegalArgumentException e) {
            aliasName = "General";
        }
        return aliasName;
    }

    private MetadataType getChildMetadataType(MetadataType parentMetadataType, String modelParamName) {
        return this.getChildMetadataType(parentMetadataType, modelParamName, modelParamName);
    }

    private MetadataType getChildMetadataType(MetadataType parentMetadataType, String configParamName, String modelParamName) {
        MetadataType childMetadataType;
        if (parentMetadataType instanceof ObjectFieldType) {
            parentMetadataType = ((ObjectFieldType)parentMetadataType).getValue();
        }
        if (parentMetadataType instanceof ObjectType) {
            childMetadataType = this.getMetadataTypeFromObjectType((ObjectType)parentMetadataType, configParamName, modelParamName);
        } else if (parentMetadataType instanceof UnionType) {
            childMetadataType = this.getChildMetadataTypeFromUnion((UnionType)parentMetadataType, modelParamName);
        } else if (parentMetadataType instanceof ArrayType) {
            childMetadataType = this.getChildMetadataType(((ArrayType)parentMetadataType).getType(), modelParamName, configParamName);
        } else {
            throw new IllegalStateException("Cannot obtain child parameter type from " + parentMetadataType.getClass().getName());
        }
        return childMetadataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetadataType getMetadataTypeFromObjectType(ObjectType objectMetadataType, String configParamName, String modelParamName) {
        Optional<ObjectFieldType> fieldByName = objectMetadataType.getFieldByName(configParamName);
        if (!fieldByName.isPresent()) return this.getMetadataTypeFromFlattenedFields(objectMetadataType, modelParamName);
        ObjectFieldType objectFieldType = fieldByName.get();
        if (objectFieldType.getValue() instanceof ObjectType) {
            return objectFieldType;
        }
        if (objectFieldType.getValue() instanceof SimpleType) {
            return objectFieldType.getValue();
        }
        if (!(objectFieldType.getValue() instanceof UnionType)) throw new IllegalStateException("Unsupported attribute type: " + objectFieldType.getValue().getClass().getName());
        return this.getChildMetadataTypeFromUnion((UnionType)objectFieldType.getValue(), modelParamName);
    }

    private MetadataType getChildMetadataTypeFromUnion(UnionType parentMetadataType, String modelParamName) {
        Optional<MetadataType> result = parentMetadataType.getTypes().stream().filter(metadataType -> metadataType.getAnnotation(TypeIdAnnotation.class).get().getValue().equals(modelParamName)).findFirst();
        return result.orElse(null);
    }

    private MetadataType getMetadataTypeFromFlattenedFields(ObjectType objectMetadataType, String modelParamName) {
        MetadataType childMetadataType = null;
        List flattenedFieldTypes = objectMetadataType.getFields().stream().filter(field -> field.getAnnotation(FlattenedTypeAnnotation.class).isPresent()).map(ObjectFieldType::getValue).collect(Collectors.toList());
        for (MetadataType flattenedFieldType : flattenedFieldTypes) {
            for (ObjectFieldType field2 : ((ObjectType)flattenedFieldType).getFields()) {
                if (!field2.getKey().getName().getLocalPart().equals(modelParamName)) continue;
                childMetadataType = field2.getValue();
                break;
            }
            if (childMetadataType == null) continue;
            break;
        }
        return childMetadataType;
    }

    private void cloneAsDeclaration(ComponentAst component, ParameterObjectValue.Builder objectValue, MetadataType metadataType) {
        this.copyExplicitAttributes(this.resolveAttributes(component, param -> !param.getModel().isComponentId()), objectValue, metadataType);
        this.copyChildren(component, objectValue, metadataType);
    }

    private void copyExplicitAttributes(Map<String, String> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder, ParameterGroupModel group) {
        attributes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("config-ref")).forEach(e -> builder.withParameter((String)e.getKey(), this.createParameterSimpleValue((String)e.getValue(), this.getGroupParameterType(group, (String)e.getKey()))));
    }

    private void copyExplicitAttributes(Map<String, String> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder, MetadataType parentMetadataType) {
        attributes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("config-ref")).forEach(e -> builder.withParameter((String)e.getKey(), this.createParameterSimpleValue((String)e.getValue(), this.getChildMetadataType(parentMetadataType, (String)e.getKey()))));
    }

    private void copyExplicitAttributes(ParameterizedModel model, Map<String, String> attributes, ParameterizedElementDeclarer builder) {
        attributes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("config-ref")).forEach(e -> {
            Optional<ParameterGroupModel> ownerGroup = model.getParameterGroupModels().stream().filter(group -> group.getParameter((String)e.getKey()).isPresent()).findFirst();
            if (ownerGroup.isPresent()) {
                builder.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup(ownerGroup.get().getName()).withParameter((String)e.getKey(), this.createParameterSimpleValue((String)e.getValue(), this.getGroupParameterType(ownerGroup, (String)e.getKey()))).getDeclaration());
            } else {
                builder.withCustomParameter((String)e.getKey(), (String)e.getValue());
            }
        });
    }

    private void copyExplicitAttributeParams(Map<String, ComponentParameterAst> attributes, ParameterizedBuilder<String, ParameterValue, ?> builder, ParameterGroupModel group) {
        attributes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("config-ref")).forEach(e -> builder.withParameter((String)e.getKey(), ((ComponentParameterAst)e.getValue()).getMetadata().map(m -> AstXmlParserAttribute.IS_CDATA.get((ComponentMetadataAst)m).orElse(false)).orElse(false) != false ? this.createParameterSimpleCdataValue(((ComponentParameterAst)e.getValue()).getRawValue(), this.getGroupParameterType(group, (String)e.getKey())) : this.createParameterSimpleValue(((ComponentParameterAst)e.getValue()).getRawValue(), this.getGroupParameterType(group, (String)e.getKey()))));
    }

    private void copyExplicitAttributeParams(Map<String, ComponentParameterAst> attributes, ParameterizedElementDeclarer builder, ParameterizedModel model) {
        attributes.entrySet().stream().filter(e -> !((String)e.getKey()).equals("config-ref")).forEach(e -> {
            Optional<ParameterGroupModel> ownerGroup = model.getParameterGroupModels().stream().filter(group -> group.getParameter((String)e.getKey()).isPresent()).findFirst();
            if (ownerGroup.isPresent()) {
                builder.withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup(ownerGroup.get().getName()).withParameter((String)e.getKey(), this.createParameterSimpleValue(((ComponentParameterAst)e.getValue()).getRawValue(), this.getGroupParameterType(ownerGroup, (String)e.getKey()))).getDeclaration());
            } else {
                builder.withCustomParameter((String)e.getKey(), ((ComponentParameterAst)e.getValue()).getRawValue());
            }
        });
    }

    private void copyChildren(ComponentAst component, ParameterizedBuilder<String, ParameterValue, ?> builder, MetadataType metadataType) {
        component.directChildrenStream().forEach(child -> {
            ParameterObjectValue.Builder childBuilder = ElementDeclarer.newObjectValue();
            MetadataType childMetadataType = this.getChildMetadataType(metadataType, child.getIdentifier().getName());
            this.cloneAsDeclaration((ComponentAst)child, childBuilder, childMetadataType);
            builder.withParameter(child.getIdentifier().getName(), childBuilder.build());
        });
    }

    private ParameterValue createParameterSimpleValue(String a, MetadataType type) {
        return ParameterSimpleValue.of(a, this.getSimpleTypeFromMetadataType(type));
    }

    private ParameterValue createParameterSimpleCdataValue(String a, MetadataType type) {
        return ParameterSimpleValue.cdata(a, this.getSimpleTypeFromMetadataType(type));
    }

    private SimpleValueType getSimpleTypeFromMetadataType(MetadataType type) {
        if (type instanceof DateTimeType) {
            return SimpleValueType.DATETIME;
        }
        if (type instanceof TimeType) {
            return SimpleValueType.TIME;
        }
        if (type instanceof BooleanType) {
            return SimpleValueType.BOOLEAN;
        }
        if (type instanceof NumberType) {
            return SimpleValueType.NUMBER;
        }
        return SimpleValueType.STRING;
    }
}

