/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.ast.api.validation.ArtifactValidation;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationsProvider;
import org.mule.runtime.config.internal.validation.ConfigReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.DynamicConfigWithStatefulOperationConfigurationOverride;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorHasTypeOrWhen;
import org.mule.runtime.config.internal.validation.ErrorHandlerOnErrorTypeExists;
import org.mule.runtime.config.internal.validation.ErrorHandlerRefOrOnErrorExclusiveness;
import org.mule.runtime.config.internal.validation.ErrorMappingSourceTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ErrorMappingTargetTypeReferencesExist;
import org.mule.runtime.config.internal.validation.ExpressionsInRequiredExpressionsParams;
import org.mule.runtime.config.internal.validation.FirstSuccessfulRoutes;
import org.mule.runtime.config.internal.validation.FlowRefPointsToExistingFlow;
import org.mule.runtime.config.internal.validation.ImportValidTarget;
import org.mule.runtime.config.internal.validation.NameHasValidCharacters;
import org.mule.runtime.config.internal.validation.NameIsNotRepeated;
import org.mule.runtime.config.internal.validation.NamedTopLevelElementsHaveName;
import org.mule.runtime.config.internal.validation.NoExpressionsInNoExpressionsSupportedParams;
import org.mule.runtime.config.internal.validation.ParameterGroupExclusiveness;
import org.mule.runtime.config.internal.validation.ParseTemplateResourceExist;
import org.mule.runtime.config.internal.validation.PollingSourceHasSchedulingStrategy;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesExist;
import org.mule.runtime.config.internal.validation.RaiseErrorTypeReferencesPresent;
import org.mule.runtime.config.internal.validation.ReferenceParametersStereotypesValidations;
import org.mule.runtime.config.internal.validation.RequiredParametersPresent;
import org.mule.runtime.config.internal.validation.RoundRobinRoutes;
import org.mule.runtime.config.internal.validation.ScatterGatherRoutes;
import org.mule.runtime.config.internal.validation.SingletonsAreNotRepeated;
import org.mule.runtime.config.internal.validation.SingletonsPerFileAreNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyLast;
import org.mule.runtime.config.internal.validation.SourceErrorMappingAnyNotRepeated;
import org.mule.runtime.config.internal.validation.SourceErrorMappingTypeNotRepeated;
import org.mule.runtime.config.internal.validation.SourcePositiveMaxItemsPerPoll;

public class CoreValidationsProvider
implements ValidationsProvider {
    private ClassLoader artifactRegionClassLoader;
    @Inject
    private final Optional<FeatureFlaggingService> featureFlaggingService = Optional.empty();

    @Override
    public List<Validation> get() {
        return Arrays.asList(new SingletonsAreNotRepeated(), new SingletonsPerFileAreNotRepeated(), new NamedTopLevelElementsHaveName(), new NameHasValidCharacters(), new NameIsNotRepeated(), new FlowRefPointsToExistingFlow(), new SourceErrorMappingAnyNotRepeated(), new SourceErrorMappingAnyLast(), new SourceErrorMappingTypeNotRepeated(), new ErrorHandlerRefOrOnErrorExclusiveness(), new ErrorHandlerOnErrorHasTypeOrWhen(), new RaiseErrorTypeReferencesPresent(this.featureFlaggingService), new RaiseErrorTypeReferencesExist(this.featureFlaggingService), new ErrorMappingTargetTypeReferencesExist(this.featureFlaggingService), new ErrorMappingSourceTypeReferencesExist(this.featureFlaggingService), new ErrorHandlerOnErrorTypeExists(this.featureFlaggingService), new RequiredParametersPresent(), new ParameterGroupExclusiveness(), new ExpressionsInRequiredExpressionsParams(this.featureFlaggingService), new NoExpressionsInNoExpressionsSupportedParams(), new DynamicConfigWithStatefulOperationConfigurationOverride(), new PollingSourceHasSchedulingStrategy(), new RoundRobinRoutes(), new FirstSuccessfulRoutes(), new ScatterGatherRoutes(), new ParseTemplateResourceExist(this.artifactRegionClassLoader), new SourcePositiveMaxItemsPerPoll());
    }

    @Override
    public List<ArtifactValidation> getArtifactValidations() {
        return Arrays.asList(new ImportValidTarget(), new ConfigReferenceParametersStereotypesValidations(this.featureFlaggingService), new ReferenceParametersStereotypesValidations());
    }

    @Override
    public void setArtifactRegionClassLoader(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }
}

