/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.loader.java.property.AllowsExpressionWithoutMarkersModelProperty;

public class ExpressionsInRequiredExpressionsParams
implements Validation {
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final String CONFIGURATION_NAME = "configuration";
    protected static final ComponentIdentifier CONFIGURATION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("configuration").build();
    private final Optional<FeatureFlaggingService> featureFlaggingService;

    public ExpressionsInRequiredExpressionsParams(Optional<FeatureFlaggingService> featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
    }

    @Override
    public String getName() {
        return "Expression must be set in expressionsRequired params";
    }

    @Override
    public String getDescription() {
        return "Expressions are provided for parameters that require expressions.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(ParameterizedModel.class).map(pmz -> pmz.getAllParameterModels()).orElse(Collections.emptyList()).stream().filter(pm -> ExpressionSupport.REQUIRED.equals((Object)pm.getExpressionSupport()) && !pm.getModelProperty(AllowsExpressionWithoutMarkersModelProperty.class).isPresent()).findAny().isPresent());
    }

    @Override
    public List<ValidationResultItem> validateMany(ComponentAst component, ArtifactAst artifact) {
        return component.getModel(ParameterizedModel.class).map(pmz -> ExtensionModelUtils.getGroupAndParametersPairs(pmz).filter(gnp -> ExpressionSupport.REQUIRED.equals((Object)((ParameterModel)gnp.getSecond()).getExpressionSupport()) && !((ParameterModel)gnp.getSecond()).getModelProperty(AllowsExpressionWithoutMarkersModelProperty.class).isPresent()).map(gnp -> component.getParameter(((ParameterGroupModel)gnp.getFirst()).getName(), ((ParameterModel)gnp.getSecond()).getName())).collect(Collectors.toList())).orElse(Collections.emptyList()).stream().filter(param -> {
            String stringValue;
            if (param.getValueOrResolutionError().isRight() && param.getResolvedRawValue() instanceof String && (!(stringValue = param.getResolvedRawValue()).startsWith(DEFAULT_EXPRESSION_PREFIX) || !stringValue.endsWith(DEFAULT_EXPRESSION_SUFFIX))) {
                if (param.getModel().getName().equals("targetValue")) {
                    return this.featureFlaggingService.map(ffs -> ffs.isEnabled(MuleRuntimeFeature.ENFORCE_REQUIRED_EXPRESSION_VALIDATION)).orElse(true);
                }
                return true;
            }
            return false;
        }).map(param -> ValidationResultItem.create(component, param, (Validation)this, String.format("A static value ('%s') was given for parameter '%s' but it requires an expression", param.getRawValue(), param.getModel().getName()))).collect(Collectors.toList());
    }
}

