/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.platform.schema;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.sdk.api.annotation.semantics.connectivity.ApiKeyAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.BasicAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.ConfiguresNtlmProxy;
import org.mule.sdk.api.annotation.semantics.connectivity.ConfiguresProxy;
import org.mule.sdk.api.annotation.semantics.connectivity.DigestAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.Domain;
import org.mule.sdk.api.annotation.semantics.connectivity.Endpoint;
import org.mule.sdk.api.annotation.semantics.connectivity.Host;
import org.mule.sdk.api.annotation.semantics.connectivity.KerberosAuth;
import org.mule.sdk.api.annotation.semantics.connectivity.NtlmDomain;
import org.mule.sdk.api.annotation.semantics.connectivity.Port;
import org.mule.sdk.api.annotation.semantics.connectivity.Unsecured;
import org.mule.sdk.api.annotation.semantics.connectivity.Url;
import org.mule.sdk.api.annotation.semantics.connectivity.UrlPath;
import org.mule.sdk.api.annotation.semantics.security.AccountId;
import org.mule.sdk.api.annotation.semantics.security.ApiKey;
import org.mule.sdk.api.annotation.semantics.security.ClientId;
import org.mule.sdk.api.annotation.semantics.security.ClientSecret;
import org.mule.sdk.api.annotation.semantics.security.ConnectionId;
import org.mule.sdk.api.annotation.semantics.security.Password;
import org.mule.sdk.api.annotation.semantics.security.Secret;
import org.mule.sdk.api.annotation.semantics.security.SecretToken;
import org.mule.sdk.api.annotation.semantics.security.SecurityToken;
import org.mule.sdk.api.annotation.semantics.security.SessionId;
import org.mule.sdk.api.annotation.semantics.security.TenantIdentifier;
import org.mule.sdk.api.annotation.semantics.security.TokenId;
import org.mule.sdk.api.annotation.semantics.security.Username;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SemanticTermsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SemanticTermsHelper.class);
    private static final String LEGACY_PASSWORD_ANNOTATION_CLASS_NAME = "org.mule.runtime.extension.api.annotation.param.display.Password";
    private static final Map<Class<? extends Annotation>, String> PARAMS_TERMS = new HashMap<Class<? extends Annotation>, String>();
    private static final Map<Class<? extends Annotation>, String> CONNECTION_TERMS = new HashMap<Class<? extends Annotation>, String>();

    private static void loadLegacyPasswordAnnotation() {
        block2: {
            try {
                Class<?> legacyPasswordAnnotation = Class.forName(LEGACY_PASSWORD_ANNOTATION_CLASS_NAME);
                PARAMS_TERMS.put(legacyPasswordAnnotation, "connectivity.password");
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(String.format("Legacy annotation %s not found in classpath", LEGACY_PASSWORD_ANNOTATION_CLASS_NAME), (Throwable)e);
            }
        }
    }

    public static Set<String> getConnectionTermsFromAnnotations(Function<Class<? extends Annotation>, Boolean> predicate) {
        LinkedHashSet<String> collector = new LinkedHashSet<String>();
        SemanticTermsHelper.collectFromAnnotations(CONNECTION_TERMS, predicate, collector);
        return collector;
    }

    public static Set<String> getParameterTermsFromAnnotations(Function<Class<? extends Annotation>, Boolean> predicate) {
        LinkedHashSet<String> collector = new LinkedHashSet<String>();
        SemanticTermsHelper.collectFromAnnotations(PARAMS_TERMS, predicate, collector);
        return collector;
    }

    public static Set<String> getAllTermsFromAnnotations(Function<Class<? extends Annotation>, Boolean> predicate) {
        LinkedHashSet<String> collector = new LinkedHashSet<String>();
        SemanticTermsHelper.collectFromAnnotations(CONNECTION_TERMS, predicate, collector);
        SemanticTermsHelper.collectFromAnnotations(PARAMS_TERMS, predicate, collector);
        return collector;
    }

    private static void collectFromAnnotations(Map<Class<? extends Annotation>, String> terms, Function<Class<? extends Annotation>, Boolean> predicate, Set<String> collector) {
        terms.forEach((annotationType, term) -> {
            if (((Boolean)predicate.apply((Class<? extends Annotation>)annotationType)).booleanValue()) {
                collector.add((String)term);
            }
        });
    }

    public static Set<String> getConnectionTerms(Set<String> terms) {
        return SemanticTermsHelper.extractMatching(CONNECTION_TERMS.values(), terms);
    }

    public static Set<String> getParameterTerms(Set<String> terms) {
        return SemanticTermsHelper.extractMatching(PARAMS_TERMS.values(), terms);
    }

    private static Set<String> extractMatching(Collection<String> searchSpace, Set<String> subset) {
        if (subset != null) {
            return subset.stream().filter(term -> term.startsWith("connectivity.") || searchSpace.contains(term)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new LinkedHashSet<String>();
    }

    private SemanticTermsHelper() {
    }

    static {
        CONNECTION_TERMS.put(ApiKeyAuth.class, "connectivity.ApiKeyAuthenticationConnection");
        CONNECTION_TERMS.put(BasicAuth.class, "connectivity.BasicAuthenticationConnection");
        CONNECTION_TERMS.put(DigestAuth.class, "connectivity.DigestAuthenticationConnection");
        CONNECTION_TERMS.put(KerberosAuth.class, "connectivity.KerberosAuthenticationConnection");
        CONNECTION_TERMS.put(Unsecured.class, "connectivity.UnsecureConnection");
        PARAMS_TERMS.put(ConfiguresNtlmProxy.class, "connectivity.NtlmProxyConfiguration");
        PARAMS_TERMS.put(ConfiguresProxy.class, "connectivity.ProxyConfiguration");
        PARAMS_TERMS.put(Domain.class, "connectivity.domain");
        PARAMS_TERMS.put(Endpoint.class, "apiContract.endPoint");
        PARAMS_TERMS.put(Host.class, "connectivity.host");
        PARAMS_TERMS.put(NtlmDomain.class, "connectivity.ntlmDomain");
        PARAMS_TERMS.put(Port.class, "connectivity.port");
        PARAMS_TERMS.put(Url.class, "core.urlTemplate");
        PARAMS_TERMS.put(UrlPath.class, "apiContract.path");
        PARAMS_TERMS.put(AccountId.class, "connectivity.accountId");
        PARAMS_TERMS.put(ApiKey.class, "connectivity.apiKey");
        PARAMS_TERMS.put(ClientId.class, "connectivity.clientId");
        PARAMS_TERMS.put(ClientSecret.class, "connectivity.clientSecret");
        PARAMS_TERMS.put(ConnectionId.class, "connectivity.connectionId");
        PARAMS_TERMS.put(Password.class, "connectivity.password");
        PARAMS_TERMS.put(Secret.class, "connectivity.secret");
        PARAMS_TERMS.put(SecretToken.class, "connectivity.secretToken");
        PARAMS_TERMS.put(SecurityToken.class, "connectivity.securityToken");
        PARAMS_TERMS.put(SessionId.class, "connectivity.sessionId");
        PARAMS_TERMS.put(TenantIdentifier.class, "connectivity.tenant");
        PARAMS_TERMS.put(TokenId.class, "connectivity.tokenId");
        PARAMS_TERMS.put(Username.class, "connectivity.username");
        SemanticTermsHelper.loadLegacyPasswordAnnotation();
    }
}

