/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.notification;

import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;

public class ProfilingNotification<T extends ProfilingEventContext>
extends AbstractServerNotification {
    private static final int TEST_NOTIFICATION_ID = 2201;
    private static final int STARTING_FLOW_EXECUTION_ID = 2202;
    private static final int PS_SCHEDULING_FLOW_EXECUTION_ID = 2203;
    private static final int FLOW_EXECUTED_ID = 2204;
    private static final int PS_SCHEDULING_OPERATION_EXECUTION_ID = 2205;
    private static final int STARTING_OPERATION_EXECUTION_ID = 2206;
    private static final int OPERATION_EXECUTED_ID = 2207;
    private static final int PS_FLOW_MESSAGE_PASSING_ID = 2208;
    private static final int COMPONENT_PROFILING_EVENT_ID = 2209;
    private static final int STARTING_OPERATION_EXECUTION_EVENT_ID = 2210;
    private static final int OPERATION_EXECUTED_EVENT_ID = 2211;
    private static final int OPERATION_THREAD_RELEASE_EVENT_ID = 2212;
    private static final int SCHEDULING_TASK_EXECUTION_EVENT_ID = 2213;
    private static final int STARTING_TASK_EXECUTION_EVENT_ID = 2214;
    private static final int TASK_EXECUTED_EVENT_ID = 2215;
    public static final String PROFILING_NAMESPACE_IDENTIFIER_SEPARATOR = ":";
    private final ProfilingEventType<T> profilingEventType;

    public ProfilingNotification(T profilingEventContext, ProfilingEventType<T> profilingEventType) {
        super(profilingEventContext, ProfilingNotification.getActionId(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(profilingEventType)));
        this.profilingEventType = profilingEventType;
    }

    @Override
    public boolean isSynchronous() {
        return true;
    }

    @Override
    public String getEventName() {
        return "ProfilingServerNotification";
    }

    public ProfilingEventType<T> getProfilingEventType() {
        return this.profilingEventType;
    }

    public static String getFullyQualifiedProfilingNotificationIdentifier(ProfilingEventType<?> profilingEventType) {
        return profilingEventType.getProfilingEventTypeNamespace() + PROFILING_NAMESPACE_IDENTIFIER_SEPARATOR + profilingEventType.getProfilingEventTypeIdentifier();
    }

    static {
        ProfilingNotification.registerAction("test-namespace:test", 2201);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION), 2202);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION), 2203);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.FLOW_EXECUTED), 2204);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION), 2205);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_STARTING_OPERATION_EXECUTION), 2206);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_OPERATION_EXECUTED), 2207);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING), 2208);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.EXTENSION_PROFILING_EVENT), 2209);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION), 2210);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.OPERATION_EXECUTED), 2211);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE), 2212);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.SCHEDULING_TASK_EXECUTION), 2213);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.STARTING_TASK_EXECUTION), 2214);
        ProfilingNotification.registerAction(ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(RuntimeProfilingEventTypes.TASK_EXECUTED), 2215);
    }
}

