/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.core.privileged.registry.RegistrationException;
import org.mule.runtime.core.privileged.util.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleRegistryHelper
implements MuleRegistry {
    protected transient Logger logger = LoggerFactory.getLogger(MuleRegistryHelper.class);
    private final Registry registry;
    private final MuleContext muleContext;
    private final Map<Object, Object> postProcessedObjects = new HashMap<Object, Object>();

    public MuleRegistryHelper(Registry registry, MuleContext muleContext) {
        this.registry = registry;
        this.muleContext = muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void dispose() {
        this.registry.dispose();
    }

    @Override
    public synchronized void fireLifecycle(String phase) throws LifecycleException {
        if ("initialise".equals(phase)) {
            this.registry.initialise();
        } else if ("dispose".equals(phase)) {
            this.registry.dispose();
        } else {
            this.registry.fireLifecycle(phase);
        }
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public FlowConstruct lookupFlowConstruct(String name) {
        return (FlowConstruct)this.registry.lookupObject(name);
    }

    @Override
    public Collection<FlowConstruct> lookupFlowConstructs() {
        return this.lookupObjects(FlowConstruct.class);
    }

    @Override
    public boolean isSingleton(String key) {
        return this.registry.isSingleton(key);
    }

    @Override
    public void registerFlowConstruct(FlowConstruct flowConstruct) throws MuleException {
        this.registry.registerObject(BeanUtils.getName(flowConstruct), flowConstruct, FlowConstruct.class);
    }

    @Override
    public Object applyProcessorsAndLifecycle(Object object) throws MuleException {
        object = this.applyProcessors(object);
        object = this.applyLifecycle(object);
        return object;
    }

    @Override
    public Object applyProcessors(Object object) throws MuleException {
        return this.muleContext.getInjector().inject(object);
    }

    @Override
    public Object applyLifecycle(Object object) throws MuleException {
        return this.applyLifecycle(object, null);
    }

    @Override
    public Object applyLifecycle(Object object, String phase) throws MuleException {
        return this.registry.applyLifecycle(object, phase);
    }

    @Override
    public void applyLifecycle(Object object, String startPhase, String toPhase) throws MuleException {
        this.registry.applyLifecycle(object, startPhase, toPhase);
    }

    @Override
    public <T> T lookupObject(Class<T> type) throws RegistrationException {
        return this.registry.lookupObject(type);
    }

    @Override
    public <T> T lookupObject(String key) {
        return this.registry.lookupObject(key);
    }

    @Override
    public <T> T lookupObject(String key, boolean applyLifecycle) {
        return this.registry.lookupObject(key, applyLifecycle);
    }

    @Override
    public <T> Collection<T> lookupObjects(Class<T> type) {
        return this.registry.lookupObjects(type);
    }

    @Override
    public <T> Collection<T> lookupLocalObjects(Class<T> type) {
        return this.registry.lookupLocalObjects(type);
    }

    @Override
    public <T> Collection<T> lookupObjectsForLifecycle(Class<T> type) {
        return this.registry.lookupObjectsForLifecycle(type);
    }

    @Override
    public <T> T get(String key) {
        return this.registry.get(key);
    }

    @Override
    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.registry.lookupByType(type);
    }

    @Override
    public void registerObject(String key, Object value, Object metadata) throws RegistrationException {
        this.registry.registerObject(key, value, metadata);
        this.postObjectRegistrationActions(value);
    }

    public void postObjectRegistrationActions(Object value) {
        if (!this.postProcessedObjects.containsKey(value)) {
            this.postProcessedObjects.put(value, value);
        }
    }

    @Override
    public void registerObject(String key, Object value) throws RegistrationException {
        this.registry.registerObject(key, value);
        this.postObjectRegistrationActions(value);
    }

    public void registerObjects(Map objects) throws RegistrationException {
        this.registry.registerObjects(objects);
        for (Object value : objects.values()) {
            this.postObjectRegistrationActions(value);
        }
    }

    @Override
    public Object unregisterObject(String key, Object metadata) throws RegistrationException {
        return this.registry.unregisterObject(key, metadata);
    }

    @Override
    public Object unregisterObject(String key) throws RegistrationException {
        return this.registry.unregisterObject(key);
    }

    @Override
    public String getRegistryId() {
        return this.toString();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public Registry getDelegate() {
        return this.registry;
    }
}

