/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithStereotypesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class DefaultStereotypeEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new Delegate().enrich(extensionLoadingContext);
    }

    private class Delegate {
        private final Map<String, StereotypeModel> parentsCache = new HashMap<String, StereotypeModel>();

        private Delegate() {
        }

        private void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final String namespace = ExtensionNamespaceUtils.getExtensionsNamespace(extensionDeclaration);
            new DeclarationWalker(){

                @Override
                protected void onConfiguration(ConfigurationDeclaration declaration) {
                    Delegate.this.assureHasStereotype(declaration, () -> Delegate.this.createStereotype(namespace, declaration.getName(), MuleStereotypes.CONFIG));
                }

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    Delegate.this.assureHasStereotype(declaration, () -> Delegate.this.createStereotype(namespace, declaration.getName(), MuleStereotypes.CONNECTION));
                }

                @Override
                protected void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
                    Delegate.this.assureHasStereotype(declaration, () -> Delegate.this.createComponentStereotype(namespace, declaration.getName(), MuleStereotypes.PROCESSOR));
                }

                @Override
                protected void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
                    Delegate.this.assureHasStereotype(declaration, () -> Delegate.this.createComponentStereotype(namespace, declaration.getName(), MuleStereotypes.SOURCE));
                }
            }.walk(extensionDeclaration);
        }

        private void assureHasStereotype(WithStereotypesDeclaration declaration, Supplier<StereotypeModel> defaultStereotype) {
            if (declaration.getStereotype() == null) {
                declaration.withStereotype(defaultStereotype.get());
            }
        }

        private StereotypeModel createStereotype(String namespace, String name, StereotypeModel parent) {
            return StereotypeModelBuilder.newStereotype(name, namespace).withParent(parent).build();
        }

        private StereotypeModel createComponentStereotype(String namespace, String name, StereotypeModel parent) {
            if (!parent.getNamespace().equals(namespace)) {
                StereotypeModel originalParent = parent;
                parent = this.parentsCache.computeIfAbsent(parent.getType(), key -> StereotypeModelBuilder.newStereotype(originalParent.getType(), namespace).withParent(originalParent).build());
            }
            return this.createStereotype(namespace, name, parent);
        }
    }
}

