/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import java.util.Optional;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;
import org.mule.runtime.module.extension.internal.runtime.exception.ErrorMappingUtils;

public class CorrectPrefixesValidator
implements ExtensionModelValidator {
    public static final String TARGET_TYPE = "targetType";
    public static final String CORE_ERROR_NS = "mule".toUpperCase();
    public static final String ERROR_MAPPING = "error-mapping";
    public static final String RAISE_ERROR = "raise-error";
    public static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-mapping").build();
    public static final ComponentIdentifier RAISE_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("raise-error").build();
    private static final String SEPARATOR = ":";
    public static final String TYPE_RAISE_ERROR_ATTRIBUTE = "type";
    public static final String EMPTY_TYPE_FORMAT_MESSAGE = "When using a %s the '%s' must not be null nor empty, offending operation '%s'";
    public static final String WRONG_VALUE_FORMAT_MESSAGE = "When using a %s the '%s' must either use the runtime or the custom namespace of the current module ('%s' or '%s') but found '%s', offending operation '%s'";

    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new ExtensionWalker(){

            @Override
            protected void onOperation(HasOperationModels owner, OperationModel operationModel) {
                operationModel.getModelProperty(OperationComponentModelModelProperty.class).ifPresent(operationComponentModelModelProperty -> CorrectPrefixesValidator.this.searchAndValidate(extensionModel.getXmlDslModel().getPrefix(), operationModel, operationComponentModelModelProperty.getBodyComponentModel(), problemsReporter));
            }
        }.walk(extensionModel);
    }

    private void searchAndValidate(String namespace, OperationModel operationModel, ComponentAst componentModel, ProblemsReporter problemsReporter) {
        if (componentModel.getIdentifier().equals(RAISE_ERROR_IDENTIFIER)) {
            this.validateRaiseError(namespace, operationModel, componentModel, problemsReporter);
        }
        ErrorMappingUtils.forEachErrorMappingDo(componentModel, mappings -> mappings.forEach(mapping -> this.validateErrorMapping(namespace, operationModel, (ErrorMapping)mapping, problemsReporter)));
        componentModel.directChildrenStream().forEach(childComponentModel -> this.searchAndValidate(namespace, operationModel, (ComponentAst)childComponentModel, problemsReporter));
    }

    private void validateRaiseError(String moduleNamespace, OperationModel operationModel, ComponentAst raiseErrorComponentModel, ProblemsReporter problemsReporter) {
        this.genericValidation(moduleNamespace, operationModel, raiseErrorComponentModel, problemsReporter, TYPE_RAISE_ERROR_ATTRIBUTE, RAISE_ERROR_IDENTIFIER);
    }

    private void validateErrorMapping(String moduleNamespace, OperationModel operationModel, ErrorMapping errorMappingComponentModel, ProblemsReporter problemsReporter) {
        this.genericValidation(moduleNamespace, operationModel, problemsReporter, TARGET_TYPE, ERROR_MAPPING_IDENTIFIER, Optional.ofNullable(errorMappingComponentModel.getTarget()));
    }

    private static Optional<String> getRawParameterValue(ComponentAst componentAst, String parameterName) {
        return Optional.ofNullable(componentAst.getParameter("General", parameterName)).map(ComponentParameterAst::getResolvedRawValue);
    }

    private void genericValidation(String moduleNamespace, OperationModel operationModel, ComponentAst elementComponentModel, ProblemsReporter problemsReporter, String attributeToValidate, ComponentIdentifier workingIdentifier) {
        this.genericValidation(moduleNamespace, operationModel, problemsReporter, attributeToValidate, workingIdentifier, CorrectPrefixesValidator.getRawParameterValue(elementComponentModel, attributeToValidate));
    }

    private void genericValidation(String moduleNamespace, OperationModel operationModel, ProblemsReporter problemsReporter, String attributeToValidate, ComponentIdentifier workingIdentifier, Optional<String> stringRepresentation) {
        if (!stringRepresentation.isPresent()) {
            problemsReporter.addError(new Problem(operationModel, String.format(EMPTY_TYPE_FORMAT_MESSAGE, workingIdentifier.toString(), attributeToValidate, operationModel.getName())));
        } else {
            int separator = stringRepresentation.get().indexOf(SEPARATOR);
            if (separator > 0) {
                String namespace = stringRepresentation.get().substring(0, separator).toUpperCase();
                if (!moduleNamespace.toUpperCase().equals(namespace)) {
                    problemsReporter.addError(new Problem(operationModel, String.format(WRONG_VALUE_FORMAT_MESSAGE, workingIdentifier.toString(), attributeToValidate, CORE_ERROR_NS, moduleNamespace.toUpperCase(), namespace, operationModel.getName())));
                }
            }
        }
    }
}

