/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.feature.internal.config;

import java.util.Map;
import java.util.Set;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.feature.internal.config.profiling.MuleProfilingDataProducerFeatureStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;
import org.mule.runtime.feature.internal.togglz.MuleTogglzFeatureManagerProvider;
import org.mule.runtime.feature.internal.togglz.MuleTogglzProfilingFeature;
import org.mule.runtime.feature.internal.togglz.config.MuleTogglzFeatureFlaggingUtils;
import org.mule.runtime.feature.internal.togglz.config.MuleTogglzManagedArtifactFeatures;
import org.mule.runtime.feature.internal.togglz.user.MuleTogglzArtifactFeatureUser;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.FeatureUser;

public class DefaultFeatureFlaggingService
implements ProfilingFeatureFlaggingService,
Disposable {
    private final FeatureUser featureUser;
    private final MuleTogglzManagedArtifactFeatures features;

    public DefaultFeatureFlaggingService(String artifactId, Map<org.mule.runtime.api.config.Feature, Boolean> features) {
        this.registerFeatures(features.keySet());
        this.featureUser = new MuleTogglzArtifactFeatureUser(artifactId);
        this.features = MuleTogglzFeatureFlaggingUtils.getTogglzManagedArtifactFeatures(artifactId, features);
    }

    private void registerFeatures(Set<org.mule.runtime.api.config.Feature> features) {
        for (org.mule.runtime.api.config.Feature runtimeFeature : features) {
            MuleTogglzFeatureFlaggingUtils.addMuleTogglzRuntimeFeature(runtimeFeature);
        }
    }

    @Override
    public boolean isEnabled(org.mule.runtime.api.config.Feature feature) {
        Feature togglzFeature = MuleTogglzFeatureManagerProvider.FEATURE_PROVIDER.getRuntimeTogglzFeature(feature);
        if (!this.features.containsKey(togglzFeature)) {
            return FeatureContext.getFeatureManager().isActive(togglzFeature);
        }
        return this.features.get(togglzFeature).isEnabled();
    }

    @Override
    public void dispose() {
        this.features.dispose();
    }

    @Override
    public ProfilingDataProducerStatus getProfilingDataProducerStatus(ProfilingEventType<?> profilingEventType, ProfilingProducerScope profilingProducerContext) {
        return new MuleProfilingDataProducerFeatureStatus(profilingEventType, MuleTogglzFeatureManagerProvider.FEATURE_PROVIDER, this.featureUser);
    }

    @Override
    public void registerProfilingFeature(ProfilingEventType<?> profilingEventType, String identifier) {
        MuleTogglzFeatureFlaggingUtils.withFeatureUser(this.featureUser, () -> {
            MuleTogglzProfilingFeature feature = MuleTogglzFeatureManagerProvider.FEATURE_PROVIDER.getOrRegisterProfilingTogglzFeatureFrom(profilingEventType, identifier);
            MuleTogglzFeatureFlaggingUtils.setFeatureState(MuleTogglzFeatureFlaggingUtils.getFeatureState(feature));
        });
    }

    @Override
    public void toggleProfilingFeature(ProfilingEventType<?> profilingEventType, String profilingFeatureSuffix, boolean status) {
        MuleTogglzFeatureFlaggingUtils.withFeatureUser(this.featureUser, () -> {
            MuleTogglzProfilingFeature feature = MuleTogglzFeatureManagerProvider.FEATURE_PROVIDER.getOrRegisterProfilingTogglzFeatureFrom(profilingEventType, profilingFeatureSuffix);
            MuleTogglzFeatureFlaggingUtils.setFeatureState(new FeatureState((Feature)feature, status));
        });
    }
}

