/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.artifact;

import java.io.File;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.globalconfig.api.maven.MavenClientFactory;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.api.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.PluginMavenClassLoaderModelLoader;
import org.mule.runtime.module.service.internal.artifact.LibFolderClassLoaderModelLoader;

public class MavenClassLoaderModelLoader
implements ClassLoaderModelLoader {
    private DeployableMavenClassLoaderModelLoader deployableMavenClassLoaderModelLoader;
    private PluginMavenClassLoaderModelLoader pluginMavenClassLoaderModelLoader;
    private LibFolderClassLoaderModelLoader libFolderClassLoaderModelLoader;
    private volatile MavenConfiguration mavenRuntimeConfig;
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        long stamp = this.lock.readLock();
        try {
            MavenConfiguration updatedMavenConfiguration = GlobalConfigLoader.getMavenConfig();
            if (!updatedMavenConfiguration.equals(this.mavenRuntimeConfig)) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (!updatedMavenConfiguration.equals(this.mavenRuntimeConfig)) {
                    this.mavenRuntimeConfig = updatedMavenConfiguration;
                    this.createClassLoaderModelLoaders();
                }
            }
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private void createClassLoaderModelLoaders() {
        Optional<MavenClient> mavenClient = Optional.ofNullable(MavenClientFactory.createMavenClient(this.mavenRuntimeConfig));
        this.deployableMavenClassLoaderModelLoader = new DeployableMavenClassLoaderModelLoader(mavenClient);
        this.pluginMavenClassLoaderModelLoader = new PluginMavenClassLoaderModelLoader(mavenClient);
        this.libFolderClassLoaderModelLoader = new LibFolderClassLoaderModelLoader();
    }

    @Override
    public String getId() {
        return "mule";
    }

    @Override
    public ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        this.refresh();
        if (this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
            return this.deployableMavenClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
        }
        if (this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType)) {
            return this.pluginMavenClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
        }
        if (this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType)) {
            return this.libFolderClassLoaderModelLoader.load(artifactFile, (Map)attributes, artifactType);
        }
        throw new IllegalStateException(String.format("Artifact type %s not supported", new Object[]{artifactType}));
    }

    @Override
    public boolean supportsArtifactType(ArtifactType artifactType) {
        this.refresh();
        return this.deployableMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.pluginMavenClassLoaderModelLoader.supportsArtifactType(artifactType) || this.libFolderClassLoaderModelLoader.supportsArtifactType(artifactType);
    }
}

