/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.error;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.alg.cycle.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.error.ErrorModelUtils;
import org.mule.runtime.module.extension.internal.error.ErrorTypeDefinitionParserAdapter;
import org.mule.runtime.module.extension.internal.error.SdkErrorTypeDefinitionAdapter;
import org.mule.runtime.module.extension.internal.loader.enricher.ModuleErrors;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.error.JavaErrorModelParser;
import org.mule.sdk.api.error.MuleErrors;

public class ErrorsModelFactory {
    private static final String MULE = "mule".toUpperCase();
    private final String extensionNamespace;
    private final Map<String, ErrorModel> errorModelMap;

    private static org.mule.sdk.api.error.ErrorTypeDefinition toErrorTypeDefinition(ErrorModelParser parser) {
        return parser instanceof JavaErrorModelParser ? ((JavaErrorModelParser)parser).getErrorTypeDefinition() : new ErrorTypeDefinitionParserAdapter(parser);
    }

    private static org.mule.sdk.api.error.ErrorTypeDefinition<?>[] toDefinitionArray(List<ErrorModelParser> parsers) {
        return (org.mule.sdk.api.error.ErrorTypeDefinition[])parsers.stream().map(ErrorsModelFactory::toErrorTypeDefinition).toArray(org.mule.sdk.api.error.ErrorTypeDefinition[]::new);
    }

    private static org.mule.sdk.api.error.ErrorTypeDefinition<?>[] adaptLegacyArray(ErrorTypeDefinition<?>[] errorTypesEnum) {
        return (org.mule.sdk.api.error.ErrorTypeDefinition[])Stream.of(errorTypesEnum).map(SdkErrorTypeDefinitionAdapter::from).toArray(org.mule.sdk.api.error.ErrorTypeDefinition[]::new);
    }

    public ErrorsModelFactory(List<ErrorModelParser> extensionErrorParsers, String extensionNamespace) throws IllegalModelDefinitionException {
        this(ErrorsModelFactory.toDefinitionArray(extensionErrorParsers), extensionNamespace);
    }

    public ErrorsModelFactory(ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) {
        this(ErrorsModelFactory.adaptLegacyArray(errorTypesEnum), extensionNamespace);
    }

    public ErrorsModelFactory(org.mule.sdk.api.error.ErrorTypeDefinition<?>[] errorTypesEnum, String extensionNamespace) {
        this.extensionNamespace = extensionNamespace.toUpperCase();
        DefaultDirectedGraph<org.mule.sdk.api.error.ErrorTypeDefinition, DefaultEdge> graph = this.toGraph(errorTypesEnum);
        this.errorModelMap = new HashMap<String, ErrorModel>();
        this.initErrorModelMap(this.errorModelMap);
        new TopologicalOrderIterator(graph).forEachRemaining(errorType -> {
            ErrorModel errorModel = this.toErrorModel((org.mule.sdk.api.error.ErrorTypeDefinition<?>)errorType, this.errorModelMap);
            this.errorModelMap.put(errorModel.toString(), errorModel);
        });
        this.addConnectivityErrors(this.errorModelMap);
    }

    public ErrorsModelFactory(String extensionNamespace) throws IllegalModelDefinitionException {
        this.extensionNamespace = extensionNamespace.toUpperCase();
        this.errorModelMap = new HashMap<String, ErrorModel>();
        this.initErrorModelMap(this.errorModelMap);
        this.addConnectivityErrors(this.errorModelMap);
    }

    public Set<ErrorModel> getErrorModels() {
        return new HashSet<ErrorModel>(this.errorModelMap.values());
    }

    public ErrorModel getErrorModel(ErrorModelParser errorModelParser) {
        String errorKey = this.toIdentifier(ErrorsModelFactory.toErrorTypeDefinition(errorModelParser));
        if (this.errorModelMap.containsKey(errorKey)) {
            return this.errorModelMap.get(errorKey);
        }
        return this.toErrorModel(ErrorsModelFactory.toErrorTypeDefinition(errorModelParser), this.errorModelMap);
    }

    private DefaultDirectedGraph<org.mule.sdk.api.error.ErrorTypeDefinition, DefaultEdge> toGraph(org.mule.sdk.api.error.ErrorTypeDefinition<?>[] errorTypesEnum) {
        DefaultDirectedWeightedGraph graph = new DefaultDirectedWeightedGraph(DefaultEdge.class);
        Stream.of(errorTypesEnum).forEach(arg_0 -> this.lambda$toGraph$3((DefaultDirectedGraph)graph, arg_0));
        this.detectCycleReferences((DefaultDirectedGraph<?, ?>)graph);
        return graph;
    }

    private ErrorModel toErrorModel(org.mule.sdk.api.error.ErrorTypeDefinition<?> errorTypeDefinition, Map<String, ErrorModel> errorModelMap) {
        if (errorModelMap.containsKey(this.toIdentifier(errorTypeDefinition))) {
            return errorModelMap.get(this.toIdentifier(errorTypeDefinition));
        }
        ErrorModelBuilder builder = ErrorModelBuilder.newError(errorTypeDefinition.getType(), this.getErrorNamespace(errorTypeDefinition));
        builder.withParent(this.toErrorModel(errorTypeDefinition.getParent().orElse(MuleErrors.ANY), errorModelMap));
        ErrorModel errorModel = builder.build();
        errorModelMap.put(this.toIdentifier(errorTypeDefinition), errorModel);
        return errorModel;
    }

    private String toIdentifier(org.mule.sdk.api.error.ErrorTypeDefinition errorTypeDefinition) {
        return this.getErrorNamespace(errorTypeDefinition) + ":" + errorTypeDefinition.getType();
    }

    private String getErrorNamespace(org.mule.sdk.api.error.ErrorTypeDefinition errorType) {
        return ErrorModelUtils.isMuleError(errorType) ? MULE : this.extensionNamespace;
    }

    private void addType(org.mule.sdk.api.error.ErrorTypeDefinition<?> errorType, Graph<org.mule.sdk.api.error.ErrorTypeDefinition, DefaultEdge> graph) {
        graph.addVertex(errorType);
        String type = errorType.getType();
        if (!MuleErrors.ANY.name().equals(type) && !MuleErrors.CRITICAL.name().equals(type)) {
            org.mule.sdk.api.error.ErrorTypeDefinition parentErrorType = errorType.getParent().orElse(MuleErrors.ANY);
            graph.addVertex((Object)parentErrorType);
            graph.addEdge(errorType, (Object)parentErrorType);
        }
    }

    private void detectCycleReferences(DefaultDirectedGraph<?, ?> graph) {
        CycleDetector cycleDetector = new CycleDetector(graph);
        if (cycleDetector.detectCycles()) {
            throw new IllegalModelDefinitionException("Cyclic Error Types reference detected, offending types: " + cycleDetector.findCycles());
        }
    }

    private void addConnectivityErrors(Map<String, ErrorModel> errorModelMap) {
        ErrorModel retryExhaustedError;
        String retry;
        ErrorModel connectivityError = this.toErrorModel(ModuleErrors.CONNECTIVITY, errorModelMap);
        String key = connectivityError.toString();
        if (!errorModelMap.containsKey(key)) {
            errorModelMap.put(key, connectivityError);
        }
        if (!errorModelMap.containsKey(retry = (retryExhaustedError = this.toErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModelMap)).toString())) {
            errorModelMap.put(retry, retryExhaustedError);
        }
    }

    private void initErrorModelMap(Map<String, ErrorModel> errorModelMap) {
        errorModelMap.put(this.toIdentifier(MuleErrors.ANY), ErrorModelBuilder.newError(MuleErrors.ANY.getType(), MULE).build());
    }

    private /* synthetic */ void lambda$toGraph$3(DefaultDirectedGraph graph, org.mule.sdk.api.error.ErrorTypeDefinition error) {
        this.addType(error, (Graph<org.mule.sdk.api.error.ErrorTypeDefinition, DefaultEdge>)graph);
    }
}

