/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSemanticTermsDeclaration;
import org.mule.runtime.connectivity.api.platform.schema.extension.ExcludeFromConnectivitySchemaModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

final class ConnectionProviderModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private final Map<ConnectionProviderModelParser, ConnectionProviderDeclarer> connectionProviderDeclarers = new HashMap<ConnectionProviderModelParser, ConnectionProviderDeclarer>();

    ConnectionProviderModelLoaderDelegate(DefaultJavaModelLoaderDelegate loader) {
        super(loader);
    }

    void declareConnectionProviders(HasConnectionProviderDeclarer declarer, List<ConnectionProviderModelParser> parsers) {
        for (ConnectionProviderModelParser parser : parsers) {
            ConnectionProviderDeclarer providerDeclarer = this.connectionProviderDeclarers.get(parser);
            if (providerDeclarer != null) {
                declarer.withConnectionProvider(providerDeclarer);
                continue;
            }
            providerDeclarer = declarer.withConnectionProvider(parser.getName()).describedAs(parser.getDescription()).withConnectionManagementType(parser.getConnectionManagementType()).supportsConnectivityTesting(parser.supportsConnectivityTesting());
            ConnectionProviderDeclaration connectionProviderDeclaration = (ConnectionProviderDeclaration)providerDeclarer.getDeclaration();
            parser.getDeprecationModel().ifPresent(connectionProviderDeclaration::withDeprecation);
            parser.getDisplayModel().ifPresent(connectionProviderDeclaration::setDisplayModel);
            parser.getConnectionProviderFactoryModelProperty().ifPresent(providerDeclarer::withModelProperty);
            if (parser.isExcludedFromConnectivitySchema()) {
                providerDeclarer.withModelProperty(new ExcludeFromConnectivitySchemaModelProperty());
            }
            parser.getExternalLibraryModels().forEach(providerDeclarer::withExternalLibrary);
            parser.getOAuthModelProperty().ifPresent(providerDeclarer::withModelProperty);
            this.loader.getParameterModelsLoaderDelegate().declare(providerDeclarer, parser.getParameterGroupModelParsers());
            parser.getAdditionalModelProperties().forEach(providerDeclarer::withModelProperty);
            ModelLoaderUtils.addSemanticTerms((WithSemanticTermsDeclaration)providerDeclarer.getDeclaration(), parser);
            this.getStereotypeModelLoaderDelegate().addStereotypes(parser, providerDeclarer, Optional.of(() -> this.getStereotypeModelLoaderDelegate().getDefaultConnectionProviderStereotype(parser.getName())));
            this.connectionProviderDeclarers.put(parser, providerDeclarer);
        }
    }
}

