/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.HasModelProperties;
import org.mule.runtime.api.meta.model.declaration.fluent.HasStereotypeDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedComponentDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.NameUtils;
import org.mule.runtime.extension.api.declaration.type.annotation.InfrastructureTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.stereotype.ImplicitStereotypeDefinition;
import org.mule.runtime.extension.api.stereotype.StereotypeDefinition;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.runtime.module.extension.internal.loader.parser.AllowedStereotypesModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.CustomStereotypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.DefaultStereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.SdkStereotypeDefinitionAdapter;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class StereotypeModelLoaderDelegate {
    private final DslResolvingContext dslResolvingContext;
    private final DefaultStereotypeModelFactory stereotypeModelFactory = new DefaultStereotypeModelFactory();
    private String namespace;

    public StereotypeModelLoaderDelegate(ExtensionLoadingContext extensionLoadingContext) {
        this.dslResolvingContext = extensionLoadingContext.getDslResolvingContext();
    }

    public StereotypeModel getDefaultConfigStereotype(String configName) {
        return this.createStereotype(configName, MuleStereotypes.CONFIG);
    }

    public StereotypeModel getDefaultConnectionProviderStereotype(String connectionProviderName) {
        return this.createStereotype(connectionProviderName, MuleStereotypes.CONNECTION);
    }

    public StereotypeModel getDefaultOperationStereotype(String operationName) {
        return this.createStereotype(operationName, this.stereotypeModelFactory.getProcessorParentStereotype());
    }

    public StereotypeModel getDefaultSourceStereotype(String sourceName) {
        return this.createStereotype(sourceName, this.stereotypeModelFactory.getSourceParentStereotype());
    }

    private StereotypeModel createStereotype(String name, StereotypeModel parent) {
        return this.stereotypeModelFactory.createStereotype(name, parent);
    }

    public <T extends HasStereotypeDeclarer & HasModelProperties> void addStereotypes(StereotypeModelParser parser, T declarer, Optional<Supplier<StereotypeModel>> fallback) {
        StereotypeModel stereotypeModel = parser.getStereotype(this.stereotypeModelFactory).orElse(null);
        if (stereotypeModel != null) {
            ((HasModelProperties)declarer).withModelProperty(CustomStereotypeModelProperty.INSTANCE);
        } else {
            stereotypeModel = fallback.map(Supplier::get).orElse(null);
        }
        if (stereotypeModel != null) {
            declarer.withStereotype(stereotypeModel);
        }
    }

    public void addStereotypes(ParameterModelParser parser, ParameterDeclarer declarer) {
        declarer.getDeclaration().getAllowedStereotypeModels().addAll(parser.getAllowedStereotypes(this.stereotypeModelFactory));
    }

    public void addAllowedStereotypes(AllowedStereotypesModelParser parser, NestedComponentDeclarer declarer) {
        List<StereotypeModel> allowedStereotypes = parser.getAllowedStereotypes(this.stereotypeModelFactory);
        if (allowedStereotypes.isEmpty()) {
            declarer.withAllowedStereotypes(MuleStereotypes.PROCESSOR);
        } else {
            allowedStereotypes.forEach(xva$0 -> declarer.withAllowedStereotypes((StereotypeModel)xva$0));
        }
    }

    public void resolveDeclaredTypesStereotypes(ExtensionDeclaration declaration) {
        HashMap subTypeToParent = new HashMap();
        declaration.getSubTypes().forEach(subTypeModel -> subTypeModel.getSubTypes().forEach(subType -> subTypeToParent.put(subType, subTypeModel.getBaseType())));
        ObjectTypeStereotypeResolver resolver = (type, def) -> this.resolveStereotype((Class<?>)def, (ObjectType)type, this.namespace, subTypeToParent);
        LegacyObjectTypeStereotypeResolver legacyResolver = (type, def) -> this.resolveStereotype((Class<?>)def, (ObjectType)type, this.namespace, subTypeToParent);
        declaration.getTypes().forEach(type -> this.resolveStereotype((ObjectType)type, resolver, legacyResolver));
    }

    private StereotypeModel resolveStereotype(Class<?> def, ObjectType type, String namespace, Map<ObjectType, ObjectType> subTypeToParent) {
        if (def.equals(org.mule.sdk.api.stereotype.ImplicitStereotypeDefinition.class) || def.equals(ImplicitStereotypeDefinition.class)) {
            namespace = this.resolveImportedTypeNamespace(type, namespace);
            String stereotypeName = this.toStereotypeName(type.getAnnotation(ClassInformationAnnotation.class).get().getClassname());
            ObjectType parentObjectType = subTypeToParent.get(type);
            org.mule.sdk.api.stereotype.ImplicitStereotypeDefinition definition = parentObjectType != null ? new org.mule.sdk.api.stereotype.ImplicitStereotypeDefinition(stereotypeName, new org.mule.sdk.api.stereotype.ImplicitStereotypeDefinition(this.toStereotypeName(parentObjectType.getAnnotation(ClassInformationAnnotation.class).get().getClassname()))) : new org.mule.sdk.api.stereotype.ImplicitStereotypeDefinition(stereotypeName);
            return this.stereotypeModelFactory.createStereotype(definition, namespace);
        }
        return this.stereotypeModelFactory.createStereotype(SdkStereotypeDefinitionAdapter.from(def), namespace);
    }

    private String toStereotypeName(String classname) {
        return NameUtils.underscorize(classname.substring(classname.lastIndexOf(".") + 1)).toUpperCase();
    }

    private void resolveStereotype(ObjectType type, final ObjectTypeStereotypeResolver resolver, final LegacyObjectTypeStereotypeResolver legacyResolver) {
        type.accept(new MetadataTypeVisitor(){
            private final Set<MetadataType> registeredTypes = new LinkedHashSet<MetadataType>();

            @Override
            public void visitObject(ObjectType objectType) {
                if (!this.registeredTypes.contains(objectType) && !objectType.getAnnotation(InfrastructureTypeAnnotation.class).isPresent()) {
                    this.registeredTypes.add(objectType);
                    objectType.getAnnotation(StereotypeTypeAnnotation.class).ifPresent(a -> a.resolveAllowedStereotypes(objectType, resolver, legacyResolver));
                    objectType.getFields().forEach(f -> f.getValue().accept(this));
                    objectType.getOpenRestriction().ifPresent(open -> open.accept(this));
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept(this);
            }

            @Override
            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(t -> t.accept(this));
            }

            @Override
            public void visitIntersection(IntersectionType intersectionType) {
                intersectionType.getTypes().forEach(t -> t.accept(this));
            }
        });
    }

    private String resolveImportedTypeNamespace(ObjectType type, String defaultNamespace) {
        return MetadataTypeUtils.getTypeId(type).flatMap(typeId -> this.dslResolvingContext.getExtensionForType((String)typeId)).map(ExtensionNamespaceUtils::getExtensionsNamespace).orElse(defaultNamespace);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace.toUpperCase();
        this.stereotypeModelFactory.setNamespace(this.namespace);
    }

    @FunctionalInterface
    static interface LegacyObjectTypeStereotypeResolver
    extends BiFunction<ObjectType, Class<? extends StereotypeDefinition>, StereotypeModel> {
    }

    @FunctionalInterface
    static interface ObjectTypeStereotypeResolver
    extends BiFunction<ObjectType, Class<? extends org.mule.sdk.api.stereotype.StereotypeDefinition>, StereotypeModel> {
    }
}

