/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.mule.runtime.extension.api.annotation.param.stereotype.Validator;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.WithAnnotations;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.SdkStereotypeDefinitionAdapter;
import org.mule.sdk.api.stereotype.StereotypeDefinition;

public final class JavaStereotypeModelParserUtils {
    public static boolean isValidator(WithAnnotations element) {
        return element.isAnnotatedWith(Validator.class) || element.isAnnotatedWith(org.mule.sdk.api.annotation.param.stereotype.Validator.class);
    }

    public static Optional<StereotypeModel> resolveStereotype(WithAnnotations annotatedElement, String elementType, String elementName, StereotypeModelFactory factory) {
        StereotypeDefinition stereotypeDefinition = MuleExtensionAnnotationParser.mapReduceSingleAnnotation(annotatedElement, elementType, elementName, Stereotype.class, org.mule.sdk.api.annotation.param.stereotype.Stereotype.class, value -> value.getClassValue(Stereotype::value), value -> value.getClassValue(org.mule.sdk.api.annotation.param.stereotype.Stereotype::value)).flatMap(type -> type.getDeclaringClass()).map(SdkStereotypeDefinitionAdapter::from).orElse(null);
        if (JavaStereotypeModelParserUtils.isValidator(annotatedElement)) {
            if (stereotypeDefinition != null) {
                throw new IllegalModelDefinitionException(String.format("%s '%s' is annotated with both @%s and @%s. Only one can be provided at the same time for the same component", elementType, elementName, Stereotype.class.getSimpleName(), Validator.class.getSimpleName()));
            }
            return Optional.of(factory.getValidatorStereotype());
        }
        if (stereotypeDefinition != null) {
            return Optional.of(factory.createStereotype(stereotypeDefinition));
        }
        return Optional.empty();
    }

    public static List<StereotypeModel> getAllowedStereotypes(WithAnnotations element, WithAnnotations fallbackElement, StereotypeModelFactory factory) {
        List<StereotypeModel> stereotypes = JavaStereotypeModelParserUtils.getAllowedStereotypes(element, factory);
        if (stereotypes.isEmpty()) {
            stereotypes = JavaStereotypeModelParserUtils.getAllowedStereotypes(fallbackElement, factory);
        }
        return stereotypes;
    }

    public static List<StereotypeModel> getAllowedStereotypes(WithAnnotations element, StereotypeModelFactory factory) {
        return Stream.concat(JavaStereotypeModelParserUtils.getAllowedTypeStream(element, AllowedStereotypes.class, AllowedStereotypes::value), JavaStereotypeModelParserUtils.getAllowedTypeStream(element, org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes.class, org.mule.sdk.api.annotation.param.stereotype.AllowedStereotypes::value)).map(type -> factory.createStereotype(SdkStereotypeDefinitionAdapter.from(type.getDeclaringClass().get()))).collect(Collectors.toList());
    }

    public static StereotypeDefinition asDefinition(final StereotypeModel model) {
        return new StereotypeDefinition(){

            @Override
            public String getName() {
                return model.getType();
            }

            @Override
            public String getNamespace() {
                return model.getNamespace();
            }

            @Override
            public Optional<StereotypeDefinition> getParent() {
                return model.getParent().map(parent -> JavaStereotypeModelParserUtils.asDefinition(parent));
            }
        };
    }

    private static <A extends Annotation> Stream<Type> getAllowedTypeStream(WithAnnotations element, Class<A> annotationType, Function<A, Class[]> mapper) {
        return element.getValueFromAnnotation(annotationType).map(value -> value.getClassArrayValue(mapper).stream().filter(type -> type.getDeclaringClass().isPresent())).orElse(Stream.empty());
    }

    private JavaStereotypeModelParserUtils() {
    }
}

