/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.OperationElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.api.loader.java.type.TypeGeneric;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;

public class OperationReturnTypeModelValidator
implements ExtensionModelValidator {
    private static final String MISSING_GENERICS_ERROR_MESSAGE = "Operation [%s] in extension [%s] has a '%s' as return type but their generics were not provided. Please provide the Payload and Attributes generics.";
    private static final String INVALID_GENERICS_ERROR_MESSAGE = "Operation [%s] in extension [%s] has a '%s' as return type with Void type for output but non Void type for attributes";
    private final List<Class<?>> illegalReturnTypes = ImmutableList.of(CoreEvent.class, Message.class);

    @Override
    public void validate(final ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel operationModel) {
                if (operationModel.getOutput() == null || operationModel.getOutput().getType() == null) {
                    throw OperationReturnTypeModelValidator.this.missingReturnTypeException(extensionModel, operationModel);
                }
                operationModel.getModelProperty(ExtensionOperationDescriptorModelProperty.class).ifPresent(mp -> {
                    OperationElement operationMethod = mp.getOperationElement();
                    Type returnType = mp.getOperationElement().getReturnType();
                    OperationReturnTypeModelValidator.this.validateNonBlockingCallback(operationMethod, problemsReporter, operationModel, extensionModel);
                    OperationReturnTypeModelValidator.this.validateResultReturnType(returnType, problemsReporter, operationModel, extensionModel);
                    OperationReturnTypeModelValidator.this.validateMessageCollectionsReturnType(returnType, problemsReporter, operationModel, extensionModel);
                    OperationReturnTypeModelValidator.this.validateForbiddenTypesReturnType(returnType, problemsReporter, operationModel, extensionModel);
                });
            }
        }.walk(extensionModel);
    }

    private void validateForbiddenTypesReturnType(Type returnType, ProblemsReporter problemsReporter, OperationModel operationModel, ExtensionModel extensionModel) {
        this.illegalReturnTypes.stream().filter(returnType::isAssignableTo).findFirst().ifPresent(forbiddenType -> problemsReporter.addError(new Problem(operationModel, String.format("Operation '%s' in Extension '%s' specifies '%s' as a return type. Operations are not allowed to return objects of that type", operationModel.getName(), extensionModel.getName(), forbiddenType.getName()))));
    }

    private void validateNonBlockingCallback(MethodElement<? extends Type> operationMethod, ProblemsReporter problemsReporter, OperationModel operationModel, ExtensionModel extensionModel) {
        operationMethod.getParameters().stream().filter(JavaExtensionModelParserUtils::isCompletionCallbackParameter).findFirst().ifPresent(extensionParameter -> {
            List<TypeGeneric> generics = extensionParameter.getType().getGenerics();
            if (generics.isEmpty()) {
                problemsReporter.addError(new Problem((NamedObject)extensionParameter, String.format(MISSING_GENERICS_ERROR_MESSAGE, operationModel.getName(), extensionModel.getName(), CompletionCallback.class.getName())));
            } else {
                this.validateGenerics(extensionModel, (NamedObject)extensionParameter, operationModel, generics, CompletionCallback.class, problemsReporter);
            }
        });
    }

    private void validateResultReturnType(Type returnType, ProblemsReporter problemsReporter, OperationModel operationModel, ExtensionModel extensionModel) {
        if (returnType.isAssignableTo(Result.class)) {
            List<TypeGeneric> generics = returnType.getGenerics();
            if (generics.isEmpty()) {
                problemsReporter.addError(new Problem(operationModel, String.format(MISSING_GENERICS_ERROR_MESSAGE, operationModel.getName(), extensionModel.getName(), Result.class)));
            } else {
                this.validateGenerics(extensionModel, operationModel, operationModel, generics, Result.class, problemsReporter);
            }
        }
    }

    private void validateMessageCollectionsReturnType(Type returnType, ProblemsReporter problemsReporter, OperationModel operationModel, ExtensionModel extensionModel) {
        Type concreteType;
        List<TypeGeneric> generics;
        if (returnType.isAssignableTo(Collection.class) && !(generics = returnType.getGenerics()).isEmpty() && (concreteType = generics.get(0).getConcreteType()).isAssignableTo(Result.class)) {
            List<TypeGeneric> concreteTypeGenerics = concreteType.getGenerics();
            if (concreteTypeGenerics.isEmpty()) {
                problemsReporter.addError(new Problem(operationModel, String.format(MISSING_GENERICS_ERROR_MESSAGE, operationModel.getName(), extensionModel.getName(), Result.class)));
            } else {
                this.validateGenerics(extensionModel, operationModel, operationModel, concreteTypeGenerics, Result.class, problemsReporter);
            }
        }
    }

    private IllegalModelDefinitionException missingReturnTypeException(ExtensionModel model, OperationModel operationModel) {
        throw new IllegalOperationModelDefinitionException(String.format("Operation '%s' in Extension '%s' is missing a return type", operationModel.getName(), model.getName()));
    }

    private void validateGenerics(ExtensionModel extensionModel, NamedObject namedObject, OperationModel operationModel, List<TypeGeneric> generics, Class returnType, ProblemsReporter problemsReporter) {
        if (generics.get(0).getConcreteType().isSameType(Void.class) && !generics.get(1).getConcreteType().isSameType(Void.class)) {
            problemsReporter.addWarning(new Problem(namedObject, String.format(INVALID_GENERICS_ERROR_MESSAGE, operationModel.getName(), extensionModel.getName(), returnType.getName())));
        }
    }
}

