/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationState;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.ImmutableConfigurationState;
import org.mule.runtime.module.extension.internal.runtime.config.LifecycleAwareConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ConfigurationInstanceFactory<T> {
    private final ConfigurationModel configurationModel;
    private final ConfigurationObjectBuilder<T> configurationObjectBuilder;
    private final boolean requiresConnection;
    private final ExpressionManager expressionManager;
    private final MuleContext muleContext;

    public ConfigurationInstanceFactory(ExtensionModel extensionModel, ConfigurationModel configurationModel, ResolverSet resolverSet, ExpressionManager expressionManager, MuleContext context) {
        this.configurationModel = configurationModel;
        this.expressionManager = expressionManager;
        this.muleContext = context;
        this.configurationObjectBuilder = new ConfigurationObjectBuilder(configurationModel, resolverSet, expressionManager, context);
        this.requiresConnection = ExtensionModelUtils.supportsConnectivity(extensionModel, configurationModel);
    }

    public <C> ConfigurationInstance createConfiguration(String name, CoreEvent event, ConnectionProviderValueResolver<C> resolver) throws MuleException {
        Optional<Pair<ConnectionProvider<Object>, ResolverSetResult>> connectionProvider;
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, event);
        if (this.requiresConnection) {
            try (ValueResolvingContext ctx = ValueResolvingContext.builder(event, this.expressionManager).withProperty("Configuration model", this.configurationModel).build();){
                connectionProvider = Optional.ofNullable(resolver.resolve(ctx));
            }
        } else {
            connectionProvider = Optional.empty();
        }
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState(configValue.getSecond(), connectionProvider), connectionProvider.map(Pair::getFirst));
    }

    public <C> ConfigurationInstance createConfiguration(String name, ResolverSetResult configValues, CoreEvent event, Optional<ConnectionProviderValueResolver<C>> connectionProviderResolver) throws MuleException {
        Optional<Pair<ConnectionProvider<Object>, ResolverSetResult>> connectionProvider;
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, configValues);
        if (this.requiresConnection && connectionProviderResolver.isPresent()) {
            ConnectionProviderValueResolver<C> resolver = connectionProviderResolver.get();
            try (ValueResolvingContext cxt = ValueResolvingContext.builder(event, this.expressionManager).build();){
                connectionProvider = Optional.ofNullable(resolver.resolve(cxt));
            }
        } else {
            connectionProvider = Optional.empty();
        }
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState(configValue.getSecond(), connectionProvider), connectionProvider.map(Pair::getFirst));
    }

    public <C> ConfigurationInstance createConfiguration(String name, ResolverSetResult configValues, CoreEvent event, ConnectionProviderValueResolver<C> resolver, ResolverSetResult connectionProviderValues) throws MuleException {
        Pair<T, ResolverSetResult> configValue = this.createConfigurationInstance(name, configValues);
        Optional<Object> connectionProvider = Optional.empty();
        if (this.requiresConnection && resolver != null) {
            if (resolver.getObjectBuilder().isPresent()) {
                connectionProvider = Optional.ofNullable(resolver.getObjectBuilder().get().build(connectionProviderValues));
            }
            if (!connectionProvider.isPresent()) {
                try (ValueResolvingContext context = ValueResolvingContext.builder(event, this.expressionManager).build();){
                    connectionProvider = Optional.ofNullable(resolver.resolve(context));
                }
            }
        }
        return new LifecycleAwareConfigurationInstance(name, this.configurationModel, configValue.getFirst(), this.createState(configValue.getSecond(), connectionProvider), connectionProvider.map(Pair::getFirst));
    }

    private Pair<T, ResolverSetResult> createConfigurationInstance(String name, ResolverSetResult resolverSetResult) throws MuleException {
        Object config = this.configurationObjectBuilder.build(resolverSetResult);
        MuleVersion muleVersion = new MuleVersion(MuleExtensionModelProvider.MULE_VERSION);
        IntrospectionUtils.injectFields(this.configurationModel, ((Pair)config).getFirst(), name, this.muleContext.getConfiguration().getDefaultEncoding(), muleVersion);
        return config;
    }

    private Pair<T, ResolverSetResult> createConfigurationInstance(String name, CoreEvent event) throws MuleException {
        try (ValueResolvingContext context = ValueResolvingContext.builder(event).withExpressionManager(this.expressionManager).build();){
            Pair config = (Pair)this.configurationObjectBuilder.build(context);
            String muleversion = MuleExtensionModelProvider.MULE_VERSION;
            MuleVersion muleVersion = new MuleVersion(muleversion);
            IntrospectionUtils.injectFields(this.configurationModel, config.getFirst(), name, this.muleContext.getConfiguration().getDefaultEncoding(), muleVersion);
            Pair pair = config;
            return pair;
        }
    }

    private <C> ConfigurationState createState(ResolverSetResult configValues, Optional<Pair<ConnectionProvider<C>, ResolverSetResult>> connectionProvider) {
        return new ImmutableConfigurationState(this.nullSafeMap(configValues), connectionProvider.map(p -> this.nullSafeMap((ResolverSetResult)p.getSecond())).orElseGet(Collections::emptyMap));
    }

    private Map<String, Object> nullSafeMap(ResolverSetResult result) {
        return result.asMap().entrySet().stream().filter(entry -> entry.getValue() != null).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
    }
}

