/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.internal.DefaultComponentAst;
import org.mule.runtime.ast.internal.builder.ApplicationModelTypeUtils;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;

public class DefaultComponentAstBuilder
extends BaseComponentAstBuilder<DefaultComponentAstBuilder> {
    private final ExtensionModelHelper extModelHelper;
    private final List<DefaultComponentAstBuilder> hierarchy;
    private final int indexInParent;

    public DefaultComponentAstBuilder(PropertiesResolver propertiesResolver, ExtensionModelHelper extModelHelper, List<DefaultComponentAstBuilder> hierarchy, int indexInParent) {
        super(propertiesResolver);
        this.extModelHelper = extModelHelper;
        this.hierarchy = hierarchy;
        this.indexInParent = indexInParent;
    }

    @Override
    public ComponentAstBuilder addChildComponent() {
        ArrayList<DefaultComponentAstBuilder> childHierarchy = new ArrayList<DefaultComponentAstBuilder>(this.hierarchy);
        childHierarchy.add(this);
        DefaultComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.getPropertiesResolver(), this.extModelHelper, childHierarchy, (int)this.childComponentsStream().count());
        this.addChildComponent(componentAstBuilder);
        return componentAstBuilder;
    }

    @Override
    public ComponentAstBuilder withIdentifier(ComponentIdentifier identifier) {
        this.extModelHelper.lookupExtensionModelFor(identifier).ifPresent(this::withExtensionModel);
        return super.withIdentifier(identifier);
    }

    @Override
    public ComponentAst get() {
        return this.build();
    }

    @Override
    public ComponentAst build() {
        this.prepareForBuild();
        return this.doBuild();
    }

    @Override
    protected void prepareForBuild() {
        Objects.requireNonNull(this.getIdentifier(), "identifier");
        Objects.requireNonNull(this.getMetadata(), "metadata");
        if (!this.getModel(Object.class).isPresent()) {
            ApplicationModelTypeUtils.resolveTypedComponentIdentifier(this, this.hierarchy.isEmpty(), this.extModelHelper);
        }
        super.prepareForBuild();
        this.childComponentsStream().forEach(DefaultComponentAstBuilder::prepareForBuild);
    }

    private ComponentAst doBuild() {
        Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts = this.createParameterAsts();
        Supplier<Optional<String>> componentId = this.obtainLocation(parameterAsts);
        this.resolveParamsLocations();
        List<ComponentAst> builtChildren = this.childComponentsStream().map(DefaultComponentAstBuilder::doBuild).collect(Collectors.toList());
        HashMap<String, String> extraParams = new HashMap<String, String>(this.getRawParameters());
        parameterAsts.keySet().forEach(k -> {
            String cfr_ignored_0 = (String)extraParams.remove(((ParameterModel)k.getFirst()).getName());
        });
        return new DefaultComponentAst(builtChildren, parameterAsts, extraParams, this.getPropertiesResolver(), this.getAnnotations(), componentId, this.getExtensionModel(), this.getModel(ComponentModel.class).orElse(null), this.getModel(NestableElementModel.class).orElse(null), this.getModel(ConfigurationModel.class).orElse(null), this.getModel(ConnectionProviderModel.class).orElse(null), this.getModel(ParameterizedModel.class).orElse(null), this.getType(), this.getGenerationInformation().build(), this.getMetadata(), this.getLocation(), this.getIdentifier(), this.getComponentType());
    }

    protected void resolveParamsLocations() {
        this.getParamsChildren().stream().filter(pc -> pc.componentId == null).forEach(pc -> {
            pc.obtainLocation(pc.createParameterAsts());
            pc.resolveParamsLocations();
        });
        this.childComponentsStream().filter(pc -> pc.componentId == null).forEach(pc -> {
            pc.obtainLocation(pc.createParameterAsts());
            pc.resolveParamsLocations();
        });
    }

    protected Supplier<Optional<String>> obtainLocation(Map<Pair<ParameterModel, ParameterGroupModel>, ComponentParameterAst> parameterAsts) {
        LazyValue<Supplier<Optional>> componentId = new LazyValue<Supplier<Optional>>(() -> this.resolveComponentId(parameterAsts));
        this.setComponentId(componentId);
        ComponentLocationVisitor.resolveLocation(this, this.hierarchy);
        return componentId;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }
}

