/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization;

import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.internal.serialization.InternalArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.json.JsonArtifactAstSerializer;

public class ArtifactAstSerializerFactory {
    public static final String JSON = "JSON";
    private final Executor executor;
    private final Supplier<ArtifactAstSerializer> jsonArtifactAstSerializer_1_0_LazyValue;
    private final Supplier<InternalArtifactAstDeserializer> jsonArtifactAstDeserializer_1_0_LazyValue;

    public ArtifactAstSerializerFactory() {
        this(Executors.newSingleThreadExecutor(), true);
    }

    public ArtifactAstSerializerFactory(Executor executor, boolean populateGenerationInformation) {
        Objects.requireNonNull(executor);
        this.executor = executor;
        this.jsonArtifactAstSerializer_1_0_LazyValue = new LazyValue<Supplier<ArtifactAstSerializer>>(() -> new JsonArtifactAstSerializer(this.executor));
        this.jsonArtifactAstDeserializer_1_0_LazyValue = new LazyValue<Supplier<InternalArtifactAstDeserializer>>(() -> new JsonArtifactAstDeserializer(new GsonBuilder(), populateGenerationInformation));
    }

    public ArtifactAstSerializer getSerializer(String format, String serializerVersion) throws IllegalArgumentException {
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(serializerVersion, "serializerVersion");
        if (JSON.equals(format) && "1.0".equals(serializerVersion)) {
            return this.jsonArtifactAstSerializer_1_0_LazyValue.get();
        }
        throw new IllegalArgumentException(String.format("No serializer named '%s' is available. Available serializers are: [" + StringUtils.join(this.getAvailableSerializers(), (String)", ") + "]", format));
    }

    public InternalArtifactAstDeserializer getDeserializer(String format, String serializerVersion) throws IllegalArgumentException {
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(serializerVersion, "serializerVersion");
        if (JSON.equals(format) && "1.0".equals(serializerVersion)) {
            return this.jsonArtifactAstDeserializer_1_0_LazyValue.get();
        }
        throw new IllegalArgumentException(String.format("No deserializer named '%s' version '%s' is available. Available deserializers are: [" + StringUtils.join(this.getAvailableSerializers(), (String)", ") + "]", format, serializerVersion));
    }

    final List<String> getAvailableSerializers() {
        return Collections.singletonList("JSON[1.0]");
    }
}

