/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.ParameterResolutionException;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.model.RawParameterModel;
import org.mule.runtime.ast.internal.serialization.dto.ComponentAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentGenerationInformationDTO;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ImportedResourceDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.visitor.ArrayMetadataVisitor;
import org.mule.runtime.ast.internal.serialization.visitor.SetComponentAstDTOTypeMetadataTypeVisitor;
import org.mule.runtime.ast.internal.serialization.visitor.SimpleTypeComponentMetadataTypeVisitor;
import org.mule.runtime.ast.internal.serialization.visitor.UnionTypesVisitor;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentParameterAstDTO
implements ComponentParameterAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentParameterAstDTO.class);
    private static final String DEFAULT_EXPRESSION_PREFIX = "#[";
    private static final String DEFAULT_EXPRESSION_SUFFIX = "]";
    private static final Class<? extends ModelProperty> allowsExpressionWithoutMarkersModelPropertyClass;
    private final String unresolvedValue;
    private final ComponentMetadataAstDTO metadata;
    private final String groupModelName;
    private final String modelName;
    private ParameterValueContainer value;
    private final boolean defaultValue;
    private ComponentGenerationInformationDTO generationInformation;
    private transient String resolvedRawValue;
    private transient ParameterModel model;
    private transient ParameterGroupModel groupModel;
    private transient PropertiesResolver propertiesResolver;

    public ComponentParameterAstDTO(ParameterValueContainer value, String unresolvedValue, boolean defaultValue, ComponentMetadataAstDTO metadata, String groupModelName, String modelName) {
        this.value = value;
        this.unresolvedValue = unresolvedValue;
        this.defaultValue = defaultValue;
        this.metadata = metadata;
        this.groupModelName = groupModelName;
        this.modelName = modelName;
    }

    @Override
    public ParameterModel getModel() {
        return this.model;
    }

    @Override
    public ParameterGroupModel getGroupModel() {
        return this.groupModel;
    }

    @Override
    public <T> Either<String, T> getValue() {
        if (this.value != null && this.value.isFixedValue()) {
            if (this.value.getContainedValue() instanceof String) {
                this.resolvedRawValue = (String)this.value.getContainedValue();
            }
            return this.rightValue(this.value.getContainedValue());
        }
        if (this.value != null && this.value.isExpression()) {
            return Either.left(this.value.getExpression());
        }
        if (this.unresolvedValue != null) {
            if (this.isAnExpression()) {
                this.resolvedRawValue = this.propertiesResolver != null ? this.propertiesResolver.apply(this.unresolvedValue) : this.unresolvedValue;
                this.value = new ParameterValueContainer(this.extractExpression(this.resolvedRawValue), null);
                return Either.left(this.value.getExpression());
            }
            if (this.propertiesResolver == null) {
                return Either.empty();
            }
            this.resolvedRawValue = this.propertiesResolver.apply(this.unresolvedValue);
            this.value = new ParameterValueContainer(null, this.resolvedRawValue);
            return this.rightValue(this.value.getContainedValue());
        }
        if (this.model == null) {
            throw new IllegalStateException("Cannot resolve value for parameter without model");
        }
        Object defaultValue = this.model.getDefaultValue();
        if (defaultValue == null) {
            this.value = null;
            return Either.empty();
        }
        if (defaultValue instanceof String) {
            this.resolvedRawValue = this.propertiesResolver.apply(defaultValue.toString());
            this.value = new ParameterValueContainer(null, this.resolvedRawValue);
            return this.rightValue(this.value.getContainedValue());
        }
        if (this.model.getType().getAnnotation(EnumAnnotation.class).isPresent()) {
            this.resolvedRawValue = ((Enum)defaultValue).name();
            this.value = new ParameterValueContainer(null, this.resolvedRawValue);
            return this.rightValue(this.value.getContainedValue());
        }
        this.value = new ParameterValueContainer(null, defaultValue);
        return this.rightValue(defaultValue);
    }

    @Override
    public <T> Either<String, Either<ParameterResolutionException, T>> getValueOrResolutionError() {
        try {
            return this.getValue().mapRight(fixedValue -> Either.right(fixedValue));
        }
        catch (ParameterResolutionException e) {
            return Either.right(Either.left(e));
        }
    }

    private boolean isAnExpression() {
        return this.model != null && (ExpressionSupport.SUPPORTED.equals((Object)this.model.getExpressionSupport()) || ExpressionSupport.REQUIRED.equals((Object)this.model.getExpressionSupport())) && this.isExpression(this.unresolvedValue);
    }

    private boolean isExpression(Object value) {
        if (value instanceof String) {
            String trim = ((String)value).trim();
            if (trim.startsWith(DEFAULT_EXPRESSION_PREFIX) && trim.endsWith(DEFAULT_EXPRESSION_SUFFIX)) {
                return true;
            }
            return allowsExpressionWithoutMarkersModelPropertyClass != null && this.getModel().getModelProperty(allowsExpressionWithoutMarkersModelPropertyClass).isPresent();
        }
        return false;
    }

    public String extractExpression(String expression) {
        String trimmedText = expression.trim();
        if (trimmedText.startsWith(DEFAULT_EXPRESSION_PREFIX) && trimmedText.endsWith(DEFAULT_EXPRESSION_SUFFIX)) {
            return trimmedText.substring(DEFAULT_EXPRESSION_PREFIX.length(), trimmedText.length() - DEFAULT_EXPRESSION_SUFFIX.length());
        }
        return trimmedText;
    }

    private <T> Either<String, T> rightValue(Object value) {
        return Either.right(String.class, value);
    }

    @Override
    public String getRawValue() {
        return this.unresolvedValue;
    }

    @Override
    public String getResolvedRawValue() {
        if (this.resolvedRawValue == null) {
            this.getValue();
        }
        if (this.resolvedRawValue == null) {
            this.resolvedRawValue = this.unresolvedValue;
        }
        return this.resolvedRawValue;
    }

    @Override
    public Optional<ComponentMetadataAst> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    public ComponentGenerationInformation getGenerationInformation() {
        return this.generationInformation;
    }

    @Override
    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void setModel(ParameterModel parameterModel, ParameterGroupModel parameterGroupModel) {
        this.model = parameterModel;
        this.groupModel = parameterGroupModel;
    }

    public void setGenerationInformation(ComponentGenerationInformationDTO generationInformation) {
        this.generationInformation = generationInformation;
    }

    public String getGroupModelName() {
        return this.groupModelName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
        if (this.value != null && this.value.isFixedValue() && this.isValueAListOfComponentAstDTOs()) {
            List componentAstDTOS = (List)this.value.getContainedValue();
            componentAstDTOS.forEach(componentAstDTO -> componentAstDTO.setPropertiesResolver(propertiesResolver));
        }
        if (this.value != null && this.value.isFixedValue() && this.isValueAComponentAstDTO()) {
            ComponentAstDTO componentAstDTO2 = (ComponentAstDTO)this.value.getContainedValue();
            componentAstDTO2.setPropertiesResolver(propertiesResolver);
        }
        propertiesResolver.onMappingFunctionChanged(() -> {
            if (this.unresolvedValue != null && this.unresolvedValue.contains("${")) {
                this.resolvedRawValue = null;
                this.value = null;
            }
        });
    }

    public PropertiesResolver getPropertiesResolver() {
        return this.propertiesResolver;
    }

    public String toString() {
        return "ComponentParameterAstDTO{groupModelName='" + this.groupModelName + "', modelName='" + this.modelName + "', value='" + this.value + ", unresolvedValue='" + this.unresolvedValue + "'}";
    }

    private void resolveMapEntriesElementsModels(ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        List<ComponentAstDTO> componentAstDTOList = this.getValueAsComponentAstDTOList();
        componentAstDTOList.forEach(componentAstDTO -> {
            componentAstDTO.resolveMapEntryComponentModels(parentComponentAstDTO, this, extensionModelHelper, extensionModelResolver, generationInformationResolver);
            componentAstDTO.directChildrenStream().map(childComponentAst -> (ComponentAstDTO)childComponentAst).forEach(childComponentAstDTO -> childComponentAstDTO.resolveModelsRecursively((ComponentAstDTO)componentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver));
        });
    }

    public void resolveListElementModels(ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        this.model.getType().accept(new ArrayMetadataVisitor(new SimpleTypeComponentMetadataTypeVisitor(this, extensionModelHelper, generationInformationResolver, extensionModelResolver)));
    }

    private boolean isListOfSimpleTypeValuesAsComponent() {
        return this.isValueAListOfComponentAstDTOs() && this.getValueAsComponentAstDTOList().stream().allMatch(componentAstDTO -> componentAstDTO.isSimpleTypeComponent());
    }

    public ParameterModel resolveParameterModelFromOwnerMetadataTypeModelAdapter(MetadataTypeModelAdapter metadataTypeModelAdapter) {
        return metadataTypeModelAdapter.getAllParameterModels().stream().filter(parameterModel -> parameterModel.getName().equals(this.getModelName())).findFirst().orElse(new RawParameterModel(this.modelName));
    }

    void resolveModelParameter(ComponentAstDTO ownerComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enrichment: resolveModelParameter({}, {})", (Object)ownerComponentAstDTO, (Object)this);
        this.model = ownerComponentAstDTO.resolveParameterModel(this);
        this.groupModel = ownerComponentAstDTO.resolveParameterGroupModel(this);
        LOGGER.debug("Enrichment: resolveModelParameter, resolved groupModel and model: {}, {}", (Object)this.groupModel, (Object)this.model);
        AtomicBoolean paramProcessed = new AtomicBoolean();
        if (this.model.getType() != null) {
            this.model.getType().accept(new UnionTypesVisitor(this, extensionModelHelper, paramProcessed));
        }
        if (ownerComponentAstDTO.isWrapped(this, extensionModelHelper)) {
            LOGGER.debug("Enrichment: resolveModelParameter, isWrapped {}", (Object)ownerComponentAstDTO, (Object)this);
            this.resolveParameterValueModel(ownerComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver);
            if (!paramProcessed.get()) {
                this.generationInformation = generationInformationResolver.resolveWrappedComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
                LOGGER.debug("Enrichment: resolveModelParameter, generationInformation: {}", (Object)this.generationInformation);
            }
        } else {
            if (!paramProcessed.get()) {
                this.generationInformation = generationInformationResolver.resolveRegularComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
                LOGGER.debug("Enrichment: resolveModelParameter, generationInformation: {}", (Object)this.generationInformation);
            }
            this.resolveParameterValueModel(ownerComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver);
        }
    }

    public boolean isValueAComponentAstDTO() {
        return this.getValue() != null && this.getValue().isRight() && this.getValue().getRight() instanceof ComponentAstDTO;
    }

    public boolean isValueAListOfComponentAstDTOs() {
        return this.getValue() != null && this.getValue().isRight() && this.getValue().getRight() instanceof List && !((List)this.getValue().getRight()).isEmpty() && ((List)this.getValue().getRight()).get(0) instanceof ComponentAstDTO;
    }

    private void resolveParameterValueModel(ComponentAstDTO parentComponentAstDTO, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver) {
        if (this.isValueAComponentAstDTO()) {
            ComponentAstDTO valueComponentAstDTO = this.getValueAsComponentAstDTO();
            LOGGER.debug("Enrichment: resolveParameterValueModel, value is ComponentAstDTO, parameter {} value {}", (Object)this, (Object)valueComponentAstDTO);
            this.model.getType().accept(new SetComponentAstDTOTypeMetadataTypeVisitor(valueComponentAstDTO));
            valueComponentAstDTO.resolveModelsRecursively(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver);
        } else if (this.isListOfSimpleTypeValuesAsComponent()) {
            LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of Simple ComponentAstDTO, parameter {}", (Object)this);
            this.resolveListElementModels(extensionModelHelper, extensionModelResolver, generationInformationResolver);
        } else if (this.isValueAMap()) {
            LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of Map, parameter {}", (Object)this);
            this.resolveMapEntriesElementsModels(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver);
        } else if (this.isValueAListOfComponentAstDTOs()) {
            LOGGER.debug("Enrichment: resolveParameterValueModel, value is list of ComponentAstDTOs, parameter {}", (Object)this);
            this.getValueAsComponentAstDTOList().forEach(componentParamValueItem -> componentParamValueItem.resolveModelsRecursively(parentComponentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver));
        }
    }

    void resolveMapEntryAttribute(ParameterModel ownerParameterModel, ComponentGenerationInformation ownerParameterGenerationInformation, ExtensionModelHelper extensionModelHelper, ExtensionModelResolver extensionModelResolver, GenerationInformationResolver generationInformationResolver, ComponentAstDTO componentAstDTO) {
        switch (this.modelName) {
            case "key": {
                ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
                this.model = new ImmutableParameterModel("key", "", typeLoader.load((Type)((Object)String.class)), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                this.groupModel = componentAstDTO.resolveParameterGroupModel(this);
                this.generationInformation = generationInformationResolver.resolveGenerationInformationThroughParent("key", componentAstDTO, ownerParameterModel, ownerParameterGenerationInformation.getSyntax().get());
                break;
            }
            case "value": {
                this.model = new ImmutableParameterModel("value", "", this.resolveMapEntryValueType(ownerParameterModel), false, true, false, false, ExpressionSupport.SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
                this.groupModel = componentAstDTO.resolveParameterGroupModel(this);
                this.generationInformation = generationInformationResolver.resolveGenerationInformationThroughParent("value", componentAstDTO, ownerParameterModel, ownerParameterGenerationInformation.getSyntax().get());
                this.resolveParameterValueModel(componentAstDTO, extensionModelHelper, extensionModelResolver, generationInformationResolver);
                break;
            }
            case "name": {
                this.model = new RawParameterModel(this.getModelName());
                this.groupModel = componentAstDTO.resolveParameterGroupModel(this);
                this.generationInformation = generationInformationResolver.resolveComponentParameterAstGenerationInformation(this, componentAstDTO, extensionModelHelper);
            }
        }
    }

    private MetadataType resolveMapEntryValueType(ParameterModel ownerParameterModel) {
        if (ownerParameterModel.getType() instanceof ObjectType && ((ObjectType)ownerParameterModel.getType()).getOpenRestriction().isPresent()) {
            return ((ObjectType)ownerParameterModel.getType()).getOpenRestriction().get();
        }
        return ownerParameterModel.getType();
    }

    private ComponentAstDTO getValueAsComponentAstDTO() {
        return (ComponentAstDTO)this.getValue().getRight();
    }

    private List<ComponentAstDTO> getValueAsComponentAstDTOList() {
        return (List)this.getValue().getRight();
    }

    private boolean isValueAMap() {
        return this.isValueAListOfComponentAstDTOs() && ExtensionMetadataTypeUtils.isMap(this.model.getType());
    }

    void resolveInfrastructureParameter(ComponentAstDTO ownerComponentAstDTO, ExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        LOGGER.debug("Enrichment: resolveInfrastructureParameter: {} - {}", (Object)ownerComponentAstDTO, (Object)this);
        ParameterizedModel parameterizedModel = ownerComponentAstDTO.getModel(ParameterizedModel.class).get();
        this.model = this.resolveParameterModelFromOwnerMetadataTypeModelAdapter((MetadataTypeModelAdapter)parameterizedModel);
        this.groupModel = parameterizedModel.getParameterGroupModels().stream().filter(parameterModel -> parameterModel.getName().equals(this.getGroupModelName())).findFirst().orElse(null);
        AtomicBoolean paramProcessed = new AtomicBoolean();
        this.model.getType().accept(new UnionTypesVisitor(this, extensionModelHelper, paramProcessed));
        if (!paramProcessed.get()) {
            this.generationInformation = generationInformationResolver.crateComponentGenerationInformationFromParent(ownerComponentAstDTO, this);
        }
    }

    void enrichWithImportedResources(Map<String, ImportedResourceDTO> importResourcesByRawLocation) {
        LOGGER.debug("Enrichment: enrichWithImportedResources: {}", (Object)this);
        if (this.metadata != null) {
            this.metadata.enrich(importResourcesByRawLocation);
        }
        if (this.isValueAComponentAstDTO()) {
            this.getValueAsComponentAstDTO().enrichWithImportedResources(importResourcesByRawLocation);
            return;
        }
        if (this.isValueAListOfComponentAstDTOs()) {
            this.getValueAsComponentAstDTOList().forEach(componentAstDTO -> componentAstDTO.enrichWithImportedResources(importResourcesByRawLocation));
            return;
        }
    }

    void resolveSimpleTypeComponentParameter(ComponentAstDTO ownerComponentAstDTO, SimpleType simpleType, ExtensionModelHelper extensionModelHelper, GenerationInformationResolver generationInformationResolver) {
        this.model = this.resolveParameterModelFromOwnerMetadataTypeModelAdapter(MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter(simpleType, extensionModelHelper));
        this.groupModel = ownerComponentAstDTO.resolveParameterGroupModel(this);
        this.generationInformation = generationInformationResolver.resolveComponentParameterAstGenerationInformation(this, ownerComponentAstDTO, extensionModelHelper);
    }

    static {
        Class<?> foundClass = null;
        try {
            foundClass = Class.forName("org.mule.runtime.module.extension.api.loader.java.property.AllowsExpressionWithoutMarkersModelProperty");
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        allowsExpressionWithoutMarkersModelPropertyClass = foundClass;
    }
}

