/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import com.google.gson.internal.LinkedTreeMap;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ParameterValueContainerFactory {
    private final AstDTOFactoryProvider astDTOFactoryProvider;

    public ParameterValueContainerFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
        this.astDTOFactoryProvider = astDTOFactoryProvider;
    }

    ParameterValueContainer from(ComponentParameterAst param) {
        Either value = param.getValue();
        if (value.isLeft()) {
            return new ParameterValueContainer(value.getLeft(), null);
        }
        if (value.getRight() instanceof ComponentAst) {
            return new ParameterValueContainer(null, this.astDTOFactoryProvider.getComponentAstDTOFactory().from((ComponentAst)param.getValue().getRight()));
        }
        if (value.getRight() instanceof List) {
            List right = (List)value.getRight();
            if (right.isEmpty()) {
                return new ParameterValueContainer(null, value.getRight());
            }
            Object o = right.get(0);
            if (o instanceof ComponentAst) {
                return new ParameterValueContainer(null, ((List)param.getValue().getRight()).stream().map(componentAstItem -> this.astDTOFactoryProvider.getComponentAstDTOFactory().from((ComponentAst)componentAstItem)).collect(Collectors.toList()));
            }
            if (o instanceof ErrorMapping) {
                return new ParameterValueContainer(null, param.getValue().getRight());
            }
            return new ParameterValueContainer(null, value.getRight());
        }
        if (value.getRight() instanceof LinkedTreeMap) {
            LinkedTreeMap right = (LinkedTreeMap)param.getValue().getRight();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (String key : right.keySet()) {
                hashMap.put(key, right.get((Object)key));
            }
            return new ParameterValueContainer(null, hashMap);
        }
        return new ParameterValueContainer(null, value.getRight());
    }
}

