/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.input.BoundedInputStream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.serialization.ExtensionModelResolver;
import org.mule.runtime.ast.internal.serialization.InternalArtifactAstDeserializer;
import org.mule.runtime.ast.internal.serialization.dto.ArtifactAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParserAttributesDTO;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentIdentifierJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ComponentLocationJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ErrorTypeJsonDeserializer;
import org.mule.runtime.ast.internal.serialization.json.gson.ParserAttributesJsonTypeAdapter;
import org.mule.runtime.ast.internal.serialization.json.gson.PostProcessingEnabler;
import org.mule.runtime.ast.internal.serialization.resolver.DefaultGenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.GenerationInformationResolver;
import org.mule.runtime.ast.internal.serialization.resolver.NoOpGenerationInformationResolver;

public class JsonArtifactAstDeserializer
implements InternalArtifactAstDeserializer {
    private static final long MAX_BYTE_COUNT = 0xA00000L;
    public static final String V_1_0 = "1.0";
    private final Map<String, Gson> versionToGson = new HashMap<String, Gson>();
    private final GenerationInformationResolver generationInformationResolver;

    public JsonArtifactAstDeserializer(GsonBuilder gsonBuilder, boolean populateGenerationInformation) {
        gsonBuilder.registerTypeAdapter(ComponentIdentifier.class, (Object)new ComponentIdentifierJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ComponentLocation.class, (Object)new ComponentLocationJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ErrorType.class, (Object)new ErrorTypeJsonDeserializer());
        gsonBuilder.registerTypeAdapter(ParserAttributesDTO.class, (Object)new ParserAttributesJsonTypeAdapter());
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new PostProcessingEnabler());
        this.versionToGson.put(V_1_0, gsonBuilder.create());
        this.generationInformationResolver = populateGenerationInformation ? new DefaultGenerationInformationResolver() : new NoOpGenerationInformationResolver();
    }

    @Override
    public String getLatestVersion() {
        return V_1_0;
    }

    @Override
    public ArtifactAst deserialize(InputStream artifactAstInputStream, String version, Charset charset, ExtensionModelResolver extensionModelResolver, ArtifactAst parent) throws IllegalArgumentException, IOException {
        BoundedInputStream boundedInputStream = new BoundedInputStream(artifactAstInputStream, 0xA00000L);
        ArtifactAstDTO artifactAstDTO = (ArtifactAstDTO)this.versionToGson.get(version).fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)boundedInputStream, charset)), ArtifactAstDTO.class);
        artifactAstDTO.setParent(parent);
        artifactAstDTO.enrich(extensionModelResolver, this.generationInformationResolver);
        return artifactAstDTO;
    }
}

