/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.api.ioc.ObjectProvider;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.notification.ConnectionNotification;
import org.mule.runtime.api.notification.ConnectionNotificationListener;
import org.mule.runtime.api.notification.CustomNotification;
import org.mule.runtime.api.notification.CustomNotificationListener;
import org.mule.runtime.api.notification.ExceptionNotification;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.ExtensionNotification;
import org.mule.runtime.api.notification.ExtensionNotificationListener;
import org.mule.runtime.api.notification.ManagementNotification;
import org.mule.runtime.api.notification.ManagementNotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.notification.TransactionNotification;
import org.mule.runtime.api.notification.TransactionNotificationListener;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.bean.NotificationConfig;
import org.mule.runtime.config.internal.bean.ServerNotificationManagerConfigurator;
import org.mule.runtime.config.internal.context.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.ImmutableObjectProviderConfiguration;
import org.mule.runtime.config.internal.context.MuleArtifactObjectProvider;
import org.mule.runtime.config.internal.context.MuleContextPostProcessor;
import org.mule.runtime.config.internal.context.ObjectProviderAwareBeanFactory;
import org.mule.runtime.config.internal.context.SpringConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.SpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.internal.dsl.model.config.PropertiesResolverConfigurationProperties;
import org.mule.runtime.config.internal.dsl.spring.BeanDefinitionFactory;
import org.mule.runtime.config.internal.editors.MulePropertyEditorRegistrar;
import org.mule.runtime.config.internal.factories.MuleConfigurationConfigurator;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ApplicationModelAstPostProcessor;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.model.properties.PropertiesResolverUtils;
import org.mule.runtime.config.internal.parsers.generic.AutoIdUtils;
import org.mule.runtime.config.internal.processor.ComponentLocatorCreatePostProcessor;
import org.mule.runtime.config.internal.processor.DiscardedOptionalBeanPostProcessor;
import org.mule.runtime.config.internal.processor.LifecycleStatePostProcessor;
import org.mule.runtime.config.internal.processor.MuleInjectorProcessor;
import org.mule.runtime.config.internal.processor.PostRegistrationActionsPostProcessor;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.config.internal.util.LaxInstantiationStrategyWrapper;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.artifact.ArtifactCoordinates;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.context.notification.MuleContextNotification;
import org.mule.runtime.core.api.context.notification.MuleContextNotificationListener;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.transaction.TransactionManagerFactory;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.type.catalog.ApplicationTypeLoader;
import org.mule.runtime.core.api.util.boot.ExtensionLoaderUtils;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.el.function.MuleFunctionsBindingContextProvider;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.exception.ErrorTypeLocatorFactory;
import org.mule.runtime.core.internal.registry.DefaultRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistry;
import org.mule.runtime.core.internal.registry.MuleRegistryHelper;
import org.mule.runtime.core.internal.util.DefaultResourceLocator;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.loader.ExtensionModelLoadingRequest;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.module.extension.internal.manager.CompositeArtifactExtensionManager;
import org.mule.runtime.module.extension.internal.manager.ExtensionErrorsRegistrant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.RequiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.context.support.AbstractRefreshableConfigApplicationContext;

public class MuleArtifactContext
extends AbstractRefreshableConfigApplicationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleArtifactContext.class);
    public static final String INNER_BEAN_PREFIX = "(inner bean)";
    private final OptionalObjectsController optionalObjectsController;
    private final DefaultRegistry serviceDiscoverer;
    private final DefaultResourceLocator resourceLocator;
    private final PropertiesResolverConfigurationProperties configurationProperties;
    protected final MemoryManagementService memoryManagementService;
    private ArtifactAst applicationModel;
    private final MuleContextWithRegistry muleContext;
    private final MuleFunctionsBindingContextProvider coreFunctionsProvider;
    private final BeanDefinitionFactory beanDefinitionFactory;
    private final ArtifactType artifactType;
    private final BaseConfigurationComponentLocator baseComponentLocator;
    protected SpringConfigurationComponentLocator componentLocator;
    private final ContributedErrorTypeRepository errorTypeRepository;
    private final ContributedErrorTypeLocator errorTypeLocator;
    private final Map<String, String> artifactProperties;
    protected List<ConfigurableObjectProvider> objectProviders = new ArrayList<ConfigurableObjectProvider>();
    private final ExtensionManager extensionManager;

    public MuleArtifactContext(MuleContext muleContext, ArtifactAst artifactAst, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, Map<String, String> artifactProperties, ArtifactType artifactType, ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory, MemoryManagementService memoryManagementService, FeatureFlaggingService featureFlaggingService) {
        Preconditions.checkArgument(optionalObjectsController != null, "optionalObjectsController cannot be null");
        this.muleContext = (MuleContextWithRegistry)muleContext;
        this.coreFunctionsProvider = (MuleFunctionsBindingContextProvider)this.muleContext.getRegistry().get("core.global.binding.provider");
        this.optionalObjectsController = optionalObjectsController;
        this.artifactType = artifactType;
        this.serviceDiscoverer = new DefaultRegistry(muleContext);
        this.resourceLocator = new DefaultResourceLocator();
        this.baseComponentLocator = baseConfigurationComponentLocator;
        this.errorTypeRepository = errorTypeRepository;
        this.errorTypeLocator = errorTypeLocator;
        this.artifactProperties = artifactProperties;
        this.memoryManagementService = memoryManagementService;
        this.extensionManager = muleContext.getExtensionManager();
        this.componentLocator = new SpringConfigurationComponentLocator(componentName -> {
            try {
                BeanDefinition beanDefinition = this.getBeanFactory().getBeanDefinition(componentName);
                return beanDefinition.isPrototype();
            }
            catch (NoSuchBeanDefinitionException e) {
                return false;
            }
        });
        this.beanDefinitionFactory = new BeanDefinitionFactory(muleContext.getConfiguration().getId(), componentBuildingDefinitionRegistryFactory.create(artifactAst.dependencies()), featureFlaggingService.isEnabled(MuleRuntimeFeature.DISABLE_ATTRIBUTE_PARAMETER_WHITESPACE_TRIMMING), featureFlaggingService.isEnabled(MuleRuntimeFeature.DISABLE_POJO_TEXT_CDATA_WHITESPACE_TRIMMING));
        this.applicationModel = artifactAst;
        this.configurationProperties = PropertiesResolverUtils.createConfigurationAttributeResolver(this.applicationModel, parentConfigurationProperties, artifactProperties, new ClassLoaderResourceProvider(muleContext.getExecutionClassLoader()), Optional.of(featureFlaggingService));
        try {
            LifecycleUtils.initialiseIfNeeded(this.configurationProperties.getConfigurationPropertiesResolver());
            this.applicationModel.updatePropertiesResolver(this.configurationProperties.getConfigurationPropertiesResolver());
            this.validateArtifact(this.applicationModel);
        }
        catch (InitialisationException | ConfigurationException e) {
            throw new MuleRuntimeException(e);
        }
        this.registerErrors(this.applicationModel);
        this.registerApplicationExtensionModel();
    }

    protected MuleRegistry getMuleRegistry() {
        return this.muleContext.getRegistry();
    }

    protected void validateArtifact(ArtifactAst artifactAst) throws ConfigurationException {
        this.doValidateModel(artifactAst, v -> true);
    }

    protected final void doValidateModel(ArtifactAst appModel, Predicate<Validation> validationsFilter) throws ConfigurationException {
        ValidationResult validation = MuleAstUtils.validatorBuilder().withValidationEnricher(v -> {
            try {
                this.muleContext.getInjector().inject(v);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
        }).withValidationsFilter(validationsFilter).withArtifactRegionClassLoader(this.getRegionClassLoader()).build().validate(appModel);
        Collection<ValidationResultItem> items = validation.getItems();
        items.stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.WARN)).forEach(v -> LOGGER.warn(this.componentsLocation((ValidationResultItem)v)));
        List errors = items.stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage(validation.getItems().stream().map(this::componentsLocation).collect(Collectors.joining(System.lineSeparator()))));
        }
    }

    private ClassLoader getRegionClassLoader() {
        return this.muleContext.getExecutionClassLoader().getParent();
    }

    private String componentsLocation(ValidationResultItem v) {
        return v.getComponents().stream().map(component -> component.getMetadata().getFileName().orElse("unknown") + ":" + component.getMetadata().getStartLine().orElse(-1)).collect(Collectors.joining("; ", "[", "]")) + ": " + v.getMessage();
    }

    protected void registerApplicationExtensionModel() {
        if (!this.artifactType.equals((Object)ArtifactType.APP)) {
            return;
        }
        Optional<ArtifactCoordinates> artifactCoordinates = this.muleContext.getConfiguration().getArtifactCoordinates();
        if (!artifactCoordinates.isPresent()) {
            this.logModelNotGenerated("No version specified on muleContext");
            return;
        }
        Optional<ExtensionModelLoader> loader = this.getMuleExtensionLoader();
        if (!loader.isPresent()) {
            this.logModelNotGenerated("Mule ExtensionModelLoader not found");
            return;
        }
        ExtensionModel appExtensionModel = loader.get().loadExtensionModel(ExtensionModelLoadingRequest.builder(this.getRegionClassLoader(), DslResolvingContext.getDefault(this.extensionManager.getExtensions())).addParameter("version", artifactCoordinates.get().getVersion()).addParameter("muleSDK.artifactAst", this.applicationModel).addParameter("muleSDK.artifactDescriptor", this.muleContext.getConfiguration().getId()).addParameter("muleSDK.typeLoader", new ApplicationTypeLoader()).build());
        ExtensionManager appManager = this.extensionManager instanceof CompositeArtifactExtensionManager ? ((CompositeArtifactExtensionManager)this.extensionManager).getChildExtensionManager() : this.extensionManager;
        appManager.registerExtension(appExtensionModel);
    }

    private void logModelNotGenerated(String reason) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn(reason + ". ExtensionModel for app {} not generated", (Object)this.muleContext.getConfiguration().getId());
        }
    }

    private Optional<ExtensionModelLoader> getMuleExtensionLoader() {
        return ExtensionLoaderUtils.getOptionalLoaderById(((Object)((Object)this)).getClass().getClassLoader(), "mule");
    }

    protected void registerErrors(ArtifactAst artifactAst) {
        this.doRegisterErrors(artifactAst);
    }

    protected void doRegisterErrors(ArtifactAst artifactAst) {
        ErrorTypeRepository errorTypeRepository = artifactAst.getErrorTypeRepository();
        ErrorTypeLocator errorTypeLocator = ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(errorTypeRepository);
        Set<ExtensionModel> dependencies = artifactAst.dependencies();
        ExtensionErrorsRegistrant.registerErrorMappings(errorTypeRepository, errorTypeLocator, dependencies);
        this.errorTypeRepository.setDelegate(errorTypeRepository);
        this.errorTypeLocator.setDelegate(errorTypeLocator);
    }

    public void initialize() {
        this.applicationModel = ApplicationModel.prepareAstForRuntime(this.applicationModel, this.applicationModel.dependencies());
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        beanFactory.setBeanExpressionResolver(null);
        this.registerEditors(beanFactory);
        this.registerAnnotationConfigProcessors((BeanDefinitionRegistry)beanFactory, beanFactory);
        this.addBeanPostProcessors(beanFactory, new BeanPostProcessor[]{new MuleContextPostProcessor(this.muleContext), new PostRegistrationActionsPostProcessor((MuleRegistryHelper)this.muleContext.getRegistry(), beanFactory), new DiscardedOptionalBeanPostProcessor(this.optionalObjectsController, (DefaultListableBeanFactory)beanFactory), new LifecycleStatePostProcessor(this.muleContext.getLifecycleManager().getState()), new ComponentLocatorCreatePostProcessor(this.componentLocator)});
        beanFactory.registerSingleton("_muleContext", (Object)this.muleContext);
        this.prepareObjectProviders();
    }

    protected void prepareObjectProviders() {
        MuleArtifactObjectProvider muleArtifactObjectProvider = new MuleArtifactObjectProvider(this);
        ImmutableObjectProviderConfiguration providerConfiguration = new ImmutableObjectProviderConfiguration(this.configurationProperties, muleArtifactObjectProvider);
        for (ConfigurableObjectProvider objectProvider : this.objectProviders) {
            objectProvider.configure(providerConfiguration);
        }
    }

    protected void registerObjectFromObjectProviders(ConfigurableListableBeanFactory beanFactory) {
        ((ObjectProviderAwareBeanFactory)beanFactory).setObjectProviders(this.objectProviders);
    }

    private List<Pair<ComponentAst, Optional<String>>> lookObjectProvidersComponentModels(ArtifactAst applicationModel, Map<ComponentAst, SpringComponentModel> springComponentModels) {
        return applicationModel.topLevelComponentsStream().filter(componentModel -> {
            SpringComponentModel springModel = (SpringComponentModel)springComponentModels.get(componentModel);
            return springModel != null && springModel.getType() != null && ConfigurableObjectProvider.class.isAssignableFrom(springModel.getType());
        }).map(componentModel -> new Pair<ComponentAst, Optional<String>>((ComponentAst)componentModel, componentModel.getComponentId())).collect(Collectors.toList());
    }

    private void registerEditors(ConfigurableListableBeanFactory beanFactory) {
        MulePropertyEditorRegistrar registrar = new MulePropertyEditorRegistrar();
        registrar.setMuleContext(this.muleContext);
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)registrar);
    }

    protected void addBeanPostProcessors(ConfigurableListableBeanFactory beanFactory, BeanPostProcessor ... processors) {
        for (BeanPostProcessor processor : processors) {
            beanFactory.addBeanPostProcessor(processor);
        }
    }

    public void close() {
        if (this.isRunning()) {
            super.close();
            LifecycleUtils.disposeIfNeeded(this.configurationProperties.getConfigurationPropertiesResolver(), LOGGER);
        }
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        this.createApplicationComponents(beanFactory, this.applicationModel, true);
    }

    public void destroy() {
        try {
            super.destroy();
        }
        catch (Exception e) {
            for (ObjectProvider objectProvider : this.objectProviders) {
                LifecycleUtils.disposeIfNeeded(objectProvider, LOGGER);
            }
            throw new MuleRuntimeException(e);
        }
    }

    protected List<Pair<String, ComponentAst>> createApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst applicationModel, boolean mustBeRoot) {
        LinkedHashMap<ComponentAst, SpringComponentModel> springComponentModels = new LinkedHashMap<ComponentAst, SpringComponentModel>();
        return this.doCreateApplicationComponents(beanFactory, applicationModel, mustBeRoot, springComponentModels);
    }

    protected List<Pair<String, ComponentAst>> doCreateApplicationComponents(DefaultListableBeanFactory beanFactory, ArtifactAst applicationModel, boolean mustBeRoot, Map<ComponentAst, SpringComponentModel> springComponentModels) {
        HashSet alwaysEnabledTopLevelComponents = new HashSet();
        Set alwaysEnabledUnnamedTopLevelComponents = applicationModel.topLevelComponentsStream().filter(cm -> cm.getModel(HasStereotypeModel.class).map(stm -> stm.getStereotype().isAssignableTo(MuleStereotypes.APP_CONFIG)).orElse(false)).peek(cm -> cm.getComponentId().ifPresent(alwaysEnabledTopLevelComponents::add)).filter(cm -> !cm.getComponentId().isPresent()).map(ComponentAst::getIdentifier).collect(Collectors.toSet());
        HashSet alwaysEnabledGeneratedTopLevelComponentsName = new HashSet();
        ArrayList<Pair<String, ComponentAst>> createdComponentModels = new ArrayList<Pair<String, ComponentAst>>();
        Set<ComponentAst> rootComponents = this.resolveRootComponents(applicationModel);
        MuleAstUtils.recursiveStreamWithHierarchy(applicationModel, AstTraversalDirection.BOTTOM_UP, true).filter(cm -> {
            if (!mustBeRoot) return true;
            if (rootComponents.contains(cm.getFirst())) return true;
            if (!((List)cm.getSecond()).stream().anyMatch(rootComponents::contains)) return false;
            return true;
        }).filter(cm -> !this.isIgnored((ComponentAst)cm.getFirst())).forEach(cm -> {
            if (rootComponents.contains(cm.getFirst())) {
                ((ComponentAst)cm.getFirst()).getComponentId().ifPresent(componentName -> createdComponentModels.add(new Pair((String)componentName, cm.getFirst())));
            }
            this.beanDefinitionFactory.resolveComponent(springComponentModels, (List)cm.getSecond(), (ComponentAst)cm.getFirst(), (BeanDefinitionRegistry)beanFactory, this.componentLocator);
            if (rootComponents.contains(cm.getFirst())) {
                this.componentLocator.addComponentLocation(((ComponentAst)cm.getFirst()).getLocation());
            }
        });
        springComponentModels.values().stream().filter(resolvedComponentModel -> rootComponents.contains(resolvedComponentModel.getComponent())).forEach(resolvedComponentModel -> this.registerRootSpringBean(beanFactory, alwaysEnabledUnnamedTopLevelComponents, alwaysEnabledGeneratedTopLevelComponentsName, (List<Pair<String, ComponentAst>>)createdComponentModels, (SpringComponentModel)resolvedComponentModel));
        List<Pair<ComponentAst, Optional<String>>> objectProvidersByName = this.lookObjectProvidersComponentModels(applicationModel, springComponentModels);
        objectProvidersByName.stream().map(pair -> ((SpringComponentModel)springComponentModels.get(pair.getFirst())).getObjectInstance()).forEach(this.objectProviders::add);
        this.registerObjectFromObjectProviders((ConfigurableListableBeanFactory)beanFactory);
        Set objectProviderNames = objectProvidersByName.stream().map(Pair::getSecond).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        createdComponentModels.sort(Comparator.comparing(beanNameAndComponent -> {
            String beanName = (String)beanNameAndComponent.getFirst();
            if (objectProviderNames.contains(beanName)) {
                return 1;
            }
            if (alwaysEnabledGeneratedTopLevelComponentsName.contains(beanName)) {
                return 2;
            }
            if (alwaysEnabledTopLevelComponents.contains(beanName)) {
                return 3;
            }
            return 4;
        }));
        return createdComponentModels;
    }

    protected Set<ComponentAst> resolveRootComponents(ArtifactAst applicationModel) {
        Set<ComponentAst> rootComponents = new HashSet<ComponentAst>(applicationModel.topLevelComponents());
        for (ApplicationModelAstPostProcessor astPostProcessor : ApplicationModelAstPostProcessor.AST_POST_PROCESSORS.get()) {
            rootComponents = astPostProcessor.resolveRootComponents(rootComponents, this.extensionManager.getExtensions());
        }
        return rootComponents;
    }

    protected boolean isIgnored(ComponentAst componentAst) {
        return this.beanDefinitionFactory.isComponentIgnored(componentAst.getIdentifier());
    }

    private void registerRootSpringBean(DefaultListableBeanFactory beanFactory, Set<ComponentIdentifier> alwaysEnabledUnnamedTopLevelComponents, Set<String> alwaysEnabledGeneratedTopLevelComponentsName, List<Pair<String, ComponentAst>> createdComponentModels, SpringComponentModel resolvedComponentModel) {
        String nameAttribute = resolvedComponentModel.getComponent().getComponentId().orElse(null);
        if (resolvedComponentModel.getComponent().getIdentifier().equals(CoreDslConstants.CONFIGURATION_IDENTIFIER)) {
            nameAttribute = "_muleConfiguration";
        } else if (nameAttribute == null) {
            nameAttribute = AutoIdUtils.uniqueValue(resolvedComponentModel.getBeanDefinition().getBeanClassName());
            if (alwaysEnabledUnnamedTopLevelComponents.contains(resolvedComponentModel.getComponent().getIdentifier())) {
                alwaysEnabledGeneratedTopLevelComponentsName.add(nameAttribute);
                createdComponentModels.add(new Pair<String, ComponentAst>(nameAttribute, resolvedComponentModel.getComponent()));
            } else if (resolvedComponentModel.getType() != null && TransactionManagerFactory.class.isAssignableFrom(resolvedComponentModel.getType())) {
                createdComponentModels.add(new Pair<String, ComponentAst>(nameAttribute, resolvedComponentModel.getComponent()));
            }
        }
        beanFactory.registerBeanDefinition(nameAttribute, Objects.requireNonNull(resolvedComponentModel.getBeanDefinition(), "BeanDefinition null for " + resolvedComponentModel.getComponent().toString()));
        MuleArtifactContext.postProcessBeanDefinition(resolvedComponentModel, (BeanDefinitionRegistry)beanFactory, nameAttribute);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        super.customizeBeanFactory(beanFactory);
        this.baseComponentLocator.setDelegate(this.componentLocator);
        this.createServiceConfigurator(beanFactory).createArtifactServices();
    }

    protected SpringMuleContextServiceConfigurator createServiceConfigurator(DefaultListableBeanFactory beanFactory) {
        return new SpringMuleContextServiceConfigurator(this.muleContext, this.getCoreFunctionsProvider(), this.getConfigurationProperties(), this.artifactProperties, this.getArtifactType(), this.getOptionalObjectsController(), (BeanDefinitionRegistry)beanFactory, this.getServiceDiscoverer(), this.getResourceLocator(), this.memoryManagementService);
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        BeanDefinitionRegistry beanDefinitionRegistry = (BeanDefinitionRegistry)beanFactory;
        if (!ApplicationModel.findComponentDefinitionModel(this.applicationModel, CoreDslConstants.CONFIGURATION_IDENTIFIER).isPresent()) {
            this.registerMuleConfigurationBean(beanDefinitionRegistry);
        }
        if (!ApplicationModel.findComponentDefinitionModel(this.applicationModel, CoreDslConstants.NOTIFICATIONS_IDENTIFIER).isPresent()) {
            this.registerNotificationManagerBean(beanDefinitionRegistry);
        }
    }

    private void registerNotificationManagerBean(BeanDefinitionRegistry beanDefinitionRegistry) {
        beanDefinitionRegistry.registerBeanDefinition("_muleNotificationManager", (BeanDefinition)AbstractSpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ServerNotificationManagerConfigurator.class).addPropertyValue("enabledNotifications", (Object)ImmutableList.builder().add(new NotificationConfig.EnabledNotificationConfig<MuleContextNotification, MuleContextNotificationListener>(MuleContextNotificationListener.class, MuleContextNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<SecurityNotification, SecurityNotificationListener>(SecurityNotificationListener.class, SecurityNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ManagementNotification, ManagementNotificationListener>(ManagementNotificationListener.class, ManagementNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ConnectionNotification, ConnectionNotificationListener>(ConnectionNotificationListener.class, ConnectionNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<CustomNotification, CustomNotificationListener>(CustomNotificationListener.class, CustomNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ExceptionNotification, ExceptionNotificationListener>(ExceptionNotificationListener.class, ExceptionNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<TransactionNotification, TransactionNotificationListener>(TransactionNotificationListener.class, TransactionNotification.class)).add(new NotificationConfig.EnabledNotificationConfig<ExtensionNotification, ExtensionNotificationListener>(ExtensionNotificationListener.class, ExtensionNotification.class)).build()).getBeanDefinition());
    }

    private void registerMuleConfigurationBean(BeanDefinitionRegistry beanDefinitionRegistry) {
        beanDefinitionRegistry.registerBeanDefinition("_muleConfiguration", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MuleConfigurationConfigurator.class).getBeanDefinition());
    }

    private void registerAnnotationConfigProcessors(BeanDefinitionRegistry registry, ConfigurableListableBeanFactory beanFactory) {
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalConfigurationAnnotationProcessor", ConfigurationClassPostProcessor.class, null);
        this.registerAnnotationConfigProcessor(registry, "org.springframework.context.annotation.internalRequiredAnnotationProcessor", RequiredAnnotationBeanPostProcessor.class, null);
        this.registerInjectorProcessor(beanFactory);
    }

    protected void registerInjectorProcessor(ConfigurableListableBeanFactory beanFactory) {
        MuleInjectorProcessor muleInjectorProcessor = null;
        if (this.artifactType.equals((Object)ArtifactType.APP) || this.artifactType.equals((Object)ArtifactType.POLICY) || this.artifactType.equals((Object)ArtifactType.DOMAIN)) {
            muleInjectorProcessor = new MuleInjectorProcessor();
        }
        if (muleInjectorProcessor != null) {
            muleInjectorProcessor.setBeanFactory((BeanFactory)beanFactory);
            beanFactory.addBeanPostProcessor((BeanPostProcessor)muleInjectorProcessor);
        }
    }

    private void registerAnnotationConfigProcessor(BeanDefinitionRegistry registry, String key, Class<?> type, Object source) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition(type);
        beanDefinition.setSource(source);
        this.registerPostProcessor(registry, beanDefinition, key);
    }

    protected void registerPostProcessor(BeanDefinitionRegistry registry, RootBeanDefinition definition, String beanName) {
        definition.setRole(2);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }

    protected DefaultListableBeanFactory createBeanFactory() {
        ObjectProviderAwareBeanFactory beanFactory = new ObjectProviderAwareBeanFactory(this.getInternalParentBeanFactory());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new ContextAnnotationAutowireCandidateResolver());
        beanFactory.setInstantiationStrategy(new LaxInstantiationStrategyWrapper((InstantiationStrategy)new CglibSubclassingInstantiationStrategy(), this.optionalObjectsController));
        return beanFactory;
    }

    public boolean isRunning() {
        try {
            return super.isRunning();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected static void postProcessBeanDefinition(SpringComponentModel resolvedComponent, BeanDefinitionRegistry registry, String beanName) {
        if (Converter.class.isAssignableFrom(resolvedComponent.getType())) {
            GenericBeanDefinition converterBeanDefinitionCopy = new GenericBeanDefinition(resolvedComponent.getBeanDefinition());
            converterBeanDefinitionCopy.setScope("singleton");
            registry.registerBeanDefinition(beanName + "-converter", (BeanDefinition)converterBeanDefinitionCopy);
        }
    }

    public MuleContextWithRegistry getMuleContext() {
        return this.muleContext;
    }

    protected MuleFunctionsBindingContextProvider getCoreFunctionsProvider() {
        return this.coreFunctionsProvider;
    }

    protected PropertiesResolverConfigurationProperties getConfigurationProperties() {
        return this.configurationProperties;
    }

    protected ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public OptionalObjectsController getOptionalObjectsController() {
        return this.optionalObjectsController;
    }

    public Registry getRegistry() {
        return (Registry)this.getMuleContext().getRegistry().get("_muleRegistry");
    }

    public String toString() {
        return String.format("%s: %s (%s)", ((Object)((Object)this)).getClass().getName(), this.muleContext.getConfiguration().getId(), this.artifactType.name());
    }

    private Set<ExtensionModel> getExtensions() {
        return this.extensionManager == null ? Collections.emptySet() : this.extensionManager.getExtensions();
    }

    public ArtifactAst getApplicationModel() {
        return this.applicationModel;
    }

    protected DefaultRegistry getServiceDiscoverer() {
        return this.serviceDiscoverer;
    }

    protected DefaultResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }
}

