/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.internal.dsl.DslConstants;

public class ParseTemplateResourceExist
implements Validation {
    private static final String PARSE_TEMPLATE_ELEMENT_NAME = "parse-template";
    private static final String LOCATION_PARAM = "location";
    private static final ComponentIdentifier PARSE_TEMPLATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").namespaceUri(DslConstants.CORE_NAMESPACE).name("parse-template").build();
    private final ClassLoader artifactRegionClassLoader;

    public ParseTemplateResourceExist(ClassLoader artifactRegionClassLoader) {
        this.artifactRegionClassLoader = artifactRegionClassLoader;
    }

    @Override
    public String getName() {
        return "'parse-template' resources exist";
    }

    @Override
    public String getDescription() {
        return "Template file referenced in 'parse-template' exists and is accessible.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> comp.getIdentifier().equals(PARSE_TEMPLATE_IDENTIFIER) && comp.getParameter("General", LOCATION_PARAM).getValue().getRight() != null);
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst locationParam = component.getParameter("General", LOCATION_PARAM);
        String location = (String)locationParam.getValue().getRight();
        if (this.artifactRegionClassLoader.getResource(location) == null) {
            return Optional.of(ValidationResultItem.create(component, locationParam, (Validation)this, "Template location: '" + location + "' not found"));
        }
        return Optional.empty();
    }
}

