/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.config.internal.error.MuleCoreErrorTypeRepository;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;

public class OnErrorPropagateHandler
extends TemplateOnErrorHandler {
    private final SingleErrorTypeMatcher redeliveryExhaustedMatcher;

    public OnErrorPropagateHandler() {
        ErrorType redeliveryExhaustedErrorType = MuleCoreErrorTypeRepository.MULE_CORE_ERROR_TYPE_REPOSITORY.getErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).orElseThrow(() -> new IllegalStateException("REDELIVERY_EXHAUSTED error type not found"));
        this.redeliveryExhaustedMatcher = new SingleErrorTypeMatcher(redeliveryExhaustedErrorType);
    }

    @Override
    public boolean acceptsAll() {
        return this.errorTypeMatcher == null && !this.when.isPresent();
    }

    boolean acceptsErrorType(ErrorType errorType) {
        return this.acceptsAll() || this.errorTypeMatcher != null && this.errorTypeMatcher.match(errorType);
    }

    @Override
    protected Function<CoreEvent, CoreEvent> beforeRouting() {
        return event -> {
            Exception exception = this.getException((CoreEvent)event);
            event = super.beforeRouting().apply((CoreEvent)event);
            if (!this.isRedeliveryExhausted(exception) && this.isOwnedTransaction()) {
                this.rollback(exception);
            }
            return event;
        };
    }

    public void rollback(Exception ex) {
        TransactionCoordination.getInstance().rollbackCurrentTransaction();
    }

    @Override
    public TemplateOnErrorHandler duplicateFor(Location buildFor) {
        OnErrorPropagateHandler cpy = new OnErrorPropagateHandler();
        cpy.setFlowLocation(buildFor);
        this.when.ifPresent(expr -> cpy.setWhen((String)expr));
        cpy.setHandleException(this.handleException);
        cpy.setErrorType(this.errorType);
        cpy.setMessageProcessors(this.getMessageProcessors());
        cpy.setExceptionListener(this.getExceptionListener());
        cpy.setAnnotations(this.getAnnotations());
        return cpy;
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return new ArrayList<Processor>(super.getOwnedMessageProcessors());
    }

    private boolean isRedeliveryExhausted(Exception exception) {
        if (exception instanceof MessagingException) {
            Optional<Error> error = ((MessagingException)exception).getEvent().getError();
            return error.map(e -> this.redeliveryExhaustedMatcher.match(e.getErrorType())).orElse(false);
        }
        return false;
    }
}

