/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.processor.HasParamsAsTemplateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerMessageProcessor
extends AbstractComponent
implements HasParamsAsTemplateProcessor,
Processor,
Initialisable,
MuleContextAware {
    private static final String BLOCKING_CATEGORIES_PROPERTY = System.getProperty("mule.logging.blockingCategories", "");
    private static final Set<String> BLOCKING_CATEGORIES = new HashSet<String>(Arrays.asList(BLOCKING_CATEGORIES_PROPERTY.split(",")));
    private static final String WILDCARD = "*";
    protected transient Logger logger;
    protected String message;
    protected String category;
    protected String level = "INFO";
    protected MuleContext muleContext;
    ExtendedExpressionManager expressionManager;
    private volatile ReactiveProcessor.ProcessingType processingType;

    @Override
    public void initialise() throws InitialisationException {
        this.initLogger();
        this.initProcessingTypeIfPossible();
        this.expressionManager = this.muleContext.getExpressionManager();
    }

    protected void initLogger() {
        this.logger = this.category != null ? LoggerFactory.getLogger((String)this.category) : LoggerFactory.getLogger(LoggerMessageProcessor.class);
    }

    protected void initProcessingTypeIfPossible() {
        if (this.getBlockingCategories().size() == 1 && this.getBlockingCategories().contains("")) {
            this.processingType = ReactiveProcessor.ProcessingType.CPU_LITE;
        } else if (this.getBlockingCategories().contains(WILDCARD)) {
            this.processingType = ReactiveProcessor.ProcessingType.BLOCKING;
        }
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        this.log(event);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        if (this.processingType == null) {
            LoggerMessageProcessor loggerMessageProcessor = this;
            synchronized (loggerMessageProcessor) {
                if (this.processingType == null) {
                    this.processingType = this.isBlocking(this.category) ? ReactiveProcessor.ProcessingType.BLOCKING : ReactiveProcessor.ProcessingType.CPU_LITE;
                }
            }
        }
        return this.processingType;
    }

    private boolean isBlocking(String category) {
        return this.getBlockingCategories().stream().anyMatch(blockingCategory -> blockingCategory.equals(category) || category != null && category.startsWith(blockingCategory + "."));
    }

    protected void log(CoreEvent event) {
        if (event == null) {
            this.logWithLevel(null);
        } else if (StringUtils.isEmpty(this.message)) {
            this.logWithLevel(event.getMessage());
        } else {
            LogLevel logLevel = LogLevel.valueOf(this.level);
            if (LogLevel.valueOf(this.level).isEnabled(this.logger)) {
                logLevel.log(this.logger, this.expressionManager.parseLogTemplate(this.message, event, this.getLocation(), BindingContextUtils.NULL_BINDING_CONTEXT));
            }
        }
    }

    protected void logWithLevel(Object object) {
        LogLevel logLevel = LogLevel.valueOf(this.level);
        if (logLevel.isEnabled(this.logger)) {
            logLevel.log(this.logger, object);
        }
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setLevel(String level) {
        this.level = level.toUpperCase();
    }

    protected Set<String> getBlockingCategories() {
        return BLOCKING_CATEGORIES;
    }

    public static enum LogLevel {
        ERROR{

            @Override
            public void log(Logger logger, Object object) {
                logger.error(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isErrorEnabled();
            }
        }
        ,
        WARN{

            @Override
            public void log(Logger logger, Object object) {
                logger.warn(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isWarnEnabled();
            }
        }
        ,
        INFO{

            @Override
            public void log(Logger logger, Object object) {
                logger.info(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isInfoEnabled();
            }
        }
        ,
        DEBUG{

            @Override
            public void log(Logger logger, Object object) {
                logger.debug(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isDebugEnabled();
            }
        }
        ,
        TRACE{

            @Override
            public void log(Logger logger, Object object) {
                logger.trace(object == null ? null : object.toString());
            }

            @Override
            public boolean isEnabled(Logger logger) {
                return logger.isTraceEnabled();
            }
        };


        public abstract void log(Logger var1, Object var2);

        public abstract boolean isEnabled(Logger var1);
    }
}

