/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.TaskSchedulingProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

@RuntimeInternalProfilingDataConsumer
public class TaskSchedulingProfilingDataProducer
implements ResettableProfilingDataProducer<TaskSchedulingProfilingEventContext, CoreEvent> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<TaskSchedulingProfilingEventContext> profilingEventType;
    private final ProfilingDataProducerStatus profilingProducerStatus;

    public TaskSchedulingProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<TaskSchedulingProfilingEventContext> profilingEventType, ProfilingProducerScope profilingProducerScope, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerScope);
    }

    @Override
    public void triggerProfilingEvent(TaskSchedulingProfilingEventContext profilerEventContext) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(profilerEventContext, this.profilingEventType);
        }
    }

    @Override
    public void triggerProfilingEvent(CoreEvent sourceData, Function<CoreEvent, TaskSchedulingProfilingEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent((ProfilingEventContext)transformation.apply(sourceData), this.profilingEventType);
        }
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }
}

