/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.retry.policies;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.util.rx.ConditionalExecutorServiceDecorator;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.retry.BackoffDelay;
import reactor.retry.Retry;
import reactor.retry.RetryExhaustedException;

public class SimpleRetryPolicy
implements org.mule.runtime.core.api.retry.policy.RetryPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRetryPolicy.class);
    protected RetryCounter retryCounter;
    private final int count;
    private final Duration frequency;

    public SimpleRetryPolicy(long frequency, int retryCount) {
        this.frequency = Duration.ofMillis(frequency);
        this.count = retryCount;
        this.retryCounter = new RetryCounter();
    }

    @Override
    public <T> CompletableFuture<T> applyPolicy(Supplier<CompletableFuture<T>> futureSupplier, Predicate<Throwable> shouldRetry, Consumer<Throwable> onRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction, org.mule.runtime.api.scheduler.Scheduler retryScheduler) {
        RetryPolicy actingPolicy = ((RetryPolicy)new RetryPolicy().handleIf(shouldRetry)).withMaxRetries(this.count != -1 ? this.count : -1).withDelay(this.frequency.isZero() ? Duration.ofMillis(1L) : this.frequency).onRetry(listener -> {
            this.logRetrying(listener.getAttemptCount());
            onRetry.accept(listener.getLastFailure());
        }).onRetriesExceeded(listener -> {
            this.logRetriesExhausted();
            Throwable t = (Throwable)errorFunction.apply(listener.getFailure());
            onExhausted.accept(t);
        });
        IsFirst first = new IsFirst();
        LazyValue<Supplier<Boolean>> isTransactional = new LazyValue<Supplier<Boolean>>(TransactionCoordination::isTransactionActive);
        return Failsafe.with((Policy[])new RetryPolicy[]{actingPolicy}).with((ScheduledExecutorService)new ConditionalExecutorServiceDecorator(retryScheduler, s -> first.isFirst() || (Boolean)isTransactional.get() != false)).getStageAsync(futureSupplier::get);
    }

    @Override
    public <T> Publisher<T> applyPolicy(Publisher<T> publisher, Predicate<Throwable> shouldRetry, Consumer<Throwable> onExhausted, Function<Throwable, Throwable> errorFunction, org.mule.runtime.api.scheduler.Scheduler retryScheduler) {
        return Mono.from(publisher).onErrorResume(e -> {
            if (shouldRetry.test((Throwable)e)) {
                Retry retry = Retry.onlyIf(ctx -> shouldRetry.test(Exceptions.unwrap(ctx.exception()))).backoff(ctx -> new BackoffDelay(this.frequency));
                if (this.count != -1) {
                    retry = retry.retryMax((long)(this.count - 1));
                }
                LazyValue<Supplier<Boolean>> isTransanctional = new LazyValue<Supplier<Boolean>>(TransactionCoordination::isTransactionActive);
                Scheduler reactorRetryScheduler = Schedulers.fromExecutorService((ExecutorService)new ConditionalExecutorServiceDecorator(retryScheduler, s -> (Boolean)isTransanctional.get()));
                Mono retryMono = Mono.from((Publisher)publisher).retryWhen((Function)retry.withBackoffScheduler(reactorRetryScheduler).doOnRetry(retryContext -> this.logRetrying(retryContext.iteration()))).doOnError(e2 -> {
                    this.logRetriesExhausted();
                    onExhausted.accept(Exceptions.unwrap(e2));
                }).onErrorMap(RetryExhaustedException.class, e2 -> (Throwable)errorFunction.apply(Exceptions.unwrap(e2.getCause())));
                return Mono.delay((Duration)this.frequency, (Scheduler)reactorRetryScheduler).then(TransactionCoordination.isTransactionActive() ? Mono.just((Object)retryMono.block()) : retryMono);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not retrying execution of event. Failing...");
            }
            e = Exceptions.unwrap(e);
            onExhausted.accept((Throwable)e);
            return Mono.error((Throwable)((Throwable)errorFunction.apply((Throwable)e)));
        });
    }

    @Override
    public PolicyStatus applyPolicy(Throwable cause) {
        if (this.isExhausted() || !this.isApplicableTo(cause)) {
            return PolicyStatus.policyExhausted(cause);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Waiting for {} ms before reconnecting. Failed attempt {} of {}", new Object[]{this.frequency.toMillis(), this.retryCounter.current().get() + 1, this.count != -1 ? String.valueOf(this.count) : "unlimited"});
        }
        try {
            this.retryCounter.current().getAndIncrement();
            Thread.sleep(this.frequency.toMillis());
            return PolicyStatus.policyOk();
        }
        catch (InterruptedException e) {
            return PolicyStatus.policyExhausted(e);
        }
    }

    protected boolean isApplicableTo(Throwable cause) {
        return true;
    }

    protected boolean isExhausted() {
        return this.count != -1 && this.retryCounter.current().get() >= this.count;
    }

    private void logRetrying(long attempts) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrying execution of event, attempt {} of {}.", (Object)attempts, (Object)(this.count != -1 ? String.valueOf(this.count) : "unlimited"));
        }
    }

    private void logRetriesExhausted() {
        LOGGER.debug("Retry attempts exhausted. Failing...");
    }

    protected static class RetryCounter
    extends ThreadLocal<AtomicInteger> {
        protected RetryCounter() {
        }

        public void reset() {
            ((AtomicInteger)this.get()).set(0);
        }

        public AtomicInteger current() {
            return (AtomicInteger)this.get();
        }

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    }

    private static class IsFirst {
        private boolean first = true;

        private IsFirst() {
        }

        public boolean isFirst() {
            if (this.first) {
                this.first = false;
                return true;
            }
            return false;
        }
    }
}

