/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.application;

import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.builder.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.api.builder.RegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

public class DefaultApplicationClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<DefaultApplicationClassLoaderBuilder>
implements ApplicationClassLoaderBuilder {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactClassLoader domainArtifactClassLoader;

    public DefaultApplicationClassLoaderBuilder(DeployableArtifactClassLoaderFactory<ApplicationDescriptor> artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    public MuleDeployableArtifactClassLoader build() {
        Preconditions.checkState(this.domainArtifactClassLoader != null, "Domain cannot be null");
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return DefaultApplicationClassLoaderBuilder.getApplicationId(this.domainArtifactClassLoader.getArtifactId(), artifactDescriptor.getName());
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.domainArtifactClassLoader;
    }

    @Override
    public DefaultApplicationClassLoaderBuilder setDomainParentClassLoader(ArtifactClassLoader domainArtifactClassLoader) {
        this.domainArtifactClassLoader = domainArtifactClassLoader;
        return this;
    }

    public static String getApplicationId(String domainId, String applicationId) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)domainId), "domainId cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)applicationId), "applicationName cannot be empty");
        return domainId + "/app/" + applicationId;
    }

    @Override
    protected ClassLoaderLookupPolicy getParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        SmallMap<String, LookupStrategy> lookupStrategies = new SmallMap<String, LookupStrategy>();
        Object descriptor = parentClassLoader.getArtifactDescriptor();
        ((ArtifactDescriptor)descriptor).getClassLoaderModel().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
        if (descriptor instanceof DeployableArtifactDescriptor) {
            for (ArtifactPluginDescriptor artifactPluginDescriptor : ((DeployableArtifactDescriptor)descriptor).getPlugins()) {
                artifactPluginDescriptor.getClassLoaderModel().getExportedPackages().forEach(p -> lookupStrategies.put((String)p, ParentFirstLookupStrategy.PARENT_FIRST));
            }
        }
        return parentClassLoader.getClassLoaderLookupPolicy().extend(lookupStrategies);
    }
}

