/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.domain;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleSharedDomainClassLoader
extends MuleDeployableArtifactClassLoader
implements ArtifactClassLoader {
    private static final Logger LOGGER;
    private final NativeLibraryFinder nativeLibraryFinder;

    public MuleSharedDomainClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<URL> urls, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        this(artifactDescriptor, parent, lookupPolicy, urls, artifactPluginClassLoaders, null);
    }

    public MuleSharedDomainClassLoader(ArtifactDescriptor artifactDescriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<URL> urls, List<ArtifactClassLoader> artifactPluginClassLoaders, NativeLibraryFinder nativeLibraryFinder) {
        super(DomainClassLoaderFactory.getDomainId(artifactDescriptor.getName()), artifactDescriptor, urls.toArray(new URL[0]), parent, lookupPolicy, artifactPluginClassLoaders);
        this.nativeLibraryFinder = nativeLibraryFinder;
    }

    @Override
    protected String findLibrary(String name) {
        if (this.nativeLibraryFinder == null) {
            return super.findLibrary(name);
        }
        String libraryPath = super.findLibrary(name);
        libraryPath = this.nativeLibraryFinder.findLibrary(name, libraryPath);
        return libraryPath;
    }

    @Override
    public URL findResource(String name) {
        File file;
        URL resource = super.findResource(name);
        if (resource == null && (file = new File(MuleFoldersUtil.getDomainFolder(((ArtifactDescriptor)this.getArtifactDescriptor()).getName()) + File.separator + name)).exists()) {
            try {
                resource = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.debug("Failure looking for resource", (Throwable)e);
            }
        }
        return resource;
    }

    @Override
    protected String[] getLocalResourceLocations() {
        return new String[]{MuleFoldersUtil.getDomainFolder(((ArtifactDescriptor)this.getArtifactDescriptor()).getName()).getAbsolutePath()};
    }

    static {
        MuleSharedDomainClassLoader.registerAsParallelCapable();
        LOGGER = LoggerFactory.getLogger(MuleSharedDomainClassLoader.class);
    }
}

