/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.Set;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.util.ExtensionErrorUtils;
import org.mule.runtime.extension.internal.util.ExtensionNamespaceUtils;
import org.mule.sdk.api.stereotype.MuleStereotypes;

public class ExtensionsErrorsDeclarationEnricher
implements DeclarationEnricher {
    private static final String CORE_NAMESPACE_NAME = "mule".toUpperCase();
    private static final String CONNECTIVITY_ERROR_TYPE = "CONNECTIVITY";
    private static final String RETRY_EXHAUSTED_ERROR_TYPE = "RETRY_EXHAUSTED";
    private static String ERROR_MASK = "Trying to add the '%s' Error to the Component '%s' but the Extension doesn't declare it";

    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate(extensionLoadingContext).enrich();
    }

    private void addErrorModel(OperationDeclaration declaration, ErrorModel errorModel, String type) {
        if (errorModel == null) {
            throw new IllegalModelDefinitionException(String.format(ERROR_MASK, type, declaration.getName()));
        }
        declaration.getErrorModels().add(errorModel);
    }

    private ErrorModel getErrorModel(String type, Set<ErrorModel> errors) {
        return errors.stream().filter(e -> !e.getNamespace().equals(CORE_NAMESPACE_NAME) && e.getType().equals(type)).findFirst().orElse(null);
    }

    private class EnricherDelegate {
        private final ExtensionDeclaration extensionDeclaration;
        private final Set<ErrorModel> errorModels;
        private final ErrorModel connectivityError;
        private final ErrorModel retryErrorModel;
        private ErrorModel validationErrorModel;

        public EnricherDelegate(ExtensionLoadingContext extensionLoadingContext) {
            this.extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            this.errorModels = this.extensionDeclaration.getErrorModels();
            this.connectivityError = ExtensionsErrorsDeclarationEnricher.this.getErrorModel(ExtensionsErrorsDeclarationEnricher.CONNECTIVITY_ERROR_TYPE, this.errorModels);
            this.retryErrorModel = ExtensionsErrorsDeclarationEnricher.this.getErrorModel(ExtensionsErrorsDeclarationEnricher.RETRY_EXHAUSTED_ERROR_TYPE, this.errorModels);
        }

        public void enrich() {
            new IdempotentDeclarationWalker(){

                @Override
                public void onOperation(WithOperationsDeclaration owner, OperationDeclaration operationDeclaration) {
                    EnricherDelegate.this.errorModels.addAll(operationDeclaration.getErrorModels());
                    if (operationDeclaration.isRequiresConnection()) {
                        ExtensionsErrorsDeclarationEnricher.this.addErrorModel(operationDeclaration, EnricherDelegate.this.connectivityError, ExtensionsErrorsDeclarationEnricher.CONNECTIVITY_ERROR_TYPE);
                        ExtensionsErrorsDeclarationEnricher.this.addErrorModel(operationDeclaration, EnricherDelegate.this.retryErrorModel, ExtensionsErrorsDeclarationEnricher.RETRY_EXHAUSTED_ERROR_TYPE);
                    }
                    EnricherDelegate.this.assureValidationError(EnricherDelegate.this.extensionDeclaration, operationDeclaration);
                }
            }.walk(this.extensionDeclaration);
        }

        private void assureValidationError(ExtensionDeclaration extensionDeclaration, OperationDeclaration operation) {
            if (operation.getStereotype() != null && operation.getStereotype().isAssignableTo(MuleStereotypes.VALIDATOR) && !ExtensionErrorUtils.getValidationError(operation.getErrorModels()).isPresent()) {
                operation.addErrorModel(this.getOrAddValidationError(extensionDeclaration));
            }
        }

        private ErrorModel getOrAddValidationError(ExtensionDeclaration extensionDeclaration) {
            if (this.validationErrorModel == null) {
                this.validationErrorModel = ExtensionErrorUtils.getValidationError(extensionDeclaration.getErrorModels()).orElse(null);
                if (this.validationErrorModel == null) {
                    ErrorModel parent = ErrorModelBuilder.newError(MuleErrors.VALIDATION.getType(), "MULE").withParent(ErrorModelBuilder.newError(MuleErrors.ANY.getType(), "MULE").build()).build();
                    this.validationErrorModel = ErrorModelBuilder.newError(MuleErrors.VALIDATION.getType(), ExtensionNamespaceUtils.getExtensionsNamespace(extensionDeclaration)).withParent(parent).build();
                    extensionDeclaration.addErrorModel(this.validationErrorModel);
                }
            }
            return this.validationErrorModel;
        }
    }
}

