/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.ast.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.extension.internal.ast.property.OperationComponentModelModelProperty;

public class StereotypesDiscoveryDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.POST_STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ClassUtils.withContextClassLoader(extensionLoadingContext.getExtensionClassLoader(), () -> new EnricherDelegate(extensionLoadingContext.getDslResolvingContext()).apply(extensionLoadingContext));
    }

    private static class EnricherDelegate {
        final DslResolvingContext dslResolvingContext;

        EnricherDelegate(DslResolvingContext dslResolvingContext) {
            this.dslResolvingContext = dslResolvingContext;
        }

        public void apply(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final Optional<GlobalElementComponentModelModelProperty> modelProperty = extensionDeclaration.getModelProperty(GlobalElementComponentModelModelProperty.class);
            new IdempotentDeclarationWalker(){

                @Override
                protected void onConfiguration(ConfigurationDeclaration declaration) {
                    this.walkDeclaration(modelProperty, declaration.getAllParameters());
                }

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    if (owner instanceof ConfigurationDeclaration) {
                        this.walkDeclaration(modelProperty, declaration.getAllParameters());
                    }
                }

                @Override
                protected void onOperation(OperationDeclaration declaration) {
                    declaration.getModelProperty(OperationComponentModelModelProperty.class).ifPresent(modelProperty -> {
                        ComponentAst bodyComponentModel = modelProperty.getBodyComponentModel();
                        declaration.getAllParameters().stream().filter(parameterDeclaration -> parameterDeclaration.getType() instanceof StringType).forEach(parameterDeclaration -> this.traverseProperty(bodyComponentModel.directChildrenStream(), parameterDeclaration));
                    });
                }
            }.walk(extensionDeclaration);
        }

        private void walkDeclaration(Optional<GlobalElementComponentModelModelProperty> globalElementModelProperty, List<ParameterDeclaration> allParameters) {
            globalElementModelProperty.ifPresent(modelProperty -> allParameters.stream().filter(parameterDeclaration -> parameterDeclaration.getType() instanceof StringType).forEach(parameterDeclaration -> this.traverseProperty(((GlobalElementComponentModelModelProperty)globalElementModelProperty.get()).getGlobalElements().stream(), (ParameterDeclaration)parameterDeclaration)));
        }

        private void traverseProperty(Stream<ComponentAst> componentModels, ParameterDeclaration parameterDeclaration) {
            ArrayList allowedStereotypeModels = new ArrayList();
            componentModels.forEach(componentModel -> {
                allowedStereotypeModels.add(this.findStereotypes((ComponentAst)componentModel, parameterDeclaration));
                componentModel.recursiveStream().forEach(innerComponentModel -> allowedStereotypeModels.add(this.findStereotypes((ComponentAst)innerComponentModel, parameterDeclaration)));
            });
            allowedStereotypeModels.stream().filter(stereotypeModels -> !stereotypeModels.isEmpty()).reduce((stereotypeModels, stereotypeModels2) -> {
                ArrayList partialIntersection = new ArrayList(stereotypeModels);
                partialIntersection.retainAll((Collection<?>)stereotypeModels2);
                return partialIntersection;
            }).ifPresent(parameterDeclaration::setAllowedStereotypeModels);
        }

        private List<StereotypeModel> findStereotypes(ComponentAst componentModel, ParameterDeclaration propertyDeclaration) {
            String expectedPropertyReference = "#[vars." + propertyDeclaration.getName() + "]";
            if (!componentModel.getModel(ParameterizedModel.class).isPresent()) {
                return Collections.emptyList();
            }
            return componentModel.getParameters().stream().filter(paramAst -> expectedPropertyReference.equals(paramAst.getResolvedRawValue())).map(paramAst -> paramAst.getModel().getName()).map(attributeName -> this.findStereotypes(componentModel.getIdentifier(), (String)attributeName)).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private List<StereotypeModel> findStereotypes(final ComponentIdentifier componentModelIdentifier, final String attributeName) {
            final ArrayList<StereotypeModel> allowedStereotypes = new ArrayList<StereotypeModel>();
            this.dslResolvingContext.getExtensions().stream().filter(extensionModel -> extensionModel.getXmlDslModel().getPrefix().equals(componentModelIdentifier.getNamespace())).findFirst().ifPresent(extensionModel -> {
                final DslSyntaxResolver dslSyntaxResolver = DslSyntaxResolver.getDefault(extensionModel, this.dslResolvingContext);
                new IdempotentExtensionWalker(){

                    @Override
                    protected void onConfiguration(ConfigurationModel configurationModel) {
                        allowedStereotypes.addAll(EnricherDelegate.getStereotypeModels(configurationModel, attributeName, dslSyntaxResolver, componentModelIdentifier));
                    }

                    @Override
                    protected void onConnectionProvider(ConnectionProviderModel connectionProviderModel) {
                        allowedStereotypes.addAll(EnricherDelegate.getStereotypeModels(connectionProviderModel, attributeName, dslSyntaxResolver, componentModelIdentifier));
                    }

                    @Override
                    protected void onOperation(OperationModel operationModel) {
                        allowedStereotypes.addAll(EnricherDelegate.getStereotypeModels(operationModel, attributeName, dslSyntaxResolver, componentModelIdentifier));
                    }
                }.walk((ExtensionModel)extensionModel);
            });
            return allowedStereotypes;
        }

        private static List<StereotypeModel> getStereotypeModels(ParameterizedModel parameterizedModel, String attributeName, DslSyntaxResolver dslSyntaxResolver, ComponentIdentifier componentModelIdentifier) {
            List allowedStereotypes = Collections.EMPTY_LIST;
            if (dslSyntaxResolver.resolve(parameterizedModel).getElementName().equals(componentModelIdentifier.getName())) {
                allowedStereotypes = parameterizedModel.getAllParameterModels().stream().filter(parameterModel -> dslSyntaxResolver.resolve((ParameterModel)parameterModel).getAttributeName().equals(attributeName)).map(ParameterModel::getAllowedStereotypes).flatMap(Collection::stream).collect(Collectors.toList());
            }
            return allowedStereotypes;
        }
    }
}

