/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.module.artifact.api.Artifact;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.internal.ArtifactDeploymentTemplate;
import org.mule.runtime.module.deployment.internal.CompositeDeploymentListener;
import org.mule.runtime.module.deployment.internal.DefaultArchiveDeployer;

public final class DomainDeploymentTemplate
implements ArtifactDeploymentTemplate {
    private Collection<Application> domainApplications = Collections.emptyList();
    private Map<Application, ApplicationStatus> appStatusPreRedeployment;
    private final DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer;
    private final DeploymentService deploymentservice;
    private final CompositeDeploymentListener applicationDeploymentListener;

    public DomainDeploymentTemplate(DefaultArchiveDeployer<ApplicationDescriptor, Application> applicationDeployer, DeploymentService deploymentservice, CompositeDeploymentListener applicationDeploymentListener) {
        this.applicationDeployer = applicationDeployer;
        this.deploymentservice = deploymentservice;
        this.applicationDeploymentListener = applicationDeploymentListener;
    }

    @Override
    public void preRedeploy(Artifact domain) {
        if (domain instanceof Domain) {
            this.appStatusPreRedeployment = new HashMap<Application, ApplicationStatus>();
            this.domainApplications = this.deploymentservice.findDomainApplications(domain.getArtifactName());
            for (Application domainApplication : this.domainApplications) {
                this.appStatusPreRedeployment.put(domainApplication, domainApplication.getStatus());
                this.applicationDeploymentListener.onRedeploymentStart(domainApplication.getArtifactName());
                this.applicationDeployer.undeployArtifactWithoutUninstall(domainApplication);
            }
        }
    }

    @Override
    public void postRedeploy(Artifact domain) {
        if (domain != null && !this.domainApplications.isEmpty()) {
            RuntimeException firstException = null;
            for (Application domainApplication : this.domainApplications) {
                this.applicationDeployer.preTrackArtifact(domainApplication);
                if (!this.applicationDeployer.isUpdatedZombieArtifact(domainApplication.getArtifactName())) continue;
                try {
                    this.applicationDeployer.deployExplodedArtifact(domainApplication.getArtifactName(), (Optional)this.getProperties(this.appStatusPreRedeployment.get(domainApplication)));
                    this.applicationDeploymentListener.onRedeploymentSuccess(domainApplication.getArtifactName());
                }
                catch (RuntimeException e) {
                    this.applicationDeploymentListener.onRedeploymentFailure(domainApplication.getArtifactName(), e);
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }
        this.domainApplications = Collections.emptyList();
    }

    private Optional<Properties> getProperties(ApplicationStatus applicationStatus) {
        Properties properties = new Properties();
        boolean startArtifact = applicationStatus.equals((Object)ApplicationStatus.STARTED) || applicationStatus.equals((Object)ApplicationStatus.DEPLOYMENT_FAILED);
        properties.setProperty("startArtifactOnDeployment", String.valueOf(startArtifact));
        return Optional.of(properties);
    }
}

