/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.delegate;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.HasParametersDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclarer;
import org.mule.runtime.extension.api.property.ExcludeFromConnectivitySchemaModelProperty;
import org.mule.runtime.module.extension.internal.loader.delegate.StereotypeModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterModelParser;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;

public final class ParameterModelsLoaderDelegate {
    private final Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader;
    private final Consumer<MetadataType> typeRegisterer;

    public ParameterModelsLoaderDelegate(Supplier<StereotypeModelLoaderDelegate> stereotypeModelLoader, Consumer<MetadataType> typeRegisterer) {
        this.stereotypeModelLoader = stereotypeModelLoader;
        this.typeRegisterer = typeRegisterer;
    }

    public List<ParameterDeclarer> declare(HasParametersDeclarer component, List<ParameterGroupModelParser> groupParsers) {
        LinkedList<ParameterDeclarer> declarerList = new LinkedList<ParameterDeclarer>();
        groupParsers.forEach(group -> {
            ParameterGroupDeclarer groupDeclarer;
            if ("General".equals(group.getName())) {
                groupDeclarer = component.onDefaultParameterGroup();
            } else {
                groupDeclarer = component.onParameterGroup(group.getName()).withDslInlineRepresentation(group.showsInDsl());
                group.getDisplayModel().ifPresent(groupDeclarer::withDisplayModel);
                group.getLayoutModel().ifPresent(groupDeclarer::withLayout);
                group.getAdditionalModelProperties().forEach(groupDeclarer::withModelProperty);
                group.getExclusiveOptionals().ifPresent(descriptor -> groupDeclarer.withExclusiveOptionals(descriptor.getExclusiveOptionals(), descriptor.isOneRequired()));
                ((BaseDeclaration)groupDeclarer.getDeclaration()).setDescription(group.getDescription());
                group.getLayoutModel().ifPresent(groupDeclarer::withLayout);
            }
            group.getParameterParsers().forEach(parameterParser -> {
                ParameterDeclarer parameter = parameterParser.isRequired() ? groupDeclarer.withRequiredParameter(parameterParser.getName()) : groupDeclarer.withOptionalParameter(parameterParser.getName()).defaultingTo(parameterParser.getDefaultValue());
                MetadataType metadataType = parameterParser.getType();
                ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)parameter.ofType(metadataType)).describedAs(parameterParser.getDescription())).withRole(parameterParser.getRole())).withExpressionSupport(parameterParser.getExpressionSupport());
                this.typeRegisterer.accept(metadataType);
                if (parameterParser.isComponentId()) {
                    parameter.asComponentId();
                }
                if (parameterParser.isConfigOverride()) {
                    parameter.asConfigOverride();
                }
                if (parameterParser.isExcludedFromConnectivitySchema()) {
                    parameter.withModelProperty(new ExcludeFromConnectivitySchemaModelProperty());
                }
                parameterParser.getLayoutModel().ifPresent(parameter::withLayout);
                parameterParser.getDslConfiguration().ifPresent(parameter::withDsl);
                parameterParser.getDeprecationModel().ifPresent(parameter::withDeprecation);
                parameterParser.getDisplayModel().ifPresent(parameter::withDisplayModel);
                parameterParser.getOAuthParameterModelProperty().ifPresent(parameter::withModelProperty);
                parameterParser.getAdditionalModelProperties().forEach(parameter::withModelProperty);
                ModelLoaderUtils.addSemanticTerms(parameter.getDeclaration(), parameterParser);
                this.stereotypeModelLoader.get().addStereotypes((ParameterModelParser)parameterParser, parameter);
                declarerList.add(parameter);
            });
            if (declarerList.stream().noneMatch(p -> p.getDeclaration().isComponentId())) {
                declarerList.stream().filter(p -> p.getDeclaration().getName().equals("name") && p.getDeclaration().isRequired() && p.getDeclaration().getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && p.getDeclaration().getType() instanceof StringType && p.getDeclaration().getAllowedStereotypeModels().isEmpty()).forEach(p -> p.asComponentId());
            }
        });
        return declarerList;
    }
}

