/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.extension.internal.loader.util.JavaParserUtils;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.UnauthorizeOperationExecutor;

public class JavaOAuthDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    public static final class JavaOAuthCompletableComponentExecutorFactory
    implements CompletableComponentExecutorFactory<ComponentModel> {
        @Override
        public CompletableComponentExecutor<ComponentModel> createExecutor(ComponentModel componentModel, Map<String, Object> parameters) {
            return new UnauthorizeOperationExecutor();
        }

        public void setComponentDecoratorFactory(CursorComponentDecoratorFactory componentDecoratorFactory) {
        }
    }

    private class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
        private final MetadataType stringType = this.typeLoader.load((Type)((Object)String.class));
        private final MetadataType voidType = this.typeLoader.load(Void.TYPE);

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            final HashSet visitedProviders = new HashSet();
            final HashSet oauthConfigs = new HashSet();
            final Reference<Boolean> oauthGloballySupported = new Reference<Boolean>(false);
            final Reference<Boolean> supportsAuthCode = new Reference<Boolean>(false);
            final Reference<Boolean> supportsClientCredentials = new Reference<Boolean>(false);
            new DeclarationWalker(){

                @Override
                protected void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
                    declaration.getModelProperty(OAuthModelProperty.class).ifPresent(mp -> {
                        mp.getGrantTypes().forEach(grantType -> grantType.accept(new OAuthGrantTypeVisitor(){

                            @Override
                            public void visit(AuthorizationCodeGrantType grantType) {
                                supportsAuthCode.set(true);
                            }

                            @Override
                            public void visit(ClientCredentialsGrantType grantType) {
                                supportsClientCredentials.set(true);
                            }

                            @Override
                            public void visit(PlatformManagedOAuthGrantType grantType) {
                            }
                        }));
                        if (owner instanceof ExtensionDeclaration) {
                            oauthGloballySupported.set(true);
                        } else if (owner instanceof ConfigurationDeclaration) {
                            oauthConfigs.add(new Reference<ConfigurationDeclaration>((ConfigurationDeclaration)owner));
                        }
                        if (!visitedProviders.add(new Reference<ConnectionProviderDeclaration>(declaration))) {
                            return;
                        }
                    });
                }
            }.walk(extensionDeclaration);
            List<ConfigurationDeclaration> configs = oauthGloballySupported.get() != false ? extensionDeclaration.getConfigurations() : oauthConfigs.stream().map(Reference::get).collect(Collectors.toList());
            OperationDeclaration unauthorize = this.buildUnauthorizeOperation(supportsAuthCode.get());
            configs.forEach(c -> c.addOperation(unauthorize));
        }

        private void validateExpressionSupport(ConnectionProviderDeclaration provider, ParameterDeclaration parameter, Field field) {
            if (JavaParserUtils.getExpressionSupport(field).filter(expression -> expression == ExpressionSupport.NOT_SUPPORTED).isPresent()) {
                throw new IllegalConnectionProviderModelDefinitionException(String.format("Parameter '%s' in Connection Provider '%s' is marked as supporting expressions. Expressions are not supported in OAuth parameters", parameter.getName(), provider.getName()));
            }
        }

        private OperationDeclaration buildUnauthorizeOperation(boolean supportsAuthCode) {
            OperationDeclaration operation = new OperationDeclaration("unauthorize");
            operation.setDescription("Deletes all the access token information of a given resource owner id so that it's impossible to execute any operation for that user without doing the authorization dance again");
            operation.setBlocking(true);
            operation.setExecutionType(ExecutionType.BLOCKING);
            operation.setOutput(this.toDeclaration(this.voidType));
            operation.setOutputAttributes(this.toDeclaration(this.voidType));
            operation.setRequiresConnection(false);
            operation.setSupportsStreaming(false);
            operation.setTransactional(false);
            operation.addModelProperty(new CompletableComponentExecutorModelProperty(new JavaOAuthCompletableComponentExecutorFactory()));
            if (supportsAuthCode) {
                ParameterGroupDeclaration group = operation.getParameterGroup("General");
                group.showInDsl(false);
                ParameterDeclaration parameter = new ParameterDeclaration("resourceOwnerId");
                parameter.setDescription("The id of the resource owner which access should be invalidated");
                parameter.setExpressionSupport(ExpressionSupport.SUPPORTED);
                parameter.setLayoutModel(LayoutModel.builder().build());
                parameter.setRequired(false);
                parameter.setParameterRole(ParameterRole.BEHAVIOUR);
                parameter.setType(this.stringType, false);
                group.addParameter(parameter);
            }
            return operation;
        }

        private OutputDeclaration toDeclaration(MetadataType type) {
            OutputDeclaration declaration = new OutputDeclaration();
            declaration.setType(type, false);
            return declaration;
        }
    }
}

