/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.internal.semantic.SemanticTermsHelper;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.DefaultConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.oauth.OAuthCallbackValuesModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.ConnectionProviderModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.parser.java.ParameterDeclarationContext;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.JavaConnectionProviderModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.connection.SdkCredentialPlacementUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.lib.JavaExternalLibModelParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.semantics.SemanticTermsParserUtils;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.sdk.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.sdk.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.sdk.api.annotation.connectivity.oauth.OAuthCallbackValue;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.connectivity.ConnectionProvider;
import org.mule.sdk.api.connectivity.NoConnectivityTest;

public class JavaConnectionProviderModelParser
implements ConnectionProviderModelParser {
    private static final String CONNECTION_PROVIDER_NAME = "connection provider";
    private final JavaExtensionModelParser extensionModelParser;
    private final ConnectionProviderElement element;
    private final List<ModelProperty> additionalModelProperties = new LinkedList<ModelProperty>();
    private final ClassLoader extensionClassLoader;

    public JavaConnectionProviderModelParser(JavaExtensionModelParser extensionModelParser, ExtensionElement extensionElement, ConnectionProviderElement element) {
        this.extensionModelParser = extensionModelParser;
        this.element = element;
        this.extensionClassLoader = extensionElement.getDeclaringClass().map(Class::getClassLoader).orElse(ExtensionModel.class.getClassLoader());
        this.collectAdditionalModelProperties();
    }

    @Override
    public String getName() {
        if (this.element.getName().equals(this.element.getAlias())) {
            return "connection";
        }
        return this.element.getAlias();
    }

    @Override
    public String getDescription() {
        return this.element.getDescription();
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return JavaExtensionModelParserUtils.getParameterGroupParsers(this.element.getParameters(), ParameterDeclarationContext.forConnectionProvider(this.getName()));
    }

    @Override
    public List<ExternalLibraryModel> getExternalLibraryModels() {
        return JavaExternalLibModelParserUtils.parseExternalLibraryModels(this.element);
    }

    @Override
    public ConnectionManagementType getConnectionManagementType() {
        ConnectionManagementType managementType = ConnectionManagementType.NONE;
        if (JavaConnectionProviderModelParserUtils.isPoolingConnectionProvider(this.element)) {
            managementType = ConnectionManagementType.POOLING;
        } else if (JavaConnectionProviderModelParserUtils.isCachedConnectionProvider(this.element)) {
            managementType = ConnectionManagementType.CACHED;
        }
        return managementType;
    }

    @Override
    public Optional<ConnectionProviderFactoryModelProperty> getConnectionProviderFactoryModelProperty() {
        return this.element.getDeclaringClass().map(declaringClass -> new ConnectionProviderFactoryModelProperty(new DefaultConnectionProviderFactory((Class<?>)declaringClass, this.extensionClassLoader)));
    }

    @Override
    public boolean supportsConnectivityTesting() {
        return !this.element.isAssignableTo(NoConnectivityTest.class) && !this.element.isAssignableTo(org.mule.runtime.extension.api.connectivity.NoConnectivityTest.class);
    }

    @Override
    public boolean isExcludedFromConnectivitySchema() {
        return this.element.isAnnotatedWith(ExcludeFromConnectivitySchema.class);
    }

    @Override
    public Optional<OAuthModelProperty> getOAuthModelProperty() {
        LinkedList<OAuthGrantType> grantTypes = new LinkedList<OAuthGrantType>();
        MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.element, CONNECTION_PROVIDER_NAME, this.element.getName(), org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode.class, AuthorizationCode.class, this::getAuthorizationCodeGrantType, this::getAuthorizationCodeGrantTypeFromSdk).ifPresent(grantTypes::add);
        MuleExtensionAnnotationParser.mapReduceSingleAnnotation(this.element, CONNECTION_PROVIDER_NAME, this.element.getName(), org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials.class, ClientCredentials.class, this::getClientCredentialsGrantType, this::getClientCredentialsGrantTypeFromSdk).ifPresent(grantTypes::add);
        return grantTypes.isEmpty() ? Optional.empty() : Optional.of(new OAuthModelProperty(grantTypes));
    }

    @Override
    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return JavaStereotypeModelParserUtils.resolveStereotype(this.element, "Connection Provider", this.getName(), factory);
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return this.additionalModelProperties;
    }

    private void collectAdditionalModelProperties() {
        Class baseInterface = JavaConnectionProviderModelParserUtils.isDefinedThroughSdkApi(this.element) ? ConnectionProvider.class : org.mule.runtime.api.connection.ConnectionProvider.class;
        List<Type> providerGenerics = this.element.getSuperTypeGenerics(baseInterface);
        if (providerGenerics.size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection provider class '%s' was expected to have 1 generic type (for the connection type) but %d were found", this.element.getName(), providerGenerics.size()));
        }
        this.additionalModelProperties.add(new ConnectionTypeModelProperty(providerGenerics.get(0)));
        this.element.getDeclaringClass().ifPresent(clazz -> this.additionalModelProperties.add(new ImplementingTypeModelProperty((Class<?>)clazz)));
        this.element.getDeclaringClass().ifPresent(clazz -> this.getOAuthCallbackValuesModelProperty((Class<?>)clazz).ifPresent(this.additionalModelProperties::add));
        this.additionalModelProperties.add(new ExtensionTypeDescriptorModelProperty(this.element));
    }

    private Optional<OAuthCallbackValuesModelProperty> getOAuthCallbackValuesModelProperty(Class<?> clazz) {
        Map<Field, String> values = IntrospectionUtils.getAnnotatedFields(clazz, org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthCallbackValue.class).stream().collect(Collectors.toMap(UnaryOperator.identity(), field -> field.getAnnotation(org.mule.runtime.extension.api.annotation.connectivity.oauth.OAuthCallbackValue.class).expression()));
        values.putAll(IntrospectionUtils.getAnnotatedFields(clazz, OAuthCallbackValue.class).stream().collect(Collectors.toMap(UnaryOperator.identity(), field -> field.getAnnotation(OAuthCallbackValue.class).expression())));
        if (!values.isEmpty()) {
            return Optional.of(new OAuthCallbackValuesModelProperty(values));
        }
        return Optional.empty();
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return JavaExtensionModelParserUtils.getDeprecationModel(this.element);
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return JavaExtensionModelParserUtils.getDisplayModel(this.element, CONNECTION_PROVIDER_NAME, this.element.getName());
    }

    @Override
    public Set<String> getSemanticTerms() {
        LinkedHashSet<String> terms = new LinkedHashSet<String>();
        terms.addAll(SemanticTermsHelper.getConnectionTermsFromAnnotations(this.element::isAnnotatedWith));
        SemanticTermsParserUtils.addCustomTerms(this.element, terms);
        return terms;
    }

    public boolean equals(Object o) {
        if (o instanceof JavaConnectionProviderModelParser) {
            return this.element.equals(((JavaConnectionProviderModelParser)o).element);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    private AuthorizationCodeGrantType getAuthorizationCodeGrantType(AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode> authorizationCodeAnnotationValueFetcher) {
        return new AuthorizationCodeGrantType(authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::accessTokenUrl), authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::authorizationUrl), authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::accessTokenExpr), authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::expirationExpr), authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::refreshTokenExpr), authorizationCodeAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::defaultScopes), authorizationCodeAnnotationValueFetcher.getEnumValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::credentialsPlacement), authorizationCodeAnnotationValueFetcher.getBooleanValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode::includeRedirectUriInRefreshTokenRequest));
    }

    private AuthorizationCodeGrantType getAuthorizationCodeGrantTypeFromSdk(AnnotationValueFetcher<AuthorizationCode> authorizationCodeAnnotationValueFetcher) {
        return new AuthorizationCodeGrantType(authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::accessTokenUrl), authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::authorizationUrl), authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::accessTokenExpr), authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::expirationExpr), authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::refreshTokenExpr), authorizationCodeAnnotationValueFetcher.getStringValue(AuthorizationCode::defaultScopes), authorizationCodeAnnotationValueFetcher.getEnumValue(authorizationCode -> SdkCredentialPlacementUtils.from(authorizationCode.credentialsPlacement())), authorizationCodeAnnotationValueFetcher.getBooleanValue(AuthorizationCode::includeRedirectUriInRefreshTokenRequest));
    }

    private ClientCredentialsGrantType getClientCredentialsGrantType(AnnotationValueFetcher<org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials> clientCredentialsAnnotationValueFetcher) {
        return new ClientCredentialsGrantType(clientCredentialsAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials::tokenUrl), clientCredentialsAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials::accessTokenExpr), clientCredentialsAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials::expirationExpr), clientCredentialsAnnotationValueFetcher.getStringValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials::defaultScopes), clientCredentialsAnnotationValueFetcher.getEnumValue(org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials::credentialsPlacement));
    }

    private ClientCredentialsGrantType getClientCredentialsGrantTypeFromSdk(AnnotationValueFetcher<ClientCredentials> clientCredentialsAnnotationValueFetcher) {
        return new ClientCredentialsGrantType(clientCredentialsAnnotationValueFetcher.getStringValue(ClientCredentials::tokenUrl), clientCredentialsAnnotationValueFetcher.getStringValue(ClientCredentials::accessTokenExpr), clientCredentialsAnnotationValueFetcher.getStringValue(ClientCredentials::expirationExpr), clientCredentialsAnnotationValueFetcher.getStringValue(ClientCredentials::defaultScopes), clientCredentialsAnnotationValueFetcher.getEnumValue(clientCredentials -> SdkCredentialPlacementUtils.from(clientCredentials.credentialsPlacement())));
    }
}

