/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validator;

import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.deprecated.DeprecableModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.validation.ModelValidationUtils;

public class DeprecationModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        if (!ModelValidationUtils.isCompiletime(extensionModel)) {
            return;
        }
        this.validateDeprecationVersions(extensionModel, problemsReporter);
        new IdempotentExtensionWalker(){

            @Override
            protected void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
                if (model.isRequired() && model.isDeprecated()) {
                    problemsReporter.addError(new Problem(model, String.format("Parameter \"%s\" from %s named \"%s\" is required but has been marked as deprecated. Required parameters cannot be deprecated. Use the @Optional annotation to make it optional and add a default value.", model.getName(), NameUtils.getComponentModelTypeName(owner), owner.getName())));
                }
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }

            @Override
            protected void onSource(SourceModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }

            @Override
            protected void onConstruct(ConstructModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }

            @Override
            protected void onOperation(OperationModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }

            @Override
            protected void onFunction(FunctionModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                DeprecationModelValidator.this.validateDeprecationVersions(model, problemsReporter);
            }
        }.walk(extensionModel);
    }

    private void validateDeprecationVersions(DeprecableModel deprecableModel, ProblemsReporter problemsReporter) {
        deprecableModel.getDeprecationModel().ifPresent(deprecationModel -> {
            MuleVersion deprecatedSince = null;
            MuleVersion toRemoveIn = null;
            try {
                deprecatedSince = new MuleVersion(deprecationModel.getDeprecatedSince());
            }
            catch (IllegalArgumentException e) {
                this.reportInvalidVersion(deprecationModel.getDeprecatedSince(), deprecableModel, problemsReporter, "since");
            }
            try {
                toRemoveIn = deprecationModel.getToRemoveIn().map(MuleVersion::new).orElse(null);
            }
            catch (IllegalArgumentException e) {
                deprecationModel.getToRemoveIn().ifPresent(toRemoveInString -> this.reportInvalidVersion((String)toRemoveInString, deprecableModel, problemsReporter, "toRemoveIn"));
            }
            if (deprecatedSince != null && toRemoveIn != null && !deprecatedSince.priorTo(toRemoveIn)) {
                this.reportSinceVersionPriorToRemoveVersion(deprecatedSince, toRemoveIn, deprecableModel, problemsReporter);
            }
        });
    }

    private void reportInvalidVersion(String versionString, DeprecableModel deprecableModel, ProblemsReporter problemsReporter, String versionType) {
        if (deprecableModel instanceof NamedObject) {
            problemsReporter.addError(new Problem((NamedObject)((Object)deprecableModel), String.format("The %s named %s was deprecated with an invalid '%s' version : '%s' . This version must follow the semver convention", this.getModelTypeName(deprecableModel), ((NamedObject)((Object)deprecableModel)).getName(), versionType, versionString)));
        }
    }

    private void reportSinceVersionPriorToRemoveVersion(MuleVersion deprecatedSince, MuleVersion toRemoveIn, DeprecableModel deprecableModel, ProblemsReporter problemsReporter) {
        if (deprecableModel instanceof NamedObject) {
            problemsReporter.addError(new Problem((NamedObject)((Object)deprecableModel), String.format("The versions chosen for the deprecation of the %s named %s are invalid, `since`(%s) version must be prior to the `removeTo`(%s) version.", this.getModelTypeName(deprecableModel), ((NamedObject)((Object)deprecableModel)).getName(), deprecatedSince.toString(), toRemoveIn.toString())));
        }
    }

    private String getModelTypeName(DeprecableModel deprecableModel) {
        return deprecableModel instanceof ParameterizedModel ? NameUtils.getComponentModelTypeName((ParameterizedModel)((Object)deprecableModel)) : (deprecableModel instanceof ExtensionModel ? "extension" : "parameter");
    }
}

