/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.deprecated.DeprecationModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.operation.ExecutionType;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalOperationModelDefinitionException;
import org.mule.runtime.module.extension.api.loader.java.property.CompletableComponentExecutorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ExceptionHandlerModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.parser.DefaultOutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ErrorModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedChainModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.NestedRouteModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OperationModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.OutputModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.ParameterGroupModelParser;
import org.mule.runtime.module.extension.internal.loader.parser.StereotypeModelFactory;
import org.mule.runtime.module.extension.mule.internal.loader.parser.BaseMuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkParameterGroupModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.VoidOutputModelParser;

class MuleSdkOperationModelParserSdk
extends BaseMuleSdkExtensionModelParser
implements OperationModelParser {
    private final ComponentAst operation;
    private final TypeLoader typeLoader;
    private String name;

    public MuleSdkOperationModelParserSdk(ComponentAst operation, TypeLoader typeLoader) {
        this.operation = operation;
        this.typeLoader = typeLoader;
        this.parseStructure();
    }

    private void parseStructure() {
        this.name = (String)this.getParameter(this.operation, "name");
    }

    private OutputModelParser asOutputModelParser(ComponentAst outputTypeElement) {
        String type = (String)this.getParameter(outputTypeElement, "type");
        return this.typeLoader.load(type).map(mt -> new DefaultOutputModelParser((MetadataType)mt, false)).orElseThrow(() -> new IllegalModelDefinitionException(String.format("Component <%s:%s> defines %s as '%s' but such type is not defined in the application", outputTypeElement.getIdentifier().getNamespace(), outputTypeElement.getIdentifier().getName(), outputTypeElement.getIdentifier().getName())));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.getOptionalParameter(this.operation, "description").orElse("");
    }

    @Override
    public List<ModelProperty> getAdditionalModelProperties() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getEmittedNotifications() {
        return Collections.emptyList();
    }

    @Override
    public OutputModelParser getOutputType() {
        return this.asOutputModelParser(this.getOutputPayloadTypeElement());
    }

    @Override
    public OutputModelParser getAttributesOutputType() {
        return this.getOutputAttributesTypeElement().map(this::asOutputModelParser).orElse(VoidOutputModelParser.INSTANCE);
    }

    @Override
    public List<ParameterGroupModelParser> getParameterGroupModelParsers() {
        return this.getSingleChild(this.operation, "parameters").map(p -> this.getChildren((ComponentAst)p, "parameter").collect(Collectors.toList())).map(parameters -> Collections.singletonList(new MuleSdkParameterGroupModelParser((List<ComponentAst>)parameters, this.typeLoader))).orElse(Collections.emptyList());
    }

    @Override
    public List<NestedRouteModelParser> getNestedRouteParsers() {
        return Collections.emptyList();
    }

    @Override
    public Optional<CompletableComponentExecutorModelProperty> getExecutorModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<NestedChainModelParser> getNestedChainParser() {
        return Optional.empty();
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isScope() {
        return false;
    }

    @Override
    public boolean isRouter() {
        return false;
    }

    @Override
    public boolean isConnected() {
        return false;
    }

    @Override
    public boolean hasConfig() {
        return false;
    }

    @Override
    public boolean supportsStreaming() {
        return false;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    @Override
    public boolean isAutoPaging() {
        return false;
    }

    @Override
    public Optional<ExecutionType> getExecutionType() {
        return Optional.of(ExecutionType.CPU_LITE);
    }

    @Override
    public Optional<MediaTypeModelProperty> getMediaTypeModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<ExceptionHandlerModelProperty> getExceptionHandlerModelProperty() {
        return Optional.empty();
    }

    @Override
    public Optional<DeprecationModel> getDeprecationModel() {
        return Optional.empty();
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        String summary = this.getOptionalParameter(this.operation, "summary").orElse(null);
        String displayName = this.getOptionalParameter(this.operation, "displayName").orElse(null);
        if (!StringUtils.isBlank(displayName) || !StringUtils.isBlank(summary)) {
            return Optional.of(DisplayModel.builder().summary(summary).displayName(displayName).build());
        }
        return Optional.empty();
    }

    @Override
    public List<ErrorModelParser> getErrorModelParsers() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getSemanticTerms() {
        return Collections.emptySet();
    }

    @Override
    public Optional<StereotypeModel> getStereotype(StereotypeModelFactory factory) {
        return Optional.empty();
    }

    private ComponentAst getOutputPayloadTypeElement() {
        String elementName = "payload-type";
        return this.getOutputElement("payload-type").orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <%s> declaration", this.getName(), "payload-type")));
    }

    private Optional<ComponentAst> getOutputAttributesTypeElement() {
        return this.getOutputElement("attributes-type");
    }

    private Optional<ComponentAst> getOutputElement(String elementName) {
        ComponentAst output = this.operation.directChildrenStreamByIdentifier(null, "output").findFirst().orElseThrow(() -> new IllegalOperationModelDefinitionException(String.format("Operation '%s' is missing its <output> declaration", this.getName())));
        return output.directChildrenStreamByIdentifier(null, elementName).findFirst();
    }
}

