/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.util.UUID;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ClassLoaderModel;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultApplicationFactory;
import org.mule.runtime.module.deployment.impl.internal.application.DeployableMavenClassLoaderModelLoader;
import org.mule.runtime.module.deployment.impl.internal.maven.MavenUtils;
import org.mule.runtime.module.tooling.api.ArtifactAgnosticServiceBuilder;
import org.mule.runtime.module.tooling.internal.ApplicationSupplier;

public abstract class AbstractArtifactAgnosticServiceBuilder<T extends ArtifactAgnosticServiceBuilder, S>
implements ArtifactAgnosticServiceBuilder<T, S> {
    private static final String TMP_APP_ARTIFACT_ID = "temp-artifact-id";
    private static final String TMP_APP_GROUP_ID = "temp-group-id";
    private static final String TMP_APP_VERSION = "temp-version";
    private static final String TMP_APP_MODEL_VERSION = "4.0.0";
    private final DefaultApplicationFactory defaultApplicationFactory;
    private ArtifactDeclaration artifactDeclaration;
    private Model model;
    private Map<String, String> artifactProperties = Collections.emptyMap();

    protected AbstractArtifactAgnosticServiceBuilder(DefaultApplicationFactory defaultApplicationFactory) {
        this.defaultApplicationFactory = defaultApplicationFactory;
        this.createTempMavenModel();
    }

    @Override
    public T setArtifactProperties(Map<String, String> artifactProperties) {
        Preconditions.checkState(artifactProperties != null, "artifactProperties cannot be null");
        this.artifactProperties = artifactProperties;
        return this.getThis();
    }

    @Override
    public T setArtifactDeclaration(ArtifactDeclaration artifactDeclaration) {
        Preconditions.checkState(artifactDeclaration != null, "artifactDeclaration cannot be null");
        this.artifactDeclaration = artifactDeclaration;
        return this.getThis();
    }

    @Override
    public T addDependency(String groupId, String artifactId, String artifactVersion, String classifier, String type) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(artifactVersion);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        this.addMavenModelDependency(dependency);
        return this.getThis();
    }

    @Override
    public T addDependency(ArtifactAgnosticServiceBuilder.Dependency dependency) {
        Dependency mavenModelDependency = new Dependency();
        mavenModelDependency.setGroupId(dependency.getGroupId());
        mavenModelDependency.setArtifactId(dependency.getArtifactId());
        mavenModelDependency.setVersion(dependency.getVersion());
        mavenModelDependency.setType(dependency.getType());
        mavenModelDependency.setClassifier(dependency.getClassifier());
        mavenModelDependency.setOptional(dependency.getOptional());
        mavenModelDependency.setScope(dependency.getScope());
        mavenModelDependency.setSystemPath(dependency.getSystemPath());
        mavenModelDependency.setExclusions(dependency.getExclusions().stream().map(exclusion -> {
            Exclusion mavenModelExclusion = new Exclusion();
            mavenModelExclusion.setGroupId(exclusion.getGroupId());
            mavenModelExclusion.setArtifactId(exclusion.getArtifactId());
            return mavenModelExclusion;
        }).collect(Collectors.toList()));
        this.addMavenModelDependency(mavenModelDependency);
        return this.getThis();
    }

    private void addMavenModelDependency(Dependency dependency) {
        if (!"mule-plugin".equals(dependency.getClassifier())) {
            MavenUtils.addSharedLibraryDependency(this.model, dependency);
        }
        this.model.getDependencies().add(dependency);
    }

    @Override
    public S build() {
        Preconditions.checkState(this.artifactDeclaration != null, "artifact configuration cannot be null");
        return this.createService(() -> {
            String applicationName = UUID.getUUID() + "-artifact-temp-app";
            File applicationFolder = new File(MuleFoldersUtil.getExecutionFolder(), applicationName);
            Properties deploymentProperties = new Properties();
            deploymentProperties.putAll(this.forcedDeploymentProperties());
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(applicationName, Optional.of(deploymentProperties));
            applicationDescriptor.setArtifactDeclaration(this.artifactDeclaration);
            applicationDescriptor.setConfigResources(Collections.singleton("empty-app.xml"));
            applicationDescriptor.setArtifactLocation(applicationFolder);
            applicationDescriptor.setAppProperties(this.artifactProperties);
            MavenUtils.createDeployablePomFile(applicationFolder, this.model);
            MavenUtils.updateArtifactPom(applicationFolder, this.model);
            MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider(AbstractArtifactAgnosticServiceBuilder.class.getClassLoader());
            applicationDescriptor.setClassLoaderModel((ClassLoaderModel)new DeployableMavenClassLoaderModelLoader(Optional.of(mavenClientProvider.createMavenClient(GlobalConfigLoader.getMavenConfig()))).load(applicationFolder, Collections.singletonMap(BundleDescriptor.class.getName(), this.createTempBundleDescriptor()), ArtifactType.APP));
            return this.defaultApplicationFactory.createArtifact(applicationDescriptor);
        });
    }

    protected Map<String, String> forcedDeploymentProperties() {
        return Collections.emptyMap();
    }

    protected abstract S createService(ApplicationSupplier var1);

    private void createTempMavenModel() {
        this.model = new Model();
        this.model.setArtifactId(TMP_APP_ARTIFACT_ID);
        this.model.setGroupId(TMP_APP_GROUP_ID);
        this.model.setVersion(TMP_APP_VERSION);
        this.model.setDependencies(new ArrayList());
        this.model.setModelVersion(TMP_APP_MODEL_VERSION);
    }

    private BundleDescriptor createTempBundleDescriptor() {
        return new BundleDescriptor.Builder().setArtifactId(TMP_APP_ARTIFACT_ID).setGroupId(TMP_APP_GROUP_ID).setVersion(TMP_APP_VERSION).setClassifier("mule-application").build();
    }

    private T getThis() {
        return (T)this;
    }
}

