/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.util;

import com.ning.http.client.uri.Uri;
import org.glassfish.grizzly.http.util.Header;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class RedirectUtils {
    private final boolean isStrict302Handling;

    public RedirectUtils(boolean isStrict302Handling) {
        this.isStrict302Handling = isStrict302Handling;
    }

    public boolean shouldFollowRedirect(HttpResponse response, HttpRequestOptions options, boolean enableMuleRedirect) {
        return enableMuleRedirect && this.isRedirected(response.getStatusCode()) && response.getHeaders().containsKey("Location") && options.isFollowsRedirect();
    }

    private boolean isRedirected(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    private boolean mustBeSendAsGet(int statusCode) {
        return statusCode >= 302 && statusCode <= 303 && (statusCode != 302 || !this.isStrict302Handling);
    }

    public HttpRequest createRedirectRequest(HttpResponse response, HttpRequest request, HttpRequestOptions options) {
        String redirectMethod;
        Uri path = Uri.create((Uri)Uri.create((String)request.getUri().toString()), (String)response.getHeaders().get("Location"));
        MultiMap<String, String> headers = new MultiMap<String, String>(request.getHeaders());
        headers.remove(Header.Host.toString());
        headers.remove(Header.ContentLength.toString());
        if (this.mustBeSendAsGet(response.getStatusCode())) {
            redirectMethod = HttpConstants.Method.GET.name();
            headers.remove(Header.ContentType.toString());
        } else {
            redirectMethod = request.getMethod();
        }
        options.getAuthentication().ifPresent(httpAuthentication -> {
            if (httpAuthentication.getType().equals((Object)HttpAuthenticationType.NTLM)) {
                headers.remove(Header.Authorization.toString());
                headers.remove(Header.ProxyAuthorization.toString());
            }
        });
        return ((HttpRequestBuilder)((HttpRequestBuilder)HttpRequest.builder().uri(path.toUrl()).method(redirectMethod).protocol(request.getProtocol()).headers(headers)).entity(request.getEntity())).build();
    }
}

