/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.core.functions;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.charset.Charset;
import org.mule.weave.v2.RuntimeConfigProperties$;
import org.mule.weave.v2.io.SeekableStream;
import org.mule.weave.v2.io.SeekableStream$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.types.ArrayType$;
import org.mule.weave.v2.model.types.ObjectType$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.option.Settings;
import org.mule.weave.v2.module.reader.AutoPersistedOutputStream;
import org.mule.weave.v2.module.writer.ConfigurableEncoding;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.parser.location.LocationCapable;
import org.mule.weave.v2.parser.location.UnknownLocation$;
import org.mule.weave.v2.util.BinaryHelper$;
import org.mule.weave.v2.util.TryClose$;
import org.mule.weave.v2.utils.StringHelper$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class WriteFunctionValue$ {
    public static WriteFunctionValue$ MODULE$;
    private final String DATA_WEAVE_MIMETYPE;
    private final Integer maxValueLength;

    static {
        new WriteFunctionValue$();
    }

    public String DATA_WEAVE_MIMETYPE() {
        return this.DATA_WEAVE_MIMETYPE;
    }

    public Integer maxValueLength() {
        return this.maxValueLength;
    }

    private Either<String, SeekableStream> processResult(InputStream stream, String charset, DataFormat<?, ?> dataFormat, EvaluationContext parentContext) {
        Left left;
        if (dataFormat.binaryFormat()) {
            Right right;
            InputStream inputStream = stream;
            if (inputStream instanceof SeekableStream) {
                SeekableStream seekableStream = (SeekableStream)((Object)inputStream);
                right = package$.MODULE$.Right().apply((Object)seekableStream);
            } else {
                right = package$.MODULE$.Right().apply((Object)SeekableStream$.MODULE$.apply(stream, parentContext));
            }
            left = right;
        } else {
            try (BufferedSource source = Source$.MODULE$.fromInputStream(stream, charset);){
                left = package$.MODULE$.Left().apply((Object)source.mkString());
            }
        }
        return left;
    }

    public Either<String, SeekableStream> org$mule$weave$v2$core$functions$WriteFunctionValue$$doWriteValue(Value<?> value, Writer writer, DataFormat<?, ?> dataFormat, LocationCapable location, EvaluationContext context) {
        Left left;
        Charset charset;
        writer.startDocument(location);
        writer.writeValue(value, context);
        writer.endDocument(location);
        Settings settings = writer.settings();
        if (settings instanceof ConfigurableEncoding) {
            ConfigurableEncoding configurableEncoding = (ConfigurableEncoding)settings;
            charset = configurableEncoding.charset(context);
        } else {
            charset = (Charset)dataFormat.defaultCharset().getOrElse((Function0 & Serializable & scala.Serializable)() -> context.serviceManager().charsetProviderService().defaultCharset());
        }
        Charset charset2 = charset;
        Object object = writer.result();
        if (object instanceof ByteArrayOutputStream) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)object;
            left = package$.MODULE$.Right().apply((Object)SeekableStream$.MODULE$.apply(byteArrayOutputStream.toByteArray(), context));
        } else if (object instanceof AutoPersistedOutputStream) {
            AutoPersistedOutputStream autoPersistedOutputStream = (AutoPersistedOutputStream)object;
            left = this.processResult((InputStream)((Object)autoPersistedOutputStream.toInputStream(context)), charset2.name(), dataFormat, context);
        } else if (object instanceof SeekableStream) {
            SeekableStream seekableStream = (SeekableStream)object;
            left = this.processResult((InputStream)((Object)seekableStream), charset2.name(), dataFormat, context);
        } else if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            left = this.processResult(inputStream, charset2.name(), dataFormat, context);
        } else if (object instanceof Object) {
            Object object2 = object;
            left = package$.MODULE$.Left().apply((Object)String.valueOf(object2));
        } else if (object == null) {
            left = package$.MODULE$.Left().apply((Object)"null");
        } else {
            throw new MatchError(object);
        }
        Left result = left;
        return result;
    }

    public String toDwString(Value<?> value, int maxLength, EvaluationContext ctx) {
        return StringHelper$.MODULE$.abbreviate(this.toDwString(value, this.toDwString$default$2(), ctx), maxLength);
    }

    public String toDwString(Value<?> value, boolean ignoreSchema, EvaluationContext ctx) {
        String string;
        try {
            String string2;
            Option<DataFormat<?, ?>> maybeFormat;
            Option<DataFormat<?, ?>> option = maybeFormat = DataFormatManager$.MODULE$.byContentType("application/dw", ctx);
            if (None$.MODULE$.equals(option)) {
                string2 = String.valueOf(value.evaluate(ctx));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                DataFormat dataFormat = (DataFormat)some.value();
                string2 = (String)TryClose$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> dataFormat.writer((Option<Object>)None$.MODULE$, dataFormat.writer$default$2(), ctx), (Function1 & Serializable & scala.Serializable)writer -> {
                    String string;
                    Either<String, SeekableStream> result;
                    writer.setOption(UnknownLocation$.MODULE$, "indent", "", ctx);
                    writer.setOption(UnknownLocation$.MODULE$, "ignoreSchema", BoxesRunTime.boxToBoolean((boolean)ignoreSchema), ctx);
                    Either<String, SeekableStream> either = result = MODULE$.org$mule$weave$v2$core$functions$WriteFunctionValue$$doWriteValue(value, (Writer)writer, dataFormat, value, ctx);
                    if (either instanceof Left) {
                        String str;
                        Left left = (Left)either;
                        string = str = (String)left.value();
                    } else if (either instanceof Right) {
                        Right right = (Right)either;
                        SeekableStream bytes = (SeekableStream)right.value();
                        string = BinaryHelper$.MODULE$.toBase64String(bytes, ctx.serviceManager().memoryService());
                    } else {
                        throw new MatchError(either);
                    }
                    return string;
                });
            } else {
                throw new MatchError(option);
            }
            string = string2;
        }
        catch (Exception e) {
            Value<?> value2 = value;
            String string3 = ArrayType$.MODULE$.accepts(value2, ctx) ? "[...]" : (ObjectType$.MODULE$.accepts(value2, ctx) ? "{...}" : String.valueOf(value));
            String result = string3;
            StringWriter writer2 = new StringWriter();
            e.printStackTrace(new PrintWriter(writer2));
            String className = value != null ? value.getClass().getSimpleName() : "Null";
            String message = new StringBuilder(91).append("Unexpected error while evaluating `WriteFunctionValue.toDwString( ").append(value.valueType(ctx)).append(" {class:'").append(className).append("'} )`. Reason :\n").append(writer2.toString()).toString();
            ctx.serviceManager().loggingService().logError(message);
            string = result;
        }
        return string;
    }

    public boolean toDwString$default$2() {
        return false;
    }

    private WriteFunctionValue$() {
        MODULE$ = this;
        this.DATA_WEAVE_MIMETYPE = "application/dw";
        this.maxValueLength = RuntimeConfigProperties$.MODULE$.MAX_STRING_VALUE_MESSAGE_LENGTH();
    }
}

