/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;

public class BundleDependencyHelper {
    private static final String ROOT_CONTEXT = "ROOT";
    private Map<String, Map<BundleDescriptor, BundleDependency>> contexts = new HashMap<String, Map<BundleDescriptor, BundleDependency>>();
    private final Stack<DependencyNode> dependenciesStack = new Stack();

    public BundleDependency getBundleDependency(DependencyNode node, DependencyFilter transitiveDependencyFilter) {
        Map context = this.contexts.computeIfAbsent(ROOT_CONTEXT, k -> new HashMap());
        return this.getBundleDependency(node, context, transitiveDependencyFilter);
    }

    private BundleDependency getBundleDependency(DependencyNode node, Map<BundleDescriptor, BundleDependency> context, DependencyFilter transitiveDependencyFilter) {
        DependencyNode effectiveNodeDependency = this.getEffectiveDependencyNode(node);
        Artifact artifact = effectiveNodeDependency.getArtifact();
        BundleDescriptor bundleDescriptor = BundleDependencyHelper.artifactToBundleDescriptor(artifact).build();
        Map<BundleDescriptor, BundleDependency> realContext = "mule-plugin".equals(artifact.getClassifier()) ? this.contexts.get(ROOT_CONTEXT) : context;
        BundleDependency cachedValue = realContext.get(bundleDescriptor);
        if (cachedValue != null) {
            return cachedValue;
        }
        String scope = effectiveNodeDependency.getDependency().getScope();
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf(scope.toUpperCase());
        BundleDependency.Builder bundleDependencyBuilder = BundleDependencyHelper.artifactToBundleDependency(effectiveNodeDependency.getArtifact(), bundleScope.name());
        Map<BundleDescriptor, BundleDependency> nextContext = this.getContext(effectiveNodeDependency, context);
        this.setNodeUnderAnalysis(effectiveNodeDependency);
        effectiveNodeDependency.getChildren().stream().map(this::getEffectiveDependencyNode).filter(children -> transitiveDependencyFilter.accept(children, Collections.emptyList())).forEach(childNode -> bundleDependencyBuilder.addTransitiveDependency(this.getBundleDependency((DependencyNode)childNode, nextContext, transitiveDependencyFilter)));
        this.removeNodeUnderAnalysis();
        BundleDependency bundleDependency = bundleDependencyBuilder.build();
        realContext.put(bundleDependency.getDescriptor(), bundleDependency);
        return bundleDependencyBuilder.build();
    }

    private DependencyNode getEffectiveDependencyNode(DependencyNode node) {
        DependencyNode winner;
        if (node.getData().containsKey("conflict.winner") && !this.isNodeUnderAnalysis(winner = (DependencyNode)node.getData().get("conflict.winner"))) {
            return winner;
        }
        return node;
    }

    private void setNodeUnderAnalysis(DependencyNode effectiveNodeDependency) {
        this.dependenciesStack.push(effectiveNodeDependency);
    }

    private void removeNodeUnderAnalysis() {
        this.dependenciesStack.pop();
    }

    private boolean isNodeUnderAnalysis(DependencyNode node) {
        return this.dependenciesStack.contains(node);
    }

    static BundleDependency.Builder artifactToBundleDependency(Artifact artifact, String scope) {
        BundleDescriptor.Builder bundleDescriptorBuilder = BundleDependencyHelper.artifactToBundleDescriptor(artifact);
        BundleScope bundleScope = StringUtils.isEmpty((CharSequence)scope) ? BundleScope.COMPILE : BundleScope.valueOf(scope.toUpperCase());
        BundleDependency.Builder builder = new BundleDependency.Builder().setDescriptor(bundleDescriptorBuilder.build()).setScope(bundleScope);
        if (artifact.getFile() != null) {
            builder.setBundleUri(artifact.getFile().toURI());
        }
        return builder;
    }

    static BundleDescriptor.Builder artifactToBundleDescriptor(Artifact artifact) {
        BundleDescriptor.Builder bundleDescriptorBuilder = new BundleDescriptor.Builder().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension());
        String classifier = artifact.getClassifier();
        if (!org.eclipse.aether.util.StringUtils.isEmpty((String)classifier)) {
            bundleDescriptorBuilder.setClassifier(classifier);
        }
        return bundleDescriptorBuilder;
    }

    private Map<BundleDescriptor, BundleDependency> getContext(DependencyNode node, Map<BundleDescriptor, BundleDependency> parentContext) {
        if ("mule-plugin".equals(node.getArtifact().getClassifier())) {
            String key = node.getArtifact().getGroupId() + ":" + node.getArtifact().getArtifactId();
            return this.contexts.computeIfAbsent(key, k -> new HashMap());
        }
        return parentContext;
    }
}

