/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.SerializedMetadataTypeLoader;
import org.mule.metadata.persistence.reduced.InnerCatalogObjectTypeReferenceHandler;
import org.mule.metadata.persistence.reduced.MetadataTypeCatalogLoader;

public class ReducedJsonMetadataTypeLoader
implements SerializedMetadataTypeLoader {
    @Override
    public Optional<MetadataType> load(String serialized) {
        JsonElement element = new JsonParser().parse(serialized);
        return this.loadFromElement(element);
    }

    @Override
    public Optional<MetadataType> load(JsonElement jsonElement) {
        return this.loadFromElement(jsonElement);
    }

    private Optional<MetadataType> loadFromElement(JsonElement element) {
        JsonObject value = element.getAsJsonObject().get("value").getAsJsonObject();
        JsonElement catalogElement = element.getAsJsonObject().get("catalog");
        return new JsonMetadataTypeLoader(new InnerCatalogObjectTypeReferenceHandler(this.getCatalog(catalogElement))).load((JsonElement)value);
    }

    private Map<String, MetadataType> getCatalog(JsonElement catalogElement) {
        return catalogElement != null ? MetadataTypeCatalogLoader.loadCatalog(catalogElement.getAsJsonObject()) : Collections.emptyMap();
    }
}

