/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto.factory;

import java.util.Optional;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.internal.serialization.dto.ComponentParameterAstDTO;
import org.mule.runtime.ast.internal.serialization.dto.ParameterValueContainer;
import org.mule.runtime.ast.internal.serialization.dto.factory.AstDTOFactoryProvider;
import org.mule.runtime.ast.internal.serialization.dto.factory.ParameterValueContainerFactory;

public class ComponentParameterAstDTOFactory {
    private final AstDTOFactoryProvider astDTOFactoryProvider;
    private final ParameterValueContainerFactory parameterValueContainerFactory;

    public ComponentParameterAstDTOFactory(AstDTOFactoryProvider astDTOFactoryProvider) {
        this.astDTOFactoryProvider = astDTOFactoryProvider;
        this.parameterValueContainerFactory = new ParameterValueContainerFactory(astDTOFactoryProvider);
    }

    public ComponentParameterAstDTO from(ComponentParameterAst componentParameterAst) {
        return new ComponentParameterAstDTO(this.getParameterValueContainer(componentParameterAst), componentParameterAst.getRawValue(), this.getDefaultValue(componentParameterAst), componentParameterAst.getMetadata().map(metadata -> this.astDTOFactoryProvider.getComponentMetadataAstDTOFactory().from((ComponentMetadataAst)metadata)).orElse(null), this.getGroupModelName(componentParameterAst), componentParameterAst.getModel().getName());
    }

    private String getGroupModelName(ComponentParameterAst componentParameterAst) {
        return Optional.ofNullable(componentParameterAst.getGroupModel()).map(NamedObject::getName).orElse(null);
    }

    private boolean getDefaultValue(ComponentParameterAst componentParameterAst) {
        try {
            return componentParameterAst.isDefaultValue();
        }
        catch (MuleRuntimeException e) {
            return false;
        }
    }

    private ParameterValueContainer getParameterValueContainer(ComponentParameterAst componentParameterAst) {
        try {
            return this.parameterValueContainerFactory.from(componentParameterAst);
        }
        catch (MuleRuntimeException e) {
            return null;
        }
    }
}

