/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.metadata.api.dsl.DslElementModel;

public final class ArtifactDeclarationUtils {
    private ArtifactDeclarationUtils() {
    }

    public static ArtifactAst toArtifactast(ArtifactDeclaration artifactDeclaration, Set<ExtensionModel> extensionModels) {
        ArtifactAstBuilder astBuilder = ArtifactAstBuilder.builder(extensionModels, Optional.empty());
        ArtifactDeclarationUtils.convertArtifactDeclarationToComponentModel(extensionModels, artifactDeclaration, astBuilder);
        return astBuilder.build();
    }

    private static void convertArtifactDeclarationToComponentModel(Set<ExtensionModel> extensionModels, ArtifactDeclaration artifactDeclaration, ArtifactAstBuilder astBuilder) {
        if (artifactDeclaration != null && !extensionModels.isEmpty()) {
            ExtensionModel muleModel = MuleExtensionModelProvider.getExtensionModel();
            if (!extensionModels.contains(muleModel)) {
                extensionModels = new HashSet<ExtensionModel>(extensionModels);
                extensionModels.add(muleModel);
            }
            DslElementModelFactory elementFactory = DslElementModelFactory.getDefault(DslResolvingContext.getDefault(extensionModels));
            artifactDeclaration.getGlobalElements().stream().map(e -> elementFactory.create((ElementDeclaration)((Object)e))).filter(Optional::isPresent).map(e -> ((DslElementModel)e.get()).getConfiguration()).forEach(config -> config.ifPresent(c -> ArtifactDeclarationUtils.convertComponentConfiguration(c, astBuilder.addTopLevelComponent())));
        }
    }

    private static void convertComponentConfiguration(ComponentConfiguration componentConfiguration, ComponentAstBuilder componentAstBuilder) {
        componentAstBuilder.withIdentifier(componentConfiguration.getIdentifier()).withMetadata(ComponentMetadataAst.EMPTY_METADATA);
        for (Map.Entry<String, String> parameter : componentConfiguration.getParameters().entrySet()) {
            componentAstBuilder.withRawParameter(parameter.getKey(), parameter.getValue());
        }
        componentConfiguration.getValue().ifPresent(value -> componentAstBuilder.withBodyParameter((String)value));
        for (ComponentConfiguration childComponentConfiguration : componentConfiguration.getNestedComponents()) {
            ArtifactDeclarationUtils.convertComponentConfiguration(childComponentConfiguration, componentAstBuilder.addChildComponent());
        }
    }
}

