/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.util.ResourceLocator;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.config.api.dsl.model.metadata.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.config.internal.context.AbstractSpringMuleContextServiceConfigurator;
import org.mule.runtime.config.internal.context.NoOpLazyComponentInitializer;
import org.mule.runtime.config.internal.context.metrics.NoopMeterProvider;
import org.mule.runtime.config.internal.factories.ConstantFactoryBean;
import org.mule.runtime.config.internal.factories.ExtensionManagerFactoryBean;
import org.mule.runtime.config.internal.factories.MuleContextFactoryBean;
import org.mule.runtime.config.internal.factories.TransactionManagerFactoryBean;
import org.mule.runtime.config.internal.model.dsl.config.DefaultComponentInitialStateManager;
import org.mule.runtime.config.internal.processor.MuleObjectNameProcessor;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.config.internal.registry.SpringRegistryBootstrap;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.streaming.DefaultStreamingManager;
import org.mule.runtime.core.internal.cluster.DefaultClusterService;
import org.mule.runtime.core.internal.config.CustomService;
import org.mule.runtime.core.internal.config.CustomServiceRegistry;
import org.mule.runtime.core.internal.config.DefaultFeatureManagementService;
import org.mule.runtime.core.internal.config.bootstrap.AbstractRegistryBootstrap;
import org.mule.runtime.core.internal.connection.DefaultConnectivityTesterFactory;
import org.mule.runtime.core.internal.connection.DelegateConnectionManagerAdapter;
import org.mule.runtime.core.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationDispatcher;
import org.mule.runtime.core.internal.context.notification.DefaultNotificationListenerRegistry;
import org.mule.runtime.core.internal.context.notification.MessageProcessingFlowTraceManager;
import org.mule.runtime.core.internal.el.function.MuleFunctionsBindingContextProvider;
import org.mule.runtime.core.internal.event.DefaultEventContextService;
import org.mule.runtime.core.internal.exception.MessagingExceptionLocationProvider;
import org.mule.runtime.core.internal.execution.MuleMessageProcessingManager;
import org.mule.runtime.core.internal.lock.MuleLockFactory;
import org.mule.runtime.core.internal.lock.SingleServerLockProvider;
import org.mule.runtime.core.internal.management.stats.DefaultProcessingTimeWatcher;
import org.mule.runtime.core.internal.policy.DefaultPolicyManager;
import org.mule.runtime.core.internal.processor.interceptor.DefaultProcessorInterceptorManager;
import org.mule.runtime.core.internal.profiling.ProfilingServiceWrapper;
import org.mule.runtime.core.internal.security.DefaultMuleSecurityManager;
import org.mule.runtime.core.internal.streaming.StreamingGhostBuster;
import org.mule.runtime.core.internal.time.LocalTimeSupplier;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.mule.runtime.core.internal.transformer.DynamicDataTypeConversionResolver;
import org.mule.runtime.core.internal.util.DefaultStreamCloserService;
import org.mule.runtime.core.internal.util.queue.TransactionalQueueManager;
import org.mule.runtime.core.internal.util.store.DefaultObjectStoreFactoryBean;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.core.internal.value.MuleValueProviderService;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.mule.runtime.internal.config.custom.ServiceConfiguratorUtils;
import org.mule.runtime.metadata.internal.MuleMetadataService;
import org.mule.runtime.metadata.internal.cache.DefaultPersistentMetadataCacheManager;
import org.mule.runtime.metrics.exporter.impl.OpenTelemetryMeterExporterFactory;
import org.mule.runtime.metrics.exporter.impl.optel.config.OpenTelemetryAutoConfigurableMeterExporterConfiguration;
import org.mule.runtime.metrics.impl.DefaultMeterProvider;
import org.mule.runtime.module.extension.api.runtime.compatibility.DefaultForwardCompatibilityHelper;
import org.mule.runtime.module.extension.internal.data.sample.MuleSampleDataService;
import org.mule.runtime.module.extension.internal.store.SdkObjectStoreManagerAdapter;
import org.mule.runtime.module.extension.internal.type.catalog.DefaultArtifactTypeLoader;
import org.mule.runtime.tracer.customization.impl.provider.DefaultInitialSpanInfoProvider;
import org.mule.runtime.tracer.exporter.impl.OpenTelemetrySpanExporterFactory;
import org.mule.runtime.tracer.exporter.impl.optel.config.OpenTelemetryAutoConfigurableSpanExporterConfiguration;
import org.mule.runtime.tracer.impl.CoreEventComponentTracerFactory;
import org.mule.runtime.tracer.impl.SelectableCoreEventTracer;
import org.mule.runtime.tracer.impl.span.factory.ExecutionSpanFactory;
import org.mule.runtime.tracing.level.impl.config.FileTracingLevelConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;

public class SpringMuleContextServiceConfigurator
extends AbstractSpringMuleContextServiceConfigurator {
    private final MuleContextWithRegistry muleContext;
    private final ArtifactType artifactType;
    private final ArtifactAst artifactAst;
    private final OptionalObjectsController optionalObjectsController;
    private final ResourceLocator resourceLocator;
    private static final ImmutableSet<String> APPLICATION_ONLY_SERVICES = ImmutableSet.builder().add((Object)"_muleSecurityManager").add((Object)"_muleMessageProcessingManager").add((Object)"_muleStreamCloserService").add((Object)"_muleProcessingTimeWatcher").add((Object)"_mulePolicyManager").add((Object)"_muleExceptionLocationProvider").add((Object)"_muleMessageProcessingFlowTraceManager").build();
    private static final ImmutableMap<String, String> OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME = ImmutableMap.builder().put((Object)"_defaultInMemoryObjectStore", (Object)"_localInMemoryObjectStore").put((Object)"_defaultPersistentObjectStore", (Object)"_localPersistentObjectStore").build();
    private final ImmutableMap<String, BeanDefinition> defaultContextServices = ImmutableMap.builder().put((Object)"_muleTransactionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionManagerFactoryBean.class)).put((Object)"_muleExtensionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtensionManagerFactoryBean.class)).put((Object)"_muleTimeSupplier", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(LocalTimeSupplier.class)).put((Object)"_muleConnectionManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DelegateConnectionManagerAdapter.class)).put((Object)"_muleConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMuleConfiguration.class)).put((Object)"_muleTransactionFactoryLocator", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionFactoryLocator.class)).put((Object)"_muleObjectNameProcessor", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleObjectNameProcessor.class)).put((Object)"_mulePolicyManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPolicyManager.class)).put((Object)"_muleInterceptorManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessorInterceptorManager.class)).put((Object)"_muleNotificationDispatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationDispatcher.class)).put((Object)"_muleNotificationListenerRegistry", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultNotificationListenerRegistry.class)).put((Object)"_muleEventContextService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultEventContextService.class)).put((Object)"_defaultInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localInMemoryObjectStore").getBeanDefinition()).put((Object)"_localInMemoryObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultInMemoryObjectStore")).put((Object)"_defaultPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(ConstantFactoryBean.class).addConstructorArgReference("_localPersistentObjectStore").getBeanDefinition()).put((Object)"_localPersistentObjectStore", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultObjectStoreFactoryBean.class, "createDefaultPersistentObjectStore")).put((Object)"_muleObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getPrimaryBeanDefinition(MuleObjectStoreManager.class)).put((Object)"_sdkObjectStoreManager", (Object)SpringMuleContextServiceConfigurator.getPrimaryBeanDefinition(SdkObjectStoreManagerAdapter.class)).put((Object)"_muleQueueManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionalQueueManager.class)).put((Object)"_muleSecurityManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMuleSecurityManager.class)).put((Object)"_muleMessageProcessingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMessageProcessingManager.class)).put((Object)"_muleStreamCloserService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamCloserService.class)).put((Object)"_converterResolver", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DynamicDataTypeConversionResolver.class)).put((Object)"_muleLockFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleLockFactory.class)).put((Object)"_muleLockProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SingleServerLockProvider.class)).put((Object)"_muleProcessingTimeWatcher", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultProcessingTimeWatcher.class)).put((Object)"_muleExceptionLocationProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessagingExceptionLocationProvider.class)).put((Object)"_muleMessageProcessingFlowTraceManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MessageProcessingFlowTraceManager.class)).put((Object)"_muleComponentInitialStateManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultComponentInitialStateManager.class)).put((Object)"_muleStreamingManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultStreamingManager.class)).put((Object)"_muleStreamingGhostBuster", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(StreamingGhostBuster.class)).put((Object)"_artifactTypeLoader", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultArtifactTypeLoader.class)).put((Object)"_muleTransformationService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExtendedTransformationService.class)).put((Object)"_muleClusterService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultClusterService.class)).put((Object)"_muleConnectivityTesterFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectivityTesterFactory.class)).put((Object)"_muleLazyComponentInitializer", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(NoOpLazyComponentInitializer.class)).put((Object)"_muleSpanExporterConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryAutoConfigurableSpanExporterConfiguration.class)).put((Object)"_muleProfilingService", (Object)this.getBeanDefinitionForProfilingService()).put((Object)"_muleCoreSpanFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ExecutionSpanFactory.class)).put((Object)"_muleCoreExporterFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetrySpanExporterFactory.class)).put((Object)"_muleCoreEventTracer", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(SelectableCoreEventTracer.class)).put((Object)"_muleCoreComponentTracerFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(CoreEventComponentTracerFactory.class)).put((Object)"_muleMeterProvider", (Object)SpringMuleContextServiceConfigurator.resolveMeterProvider()).put((Object)"_muleMeterExporterConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryAutoConfigurableMeterExporterConfiguration.class)).put((Object)"_muleMeterExporterFactory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(OpenTelemetryMeterExporterFactory.class)).put((Object)"_muleTracingLevelConfiguration", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(FileTracingLevelConfiguration.class)).put((Object)"_muleTracerInitialSpanInfoProvider", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultInitialSpanInfoProvider.class)).put((Object)"PROFILING_FEATURE_MANAGEMENT_SERVICE", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultFeatureManagementService.class)).put((Object)"_muleForwardCompatibilityHelper", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultForwardCompatibilityHelper.class)).build();
    private final ImmutableMap<String, BeanDefinition> toolingContextServices = ImmutableMap.builder().put((Object)"_muleMetadataService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleMetadataService.class)).put((Object)"_muleValueProviderService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleValueProviderService.class)).put((Object)"_muleSampleDataService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(MuleSampleDataService.class)).put((Object)"_muleConnectivityTestingService", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultConnectivityTestingService.class)).put((Object)"_metadataCacheManager", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultPersistentMetadataCacheManager.class)).put((Object)"metadata.cache.id.model.generator.factory", (Object)SpringMuleContextServiceConfigurator.getBeanDefinition(ModelBasedMetadataCacheIdGeneratorFactory.class)).build();
    private final MuleFunctionsBindingContextProvider coreFunctionsProvider;
    private final ConfigurationProperties configurationProperties;
    private final Map<String, String> artifactProperties;
    private final boolean addToolingObjectsToRegistry;
    private final MemoryManagementService memoryManagementService;

    public SpringMuleContextServiceConfigurator(MuleContextWithRegistry muleContext, MuleFunctionsBindingContextProvider coreFunctionsProvider, ConfigurationProperties configurationProperties, Map<String, String> artifactProperties, boolean addToolingObjectsToRegistry, ArtifactType artifactType, ArtifactAst artifactAst, OptionalObjectsController optionalObjectsController, BeanDefinitionRegistry beanDefinitionRegistry, Registry serviceLocator, ResourceLocator resourceLocator, MemoryManagementService memoryManagementService) {
        super((CustomServiceRegistry)muleContext.getCustomizationService(), beanDefinitionRegistry, serviceLocator);
        this.muleContext = muleContext;
        this.coreFunctionsProvider = coreFunctionsProvider;
        this.configurationProperties = configurationProperties;
        this.artifactProperties = artifactProperties;
        this.addToolingObjectsToRegistry = addToolingObjectsToRegistry;
        this.artifactType = artifactType;
        this.artifactAst = artifactAst;
        this.optionalObjectsController = optionalObjectsController;
        this.resourceLocator = resourceLocator;
        this.memoryManagementService = memoryManagementService;
    }

    private BeanDefinition getBeanDefinitionForProfilingService() {
        return SpringMuleContextServiceConfigurator.getBeanDefinition(ProfilingServiceWrapper.class);
    }

    protected void createArtifactServices() {
        this.registerBeanDefinition("_muleContext", this.createMuleContextDefinition());
        this.registerConstantBeanDefinition("_muleDefaultObjectSerializer", this.muleContext.getObjectSerializer());
        this.registerConstantBeanDefinition("_muleConfigurationAttributesResolver", this.configurationProperties);
        this.registerConstantBeanDefinition("_muleNotificationHandler", this.muleContext.getNotificationManager());
        this.registerConstantBeanDefinition("_muleStatistics", this.muleContext.getStatistics());
        this.registerConstantBeanDefinition("_muleResourceLocator", this.resourceLocator);
        this.registerConstantBeanDefinition("_muleMemoryManagementService", this.memoryManagementService);
        this.loadServiceConfigurators();
        this.registerContextServices((Map<String, BeanDefinition>)this.defaultContextServices);
        if (this.isAddToolingObjectsToRegistry()) {
            this.registerContextServices((Map<String, BeanDefinition>)this.toolingContextServices);
        }
        this.createBootstrapBeanDefinitions();
        this.createLocalObjectStoreBeanDefinitions();
        this.createLocalLockFactoryBeanDefinitions();
        this.createQueueManagerBeanDefinitions();
        this.createCustomServices();
        this.coreFunctionsProvider.setConfigurationProperties(this.configurationProperties);
        this.registerConstantBeanDefinition("core.global.binding.provider", this.coreFunctionsProvider);
        this.artifactProperties.forEach((k, v) -> this.registerConstantBeanDefinition((String)k, v));
        if (Boolean.valueOf(this.artifactProperties.getOrDefault("mule.application.deployment.addArtifactAstToRegistry", Boolean.FALSE.toString())).booleanValue()) {
            this.registerConstantBeanDefinition("_muleArtifactAst", this.artifactAst);
        }
    }

    private void registerContextServices(Map<String, BeanDefinition> contextServices) {
        contextServices.entrySet().stream().filter(service -> !APPLICATION_ONLY_SERVICES.contains(service.getKey()) || this.artifactType.equals((Object)ArtifactType.APP) || this.artifactType.equals((Object)ArtifactType.POLICY)).forEach(service -> this.registerBeanDefinition((String)service.getKey(), (BeanDefinition)service.getValue()));
    }

    private void loadServiceConfigurators() {
        ServiceConfiguratorUtils.lookupServiceConfigurators().forEach(customizationInfo -> customizationInfo.configure(this.getCustomServiceRegistry()));
    }

    private void createCustomServices() {
        Map<String, CustomService> customServices = this.getCustomServiceRegistry().getCustomServices();
        for (String serviceName : customServices.keySet()) {
            if (this.containsBeanDefinition(serviceName)) {
                throw new IllegalStateException("There is already a bean definition registered with key: " + serviceName);
            }
            CustomService customService = customServices.get(serviceName);
            if (this.isServiceRuntimeProvided(customService)) continue;
            BeanDefinition beanDefinition = this.getCustomServiceBeanDefinition(customService, serviceName);
            this.registerBeanDefinition(serviceName, beanDefinition);
        }
    }

    private void createQueueManagerBeanDefinitions() {
        AtomicBoolean customManagerDefined = new AtomicBoolean(false);
        this.getCustomServiceRegistry().getOverriddenService("_muleQueueManager").ifPresent(customService -> {
            customManagerDefined.set(true);
            this.registerBeanDefinition("_muleQueueManager", this.getCustomServiceBeanDefinition((CustomService)customService, "_muleQueueManager"));
        });
        if (customManagerDefined.get()) {
            this.registerBeanDefinition("_localQueueManager", SpringMuleContextServiceConfigurator.getBeanDefinition(TransactionalQueueManager.class));
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleQueueManager", "_localQueueManager");
        }
    }

    private void createLocalLockFactoryBeanDefinitions() {
        AtomicBoolean customLockFactoryWasDefined = new AtomicBoolean(false);
        this.getCustomServiceRegistry().getOverriddenService("_muleLockFactory").ifPresent(customService -> {
            customLockFactoryWasDefined.set(true);
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLockFactory", this.getCustomServiceBeanDefinition((CustomService)customService, "_muleLockFactory"));
        });
        if (customLockFactoryWasDefined.get()) {
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLocalLockFactory", (BeanDefinition)this.defaultContextServices.get((Object)"_muleLockFactory"));
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleLockFactory", "_muleLocalLockFactory");
        }
    }

    private void createLocalObjectStoreBeanDefinitions() {
        AtomicBoolean anyBaseStoreWasRedefined = new AtomicBoolean(false);
        OBJECT_STORE_NAME_TO_LOCAL_OBJECT_STORE_NAME.entrySet().forEach(objectStoreLocal -> this.getCustomServiceRegistry().getOverriddenService((String)objectStoreLocal.getKey()).ifPresent(customService -> {
            anyBaseStoreWasRedefined.set(true);
            this.getBeanDefinitionRegistry().registerBeanDefinition((String)objectStoreLocal.getKey(), this.getCustomServiceBeanDefinition((CustomService)customService, (String)objectStoreLocal.getKey()));
        }));
        if (anyBaseStoreWasRedefined.get()) {
            AbstractBeanDefinition beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleObjectStoreManager.class).addPropertyValue("basePersistentStoreKey", (Object)"_localPersistentObjectStore").addPropertyValue("baseTransientStoreKey", (Object)"_localInMemoryObjectStore").getBeanDefinition();
            beanDefinition.setPrimary(false);
            this.getBeanDefinitionRegistry().registerBeanDefinition("_muleLocalObjectStoreManager", (BeanDefinition)beanDefinition);
        } else {
            this.getBeanDefinitionRegistry().registerAlias("_muleObjectStoreManager", "_muleLocalObjectStoreManager");
        }
    }

    private BeanDefinition createMuleContextDefinition() {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(MuleContextFactoryBean.class).addConstructorArgValue((Object)this.muleContext).getBeanDefinition();
    }

    protected void createBootstrapBeanDefinitions() {
        try {
            SpringRegistryBootstrap springRegistryBootstrap = new SpringRegistryBootstrap(this.artifactType, this.muleContext, this.optionalObjectsController, this::registerBeanDefinition, AbstractRegistryBootstrap.BINDING_PROVIDER_PREDICATE.or(AbstractRegistryBootstrap.TRANSFORMER_PREDICATE).or(propertyKey -> propertyKey.endsWith("_compatibilityPluginInstalled")).negate());
            springRegistryBootstrap.initialise();
        }
        catch (InitialisationException e) {
            throw new RuntimeException(e);
        }
    }

    private static BeanDefinition getPrimaryBeanDefinition(Class<?> beanType) {
        BeanDefinition beanDefinition = SpringMuleContextServiceConfigurator.getBeanDefinition(beanType);
        beanDefinition.setPrimary(true);
        return beanDefinition;
    }

    private static BeanDefinition getBeanDefinition(Class<?> beanType, String factoryMethodName) {
        return SpringMuleContextServiceConfigurator.getBeanDefinitionBuilder(beanType).setFactoryMethod(factoryMethodName).getBeanDefinition();
    }

    protected MuleContextWithRegistry getMuleContext() {
        return this.muleContext;
    }

    protected Map<String, String> getArtifactProperties() {
        return this.artifactProperties;
    }

    protected boolean isAddToolingObjectsToRegistry() {
        return this.addToolingObjectsToRegistry;
    }

    protected MemoryManagementService getMemoryManagementService() {
        return this.memoryManagementService;
    }

    private static BeanDefinition resolveMeterProvider() {
        if (Boolean.getBoolean("mule.open.telemetry.metric.exporter")) {
            return SpringMuleContextServiceConfigurator.getBeanDefinition(DefaultMeterProvider.class);
        }
        return SpringMuleContextServiceConfigurator.getBeanDefinition(NoopMeterProvider.class);
    }
}

