/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.scheduler.SchedulingStrategy;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.IgnoreOnLazyInit;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

@IgnoreOnLazyInit
public class PollingSourceHasSchedulingStrategy
implements Validation {
    @Override
    public String getName() {
        return "Polling source has scheduling strategy set";
    }

    @Override
    public String getDescription() {
        return "Polling source has scheduling strategy set";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(component -> component.getModel(SourceModel.class).flatMap(srcModel -> srcModel.getAllParameterModels().stream().filter(pm -> this.isScheduler(pm.getType())).findAny()).isPresent());
    }

    private boolean isScheduler(MetadataType type) {
        return MetadataTypeUtils.getTypeId(type).filter(typeId -> SchedulingStrategy.class.getName().equals(typeId)).isPresent();
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        Pair schedulingStrategyParamModel = (Pair)component.getModel(SourceModel.class).flatMap(srcModel -> ExtensionModelUtils.getGroupAndParametersPairs(srcModel).filter(pm -> this.isScheduler(((ParameterModel)pm.getSecond()).getType())).findAny()).get();
        if (component.getParameter(((ParameterGroupModel)schedulingStrategyParamModel.getFirst()).getName(), ((ParameterModel)schedulingStrategyParamModel.getSecond()).getName()).getValue().getRight() == null) {
            return Optional.of(ValidationResultItem.create(component, (Validation)this, "The scheduling strategy has not been configured."));
        }
        return Optional.empty();
    }
}

